<h1>WPSSO Core</h1><h3>Advanced Meta Tags and Schema Markup for Facebook, Google, Pinterest, Twitter, SEO and More</h3>

<table>
<tr><th align="right" valign="top" nowrap>Plugin Name</th><td>WPSSO Core [Main Plugin]</td></tr>
<tr><th align="right" valign="top" nowrap>Summary</th><td>WPSSO Core makes sure your content looks great on all social and search sites, no matter how it&#039;s crawled, shared, re-shared, posted or embedded!</td></tr>
<tr><th align="right" valign="top" nowrap>Stable Version</th><td>4.22.0</td></tr>
<tr><th align="right" valign="top" nowrap>Requires At Least</th><td>WordPress 3.8</td></tr>
<tr><th align="right" valign="top" nowrap>Tested Up To</th><td>WordPress 5.0</td></tr>
<tr><th align="right" valign="top" nowrap>Contributors</th><td>jsmoriss</td></tr>
<tr><th align="right" valign="top" nowrap>License</th><td><a href="https://www.gnu.org/licenses/gpl.txt">GPLv3</a></td></tr>
<tr><th align="right" valign="top" nowrap>Tags / Keywords</th><td>open graph, rich pins, rich cards, twitter cards, schema, social media, meta tags, merchant, seo, yoast seo, woocommerce, facebook, google, pinterest, twitter, linkedin, whatsapp, skype</td></tr>
</table>

<h2>Description</h2>

<p style="margin:0;"><img class="readme-icon" src="https://surniaulula.github.io/wpsso/assets/icon-256x256.png"></p>

<h3 class="top">What makes WPSSO Core better?</h3>

<p><strong>Makes sure your content looks great on all social and search sites - no matter how it's crawled, shared, re-shared, posted, or embedded!</strong></p>

<p>WPSSO Core makes sure that all social crawlers, search crawlers, web browser extensions, mail and messaging apps (Facebook Messenger, iMessage, Skype, WhatsApp, etc.), and embedded object / iframe content, always get <em>accurate and complete</em> information about your webpage content, business, and authors.</p>

<p><strong>Uses your <em>existing content</em> for meta tags and Schema markup:</strong></p>

<p>There's no need to manually re-enter descriptions, titles, product information, select images / videos, etc. &mdash; WPSSO Core reads your existing content automatically and offers fine-tuning and customization options for just about anything and everything. ;-)</p>

<p>WPSSO Core is language / locale aware, which means you can customize your site information, social page URLs and Knowledge Graph for different languages!</p>

<p><strong>Creates <em>accurate and complete</em> meta tags and Schema markup:</strong></p>

<p>WPSSO Core and its optional add-ons offer meta tags and Schema markup for Facebook / Open Graph, Google's Knowledge Graph SEO, Google Rich Card SEO, Google Merchant SEO, Mobile Web Browsers, Pinterest Rich Pins, Twitter Cards, Weibo and many more &mdash; including complete markup for images, videos, extensive eCommerce product markup, mobile apps, author profile / authorship, co-authors, publisher information, local business markup, aggregate ratings, reviews, recipe information, event details, and much, much more &mdash; all from your existing content!</p>

<p><strong>Includes advanced <em>quality assurance</em> features and options:</strong></p>

<ol>
<li>Checks for minimum / maximum image dimensions and aspect ratios.</li>
<li>Shows notices for missing and required images.</li>
<li>Verifies webpages for duplicate meta tags.</li>
<li>Validates theme header templates for correct HTML markup.</li>
<li>Checks and warns of any missing PHP modules.</li>
<li>Checks 3rd party plugin settings for possible conflicts.</li>
</ol>

<h3>Users Love the WPSSO Core Plugin</h3>

<p>&#x2605;&#x2605;&#x2605;&#x2605;&#x2605; &mdash; "The plugin is indispensable to me when it comes to posting on social media... it makes it so that your posts look the best that they possible can every time when posting on Facebook, Twitter, or any other site." - <a href="https://wordpress.org/support/topic/this-is-probably-the-best-plugin-of-its-kind/">monsuirette</a></p>

<p>&#x2605;&#x2605;&#x2605;&#x2605;&#x2605; &mdash; "What a fantastic plugin. If you want to fix all the errors in search console for structured data, this is the plugin to use. Love it." - <a href="https://wordpress.org/support/topic/makes-schema-so-easy/">goviral</a></p>

<p>&#x2605;&#x2605;&#x2605;&#x2605;&#x2605; &mdash; "This plugin saves me so much time, and it has really lifted my SERP rankings. Most of my keywords I now rank 1-3 position. I also noticed after about a week that my impressions have gone up at least 75%. I upgraded to the pro version which gave me even more options." - <a href="https://wordpress.org/support/topic/excellent-plugin-and-support-200/">playnstocks</a></p>

<p>&#x2605;&#x2605;&#x2605;&#x2605;&#x2605; &mdash; "Yoast on steroids! As an SEO marketer, I love using Yoast for my basic on-page SEO. But Yoast only allows you to enter basic Open Graph social settings. This plugin gives you SO many more options on completing the Open Graph for Facebook, Twitter cards, Pinterest etc. If you use WordPress, I totally recommend using this plugin to help with better rankings in the SERPS!" - <a href="https://wordpress.org/support/topic/yoast-on-steroids/">gregmontag</a></p>

<h3>WPSSO Core Standard Features</h3>

<ul>
<li><p>Complete and accurate meta tags for all social sites, search engines, web browser extensions, mail and messaging apps, and embedded object / iframe content.</p></li>
<li><p>Provides meta tags and markup for custom post types, custom taxonomy / terms, user profile pages, and attachment pages.</p></li>
<li><p>Uses images from several sources, including featured, attached, gallery shortcode, images from HTML tags, or a custom fallback image.</p></li>
<li><p>Customizable image dimensions for Facebook / Open Graph, Schema markup, Google Rich Card SEO, Pinterest Rich Pins, and Twitter Cards.</p></li>
<li><p>Contextual help for <em>every</em> plugin option and <a href="https://wpsso.com/docs/plugins/wpsso/">comprehensive online documentation</a>.</p></li>
<li><p>Built-in support for <a href="https://wordpress.org/plugins/amp/">Accelerated Mobile Pages (AMP)</a> and <a href="https://wordpress.org/plugins/accelerated-mobile-pages/">AMP for WP - Accelerated Mobile Pages</a> plugins.</p></li>
<li><p>Supports advanced WordPress configurations, including WordPress Network / Multisite installations and WordPress MU Domain Mapping.</p></li>
<li><p>Includes an option to hide the preview of all Pro settings and features. ;-)</p></li>
<li><p>Free add-ons for additional functionality:</p>

<ul>
<li><a href="https://wordpress.org/plugins/wpsso-am/">WPSSO Mobile App Meta</a> to manage mobile App information.</li>
<li><a href="https://wordpress.org/plugins/wpsso-organization/">WPSSO Organization Markup</a> to manage multiple Organizations.</li>
<li><a href="https://wordpress.org/plugins/wpsso-plm/">WPSSO Place / Location and Local Business Meta</a> to manage multiple Locations.</li>
<li><a href="https://wordpress.org/plugins/wpsso-ratings-and-reviews/">WPSSO Ratings and Reviews</a> to add ratings in WordPress comments.</li>
<li><a href="https://wordpress.org/plugins/wpsso-rest-api/">WPSSO REST API</a> to add meta tags and Schema markup in REST API queries.</li>
<li><a href="https://wordpress.org/plugins/wpsso-rrssb/">WPSSO Ridiculously Responsive Social Sharing Buttons</a> to add responsive share buttons.</li>
<li><a href="https://wordpress.org/plugins/wpsso-breadcrumbs/">WPSSO Schema Breadcrumbs Markup</a> to add Breadcrumbs markup for Google.</li>
<li><a href="https://wordpress.org/plugins/wpsso-schema-json-ld/">WPSSO Schema JSON-LD Markup</a> to add JSON-LD in post and archive pages.</li>
<li><a href="https://wordpress.org/plugins/wpsso-ssb/">WPSSO Social Sharing Buttons</a> to add traditional share buttons.</li>
<li><a href="https://wordpress.org/plugins/wpsso-strip-schema-microdata">WPSSO Strip Schema Microdata</a> to strip incorrect markup from templates.</li>
<li><a href="https://wordpress.org/plugins/wpsso-tune-image-editors">WPSSO Tune WP Image Editors</a> for better looking WordPress thumbnails.</li>
<li><a href="https://wordpress.org/plugins/wpsso-tweet-a-quote">WPSSO Tweet a Quote</a> to add tweetable quotes to your content.</li>
<li><a href="https://wordpress.org/plugins/wpsso-user-locale">WPSSO User Locale Selector</a> to switch languages quickly and easily.</li>
</ul></li>
</ul>

<h3>WPSSO Core Additional Features (Pro version)</h3>

<ul>
<li><p>Customize default values in the Document SSO metabox when editing posts, pages, custom post types, terms (categories and tags, custom post types, and user profiles:</p>

<ul>
<li>Customize Text

<ul>
<li>Open Graph Type</li>
<li>Article Topic</li>
<li>Default Title</li>
<li>Default Description</li>
<li>Search Description</li>
<li>Schema Description</li>
<li>Twitter Card Description</li>
<li>Sharing URL</li>
<li>Canonical URL</li>
<li>Product Availability</li>
<li>Product Brand</li>
<li>Product Color</li>
<li>Product Condition</li>
<li>Product Material</li>
<li>Product SKU</li>
<li>Product EAN</li>
<li>Product GTIN-8</li>
<li>Product GTIN-12</li>
<li>Product GTIN-13</li>
<li>Product GTIN-14</li>
<li>Product ISBN</li>
<li>Product Price</li>
<li>Product Size</li>
<li>Product Target Gender</li>
</ul></li>
<li>Priority Media

<ul>
<li>All Social WebSites / Open Graph

<ul>
<li>Priority Image Information

<ul>
<li>Maximum Images</li>
<li>Image Dimensions</li>
<li>Image ID</li>
<li>or Image URL</li>
</ul></li>
<li>Priority Video Information

<ul>
<li>Maximum Videos</li>
<li>Video Dimensions</li>
<li>or Video URL</li>
<li>Video Name / Title</li>
<li>Video Description</li>
</ul></li>
</ul></li>
<li>Twitter Card

<ul>
<li>Image Dimensions</li>
<li>Image ID</li>
<li>or Image URL</li>
<li>Structured Data / Schema Markup / Pinterest</li>
<li>Maximum Images</li>
<li>Image Dimensions</li>
<li>Image ID</li>
<li>or Image URL</li>
</ul></li>
</ul></li>
</ul></li>
<li><p>Additional custom Schema property options are also available from the <a href="https://wpsso.com/extend/plugins/wpsso-schema-json-ld/">WPSSO Schema JSON-LD Markup Pro</a> add-on:</p>

<ul>
<li>All Schema Types

<ul>
<li>Schema Type</li>
<li>Name / Title</li>
<li>Alternate Name</li>
<li>Description</li>
<li>Microdata Type URLs</li>
<li>Same-As URLs</li>
</ul></li>
<li>Creative Work Information

<ul>
<li>Headline</li>
<li>Full Text</li>
<li>Keywords</li>
<li>Language</li>
<li>Family Friendly</li>
<li>Copyright Year</li>
<li>Publisher</li>
<li>Service Provider</li>
</ul></li>
<li>Event Information

<ul>
<li>Event Language</li>
<li>Event Organizer Org.</li>
<li>Event Organizer Person</li>
<li>Event Performer Org.</li>
<li>Event Performer Person</li>
<li>Event Venue</li>
<li>Event Start (date, time, timezone)</li>
<li>Event End (date, time, timezone)</li>
<li>Offers Start (date, time, timezone)</li>
<li>Offers End (date, time, timezone)</li>
<li>Event Offers (name, price, currency, availability)</li>
</ul></li>
<li>How-To

<ul>
<li>How-To Makes </li>
<li>How-To Preparation Time </li>
<li>How-To Total Time </li>
<li>How-To Supplies </li>
<li>How-To Tools </li>
<li>How-To Steps </li>
</ul></li>
<li>Job Posting Information

<ul>
<li>Job Posting Job Title</li>
<li>Job Posting Hiring Organization</li>
<li>Job Posting Job Location</li>
<li>Job Posting Base Salary</li>
<li>Job Posting Employment Type</li>
<li>Job Posting Expires</li>
</ul></li>
<li>Movie Information

<ul>
<li>Cast Names</li>
<li>Director Names</li>
<li>Production Company</li>
<li>Movie Runtime</li>
</ul></li>
<li>Organization Information

<ul>
<li>Organization</li>
</ul></li>
<li>Person Information

<ul>
<li>Person</li>
</ul></li>
<li>QA Page Information

<ul>
<li>QA Heading</li>
</ul></li>
<li>Recipe Information

<ul>
<li>Recipe Cuisine </li>
<li>Recipe Course </li>
<li>Recipe Makes </li>
<li>Recipe Cooking Method </li>
<li>Recipe Preparation Time </li>
<li>Recipe Cooking Time </li>
<li>Recipe Total Time </li>
<li>Recipe Total Calories </li>
<li>Recipe Ingredients </li>
<li>Recipe Instructions </li>
<li>Recipe Nutrition Information per Serving 

<ul>
<li>Serving Size</li>
<li>Calories</li>
<li>Protein</li>
<li>Fiber</li>
<li>Carbohydrates</li>
<li>Sugar</li>
<li>Sodium</li>
<li>Fat</li>
<li>Saturated Fat</li>
<li>Unsaturated Fat</li>
<li>Trans Fat</li>
<li>Cholesterol</li>
</ul></li>
</ul></li>
<li>Review Information

<ul>
<li>Subject Webpage URL </li>
<li>Review Rating </li>
<li>Review Rating Name</li>
</ul></li>
<li>Claim Review Information

<ul>
<li>Specific Claims Reviewed</li>
</ul></li>
<li>Software Application Information

<ul>
<li>Operating System</li>
</ul></li>
</ul></li>
<li><p>Optionally upscale small images from the Media Library for social sharing and Schema markup.</p></li>
<li><p>Automatically validate all image minimum / maximum dimensions and aspect ratios.</p></li>
<li><p>Render shortcodes and blocks for accurate description texts and embedded video detection.</p></li>
<li><p>Additional Facebook, Open Graph, Rich Pin meta tags and Schema markup for videos and eCommerce products.</p></li>
<li><p>Support for embedded videos from Facebook, Slideshare, Vimeo, Wistia, and Youtube in content text.</p></li>
<li><p>Twitter <a href="https://dev.twitter.com/cards/types/player">Player Card</a> for embedded videos from Facebook, Slideshare, Vimeo, Wistia, and Youtube.</p></li>
<li><p>URL shortening with Bitly, DLMY.App, Google, Ow.ly, TinyURL, or YOURLS.</p></li>
<li><p>Integrates with services and 3rd party plugins for additional image, video, eCommerce product details, SEO settings, and more.</p></li>
<li><p>The following integration modules are provided with the Pro version, and are automatically loaded when the supported services are required or 3rd party plugins detected.</p>

<ul>
<li><p><strong>Integration with Service APIs:</strong></p>

<ul>
<li>Bitly</li>
<li>DLMY.App</li>
<li>Facebook Embedded Videos</li>
<li>Gravatar (Author Image)</li>
<li>Ow.ly</li>
<li>Slideshare Presentations</li>
<li>Soundcloud Tracks (for the Twitter Player Card)</li>
<li>TinyURL</li>
<li>Vimeo Videos</li>
<li>Wistia Videos</li>
<li>WordPress Video Shortcode (and Self-Hosted Videos)</li>
<li>Your Own URL Shortener (YOURLS)</li>
<li>YouTube Videos and Playlists</li>
</ul></li>
<li><p><strong>Integration with 3rd Party Plugins:</strong></p>

<ul>
<li>All in One SEO Pack</li>
<li>bbPress</li>
<li>BuddyPress (including Group Forum Topics)</li>
<li>Co-Authors Plus (including Guest Authors)</li>
<li>Easy Digital Downloads</li>
<li>Gravity Forms + GravityView</li>
<li>HeadSpace2 SEO</li>
<li>MarketPress - WordPress eCommerce</li>
<li>NextCellent Gallery - NextGEN Legacy</li>
<li>NextGEN Gallery</li>
<li>Polylang</li>
<li>rtMedia for WordPress, BuddyPress and bbPress</li>
<li>The Events Calendar</li>
<li>The SEO Framework</li>
<li>WooCommerce (versions 1, 2, and 3)</li>
<li>WP eCommerce</li>
<li>WP Meta SEO</li>
<li>WP-PostRatings</li>
<li>Yoast SEO (aka WordPress SEO)</li>
<li>Yotpo Social Reviews for WooCommerce</li>
</ul></li>
</ul></li>
<li><p>Pro add-ons for even more advanced functionality:</p>

<ul>
<li><a href="https://wpsso.com/extend/plugins/wpsso-am/">WPSSO Mobile App Meta Pro</a> to manage mobile App information.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-organization/">WPSSO Organization Markup Pro</a> to manage multiple Organizations.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-plm/">WPSSO Place / Location and Local Business Meta Pro</a> to manage multiple Locations.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-rrssb/">WPSSO Ridiculously Responsive Social Sharing Buttons Pro</a> to add responsive share buttons.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-schema-json-ld/">WPSSO Schema JSON-LD Markup Pro</a> to add JSON-LD in post and archive pages.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-ssb/">WPSSO Social Sharing Buttons Pro</a> to add traditional share buttons.</li>
<li><a href="https://wpsso.com/extend/plugins/wpsso-tune-image-editors/">WPSSO Tune WP Image Editors Pro</a> for better looking WordPress thumbnails.</li>
</ul></li>
</ul>

<h3>Coded for Performance</h3>

<p>WPSSO Core makes full use of all available caching methods &mdash; along with offering advanced caching features like pre-seeding the cache in background. WPSSO Core and its add-ons use only the library files and object classes they need, keeping their code small, fast and light. All code is fully tested and compatible with the latest version of WordPress and PHP v7.x (PHP v5.5 or better required).</p>

<h3>Highly Customizable</h3>

<p>WPSSO Core offers hundreds of filter hooks to customize its behavior and output, provides extensive developer documentation with examples, includes dozens of 3rd party integration modules in the Pro version, and offers several optional Free and Pro add-ons to extend WPSSO Core's features.</p>


<h2>Installation</h2>

<h3 class="top">Install and Uninstall</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/install-the-plugin/">Install the WPSSO Core Plugin</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/uninstall-the-plugin/">Uninstall the WPSSO Core Plugin</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/debugging-and-problem-solving/">Debugging and Problem Solving</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/developer-special-buy-one-get-one-free/">Developer Special - Buy one, Get one Free</a></li>
</ul>

<h3>Plugin Setup</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/a-setup-guide/">A Setup Guide for WPSSO</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/integration/">Integration Notes</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/integration/buddypress-integration/">BuddyPress Integration</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/integration/woocommerce-integration/">WooCommerce Integration</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/performance-tuning/">Performance Tuning</a></li>
</ul>


<h2>Frequently Asked Questions</h2>

<h3 class="top">Frequently Asked Questions</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/can-i-use-the-pro-version-on-multiple-websites/">Can I use the Pro version on multiple websites?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/does-linkedin-read-the-open-graph-meta-tags/">Does LinkedIn read the Open Graph meta tags?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/doesnt-an-seo-plugin-cover-that/">Doesn't an SEO plugin cover that?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-add-schema-aggregaterating-values/">How can I add Schema aggregateRating values?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-exclude-ignore-certain-parts-of-the-content-text/">How can I exclude / ignore certain parts of the content text?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-a-err_too_many_redirects-error/">How can I fix a ERR_TOO_MANY_REDIRECTS error?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-a-php-fatal-out-of-memory-error/">How can I fix a PHP fatal "out of memory" error?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-an-http-error-when-uploading-images/">How can I fix an "HTTP error" when uploading images?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-have-smaller-dimensions-for-the-default-image/">How can I have smaller dimensions for the default image?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-see-what-the-facebook-crawler-sees/">How can I see what the Facebook crawler sees?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-share-a-single-nextgen-gallery-image/">How can I share a single NextGEN Gallery image?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-attach-an-image-without-showing-it-on-the-webpage/">How do I attach an image without showing it on the webpage?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-fix-google-structured-data-hatom-errors/">How do I fix Google Structured Data &gt; hatom errors?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-fix-my-themes-front-page-pagination/">How do I fix my theme's front page pagination?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-install-the-wpsso-pro-version/">How do I install the WPSSO Core Pro version?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-remove-duplicate-meta-tags/">How do I remove duplicate meta tags?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-does-wpsso-find-detect-select-images/">How does WPSSO Core find / detect / select images?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-does-wpsso-find-detect-select-videos/">How does WPSSO Core find / detect / select videos?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/w3c-says-there-is-no-attribute-property/">W3C says "there is no attribute 'property'"</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-are-some-html-elements-missing-misaligned-different/">Why are some HTML elements missing / misaligned / different?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-does-facebook-play-videos-instead-of-linking-them/">Why does Facebook play videos instead of linking them?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-does-facebook-show-the-wrong-image-text/">Why does Facebook show the wrong image / text?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-does-google-structured-data-testing-tool-show-errors/">Why does Google Structured Data Testing Tool show errors?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-dont-my-twitter-cards-show-on-twitter/">Why don't my Twitter Cards show on Twitter?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-is-the-open-graph-title-the-same-for-every-webpage/">Why is the Open Graph title the same for every webpage?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-shouldnt-i-upload-small-images-to-the-media-library/">Why shouldn't I upload small images to the Media library?</a></li>
</ul>

<h3>Advanced Documentation and Notes</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/">About WPSSO Core Pro Integration Modules</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/author-gravatar/">Author Gravatar</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/co-author-plus/">Co-Author Plus</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/easy-digital-downloads/">Easy Digital Downloads</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/facebook-slideshare-vimeo-wistia-youtube-video-apis/">Facebook, Slideshare, Vimeo, Wistia, Youtube Video APIs</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/headspace2-seo/">HeadSpace2 SEO</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/nextcellent-gallery-and-nextgen-gallery/">NextCellent Gallery and NextGEN Gallery</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/polylang/">Polylang</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/the-events-calendar/">The Events Calendar</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/woocommerce/">WooCommerce</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/modules/yoast-seo-aka-wordpress-seo/">Yoast SEO (aka WordPress SEO)</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/contact-information/">Contact Information and Feeds</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/">Developer Resources</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/constants/">Constants</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/constants/all/">All Constants</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/">Filters</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/all/">All Filters</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/">Filter Examples</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/add-schema-aggregaterating-meta-tags/">Add Schema aggregateRating Meta Tags</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/define-a-custom-post-type-cpt-as-a-product/">Define a Custom Post Type (CPT) as a Product</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/detect-youtube-url-links-as-videos/">Detect YouTube URL Links as Videos</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/modify-the-articletag-keywords-names/">Modify the "article:tag" Keywords / Names</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/modify-the-default-topics-list/">Modify the Default Article Topics List</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/modify-the-home-page-title-for-facebook-open-graph/">Modify the Home Page Title for Facebook / Open Graph</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/modify-the-sharing-url/">Modify the Sharing URL</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/read-import-yoast-seo-social-meta/">Read / Import Yoast SEO Social Meta</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/remove-hentry-from-theme-templates/">Remove / Fix 'hentry' Errors in your Theme Templates</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/strip-additional-shortcodes/">Strip Additional Shortcodes</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/use-the-request_uri-for-post-urls/">Use the REQUEST_URI for Post URLs</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/examples/working-with-pre-defined-meta-tags-and-custom-post-types/">Working with Pre-defined Meta Tags and Custom Post Types</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/">Filters by Category</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/head/">Head Filters</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/media/">Media Filters</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/open-graph/">Facebook / Open Graph Filters</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/twitter-card/">Twitter Card Filters</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/by-category/webpage/">Webpage Filters</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/other/">Other Filters</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/the-mod-variable/">The $mod Variable</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/inline-variables/">Inline Variables</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/multisite-network-support/">Multisite / Network Support</a></li>
</ul>


