<?php
if ( ! function_exists( 'supermag_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function supermag_setup() {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on SuperMag, use a find and replace
         * to change 'supermag' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'supermag', get_template_directory() . '/languages' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );
        /*
         * Enable support for custom logo.
         *
         *  @since SuperMagPro 1.0.4
          */
        add_theme_support( 'custom-logo', array(
            'height'      => 70,
            'width'       => 290,
            'flex-height' => true,
        ) );
        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        set_post_thumbnail_size( 240, 172, true );

        // Medium Size Thumbnail
        if( false === get_option("medium_crop")) {
            add_option("medium_crop", "1"); }
        else {
            update_option("medium_crop", "1");
        }

        // Large Size Thumbnail
        if( false === get_option("large_crop")) {
            add_option("large_crop", "1"); }
        else {
            update_option("large_crop", "1");
        }
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'primary' => esc_html__( 'Primary Menu', 'supermag' )
        ) );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'gallery',
            'caption',
        ) );

	    // This theme styles the visual editor with editor-style.css to match the theme style.
	    add_editor_style();

        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'supermag_custom_background_args', array(
            'default-color' => 'eeeeee',
            'default-image' => '',
        ) ) );

        /*woocommerce support*/
        add_theme_support( 'woocommerce' );

	    /*Set up the woocommerce Gallery Lightbox*/
	    add_theme_support( 'wc-product-gallery-zoom' );
	    add_theme_support( 'wc-product-gallery-lightbox' );
	    add_theme_support( 'wc-product-gallery-slider' );

        /*theme updater*/
        require( get_template_directory() . '/acmethemes/updater/theme-updater.php' );
    }
endif; // supermag_setup
add_action( 'after_setup_theme', 'supermag_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function supermag_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'supermag_content_width', 640 );
}
add_action( 'after_setup_theme', 'supermag_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
function supermag_scripts() {
	$supermag_customizer_all_values = supermag_get_theme_options();

    /*font family*/
	$font_type = $supermag_customizer_all_values['supermag-font-type'];
	if( 'google' == $font_type ){
		$supermag_google_fonts = supermag_fonts_array();
		$supermag_site_title_fm = $supermag_google_fonts[$supermag_customizer_all_values['supermag-site-title-fm']];
		$supermag_site_tagline_fm = $supermag_google_fonts[$supermag_customizer_all_values['supermag-site-tagline-fm']];
		$supermag_menu_fm = $supermag_google_fonts[$supermag_customizer_all_values['supermag-menu-fm']];
		$supermag_heading_fm = $supermag_google_fonts[$supermag_customizer_all_values['supermag-heading-fm']];
		$supermag_body_fm = $supermag_google_fonts[$supermag_customizer_all_values['supermag-body-fm']];
		$supermag_google_fonts_enqueue = array(
			$supermag_site_title_fm,$supermag_site_tagline_fm,$supermag_menu_fm,$supermag_heading_fm,$supermag_body_fm
		);
		$supermag_google_fonts_enqueue_uniques = (array_unique($supermag_google_fonts_enqueue));
		foreach( $supermag_google_fonts_enqueue_uniques as $supermag_google_fonts_enqueue_unique ){
			wp_enqueue_style( $supermag_google_fonts_enqueue_unique, '//fonts.googleapis.com/css?family='.$supermag_google_fonts_enqueue_unique.'', array(), '' );
		}

		/*google font*/
		wp_enqueue_style( 'supermag-googleapis', '//fonts.googleapis.com/css?family=Oswald:300,400,700|Roboto:300italic,400,500,700', array(), '4.0.3' );
	}
   
    /*bxslider css*/
    wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/assets/library/bxslider/css/jquery.bxslider.min.css', array(), '4.2.6' );
    wp_style_add_data( 'bxslider', 'rtl', 'replace' );

    wp_enqueue_style( 'mCustomScrollbar', get_template_directory_uri() . '/assets/library/malihu-custom-scrollbar/jquery.mCustomScrollbar.min.css', array(), '3.0.9' );
    wp_style_add_data( 'mCustomScrollbar', 'rtl', 'replace' );
    
    /*Font-Awesome-master*/
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/library/Font-Awesome/css/font-awesome.min.css', array(), '4.7.0' );
    wp_style_add_data( 'font-awesome', 'rtl', 'replace' );

    /*main style*/
    wp_enqueue_style( 'supermag-style', get_stylesheet_uri() ,'','1.2.3.3');
    wp_style_add_data( 'supermag-style', 'rtl', 'replace' );

    $supermag_hooks_dynamic_css_file_path = supermag_file_directory('acmethemes/hooks/dynamic-css.php');
    require $supermag_hooks_dynamic_css_file_path;

    /*jquery start*/
    wp_enqueue_script('bxslider', get_template_directory_uri() . '/assets/library/bxslider/js/jquery.bxslider.min.js', array('jquery'), '4.2.5', 1);
    wp_enqueue_script('mCustomScrollbar', get_template_directory_uri() . '/assets/library/malihu-custom-scrollbar/jquery.mCustomScrollbar.js', array('jquery'), '3.0.9', 1);

    if( 1 == $supermag_customizer_all_values['supermag-enable-sticky-sidebar'] ){
        wp_enqueue_script('theia-sticky-sidebar', get_template_directory_uri() . '/assets/library/theia-sticky-sidebar/theia-sticky-sidebar.min.js', array('jquery'), '1.4.0', 1);
    }
    wp_enqueue_script('supermag-custom', get_template_directory_uri() . '/assets/js/supermag-custom.js', array('jquery'), '1.2.3.3', 1);

    /*for ie only*/
    // Load the html5 shiv and respond js.
    wp_enqueue_script( 'html5shiv', get_template_directory_uri() . '/assets/library/html5shiv/html5shiv.min.js', array(), '3.7.3' );
    wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );

    wp_enqueue_script( 'respond', get_template_directory_uri() . '/assets/library/respond/respond.min.js', array(), '1.4.2' );
    wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );
 
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'supermag_scripts' );

/**
 * check if edit page
 */
function supermag_is_edit_page() {
	//make sure we are on the backend
	if ( !is_admin() ){
		return false;
	}
	global $pagenow;
	return in_array( $pagenow, array( 'post.php', 'post-new.php' ) );
}
/**
 * Enqueue admin scripts and styles.
 */
function supermag_admin_scripts( $hook ) {
	if ( 'widgets.php' == $hook || supermag_is_edit_page() ){
		wp_enqueue_media();
		wp_enqueue_style( 'supermag-widgets-style', get_template_directory_uri() .'/assets/css/widgets.css', '', '1.0.0' );
		wp_enqueue_script( 'supermag-widgets-script', get_template_directory_uri() . '/assets/js/widgets.js', array( 'jquery' ), '1.0.0' );
	}
}
add_action( 'admin_enqueue_scripts', 'supermag_admin_scripts' );

/**
 * Custom template tags for this theme.
 */
require_once supermag_file_directory('acmethemes/core/template-tags.php');

/**
 * Custom functions that act independently of the theme templates.
 */
require_once supermag_file_directory('acmethemes/core/extras.php');

/**
 * Load custom header.
 */
require_once supermag_file_directory('acmethemes/core/custom-header.php');

/**
 * Load Jetpack compatibility file.
 */
require_once supermag_file_directory('acmethemes/core/jetpack.php');