<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
function supermag_time_ago( $time ) {
	return human_time_diff($time, current_time('timestamp')) . ' ago';

}

if ( ! function_exists( 'supermag_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function supermag_posted_on( $show_date = 1,  $show_author = 1) {

	$posted_on = $byline = '';

	if( 1 == $show_date ){
		$supermag_customizer_all_values = supermag_get_theme_options();
		$supermag_enable_date_diff = $supermag_customizer_all_values['supermag-enable-date-diff'];

		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}
		if( 1 == $supermag_enable_date_diff ){
			$time_string = sprintf( $time_string,
				esc_attr( get_the_date( 'c' ) ),
				esc_html( supermag_time_ago( get_the_time('U') ) ),
				esc_attr( get_the_modified_date( 'c' ) ),
				esc_html( supermag_time_ago( get_post_modified_time() ) )
			);
		}
		else{
			$time_string = sprintf( $time_string,
				esc_attr( get_the_date( 'c' ) ),
				esc_html( get_the_date() ),
				esc_attr( get_the_modified_date( 'c' ) ),
				esc_html( get_the_modified_date() )
			);
		}
		$posted_on = sprintf(
			'%s',
			'<i class="fa fa-calendar"></i><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
		);

		$posted_on ='<span class="posted-on">' . $posted_on . '</span>';
	}
	if( 1 == $show_author ){
		$byline = sprintf(
			'%s',
			'<i class="fa fa-user"></i><span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);
		$byline = '<span class="byline"> ' . $byline . '</span>';
	}
	echo $posted_on.$byline; // WPCS: XSS OK.
}
endif;

if ( ! function_exists( 'supermag_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function supermag_entry_footer( $show_cat = 1, $show_tag = 1, $show_comment = 1 ) {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {

		if(  1 == $show_cat ){
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'supermag' ) );
			if ( $categories_list && supermag_categorized_blog() ) {
				printf( '<span class="cat-links"><i class="fa fa-folder-o"></i>%1$s</span>', $categories_list ); // WPCS: XSS OK.
			}
		}

		if( 1 == $show_tag ){
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html__( ', ', 'supermag' ) );
			if ( $tags_list ) {
				printf( '<span class="tags-links"><i class="fa fa-tags"></i>%1$s</span>', $tags_list ); // WPCS: XSS OK.
			}
		}
	}

	if( 1 == $show_comment ){
		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link"><i class="fa fa-comment-o"></i>';
			comments_popup_link( esc_html__( 'Leave a comment', 'supermag' ), esc_html__( '1 Comment', 'supermag' ), esc_html__( '% Comments', 'supermag' ) );
			echo '</span>';
		}
	}

	if( get_edit_post_link()){
		edit_post_link(
			sprintf(
			/* translators: %s: Name of current post */
				esc_html__( 'Edit %s', 'supermag' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			),
			'<span class="edit-link"><i class="fa fa-edit "></i>',
			'</span>'
		);
	}
}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
if ( ! function_exists( 'supermag_categorized_blog' ) ) :
	function supermag_categorized_blog() {
		if ( false === ( $all_the_cool_cats = get_transient( 'supermag_categories' ) ) ) {
			// Create an array of all the categories that are attached to posts.
			$all_the_cool_cats = get_categories( array(
				'fields'     => 'ids',
				'hide_empty' => 1,

				// We only need to know if there is more than one category.
				'number'     => 2,
			) );

			// Count the number of categories that are attached to the posts.
			$all_the_cool_cats = count( $all_the_cool_cats );

			set_transient( 'supermag_categories', $all_the_cool_cats );
		}

		if ( $all_the_cool_cats > 1 ) {
			// This blog has more than 1 category so supermag_categorized_blog should return true.
			return true;
		} else {
			// This blog has only 1 category so supermag_categorized_blog should return false.
			return false;
		}
	}
endif;

/**
 * Flush out the transients used in supermag_categorized_blog.
 */
if ( ! function_exists( 'supermag_category_transient_flusher' ) ) :
	function supermag_category_transient_flusher() {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		// Like, beat it. Dig?
		delete_transient( 'supermag_categories' );
	}
endif;
add_action( 'edit_category', 'supermag_category_transient_flusher' );
add_action( 'save_post',     'supermag_category_transient_flusher' );