<?php
/**
 * Header logo/text display options alternative
 *
 * @since SuperMag 1.0.2
 *
 * @param null
 * @return array $supermag_header_id_display_opt
 *
 */
if ( !function_exists('supermag_breaking_news_options') ) :
    function supermag_breaking_news_options() {
        $supermag_breaking_news_options =  array(
            'disable' => __( 'Disable', 'supermag' ),
            'slide' => __( 'Slide', 'supermag' ),
            'ticker' =>  __( 'Ticker', 'supermag' )
        );
        return apply_filters( 'supermag_breaking_news_options', $supermag_breaking_news_options );
    }
endif;

/**
 * Header Ads display options
 *
 * @since SuperMag 1.0.3
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_header_ads_display_options') ) :
    function supermag_header_ads_display_options() {
        $supermag_related_posts_display_options =  array(
            'hide'  => __( 'Hide', 'supermag' ),
            'image' => __( 'Ads Image', 'supermag' ),
            'adsense' => __( 'Adsense', 'supermag' )
        );
        return apply_filters( 'supermag_related_posts_display_options', $supermag_related_posts_display_options );
    }
endif;

/**
 * Header Site identity and ads display options
 *
 * @since SuperMag 1.0.5
 *
 * @param null
 * @return array $supermag_header_logo_menu_display_position
 *
 */
if ( !function_exists('supermag_header_logo_menu_display_position') ) :
    function supermag_header_logo_menu_display_position() {
        $supermag_header_logo_menu_display_position =  array(
            'left-logo-right-ainfo' => __( 'Left Logo and Right Ads', 'supermag' ),
            'right-logo-left-ainfo' => __( 'Right Logo and Left Ads', 'supermag' ),
            'center-logo-below-ainfo' => __( 'Center Logo and Below Ads', 'supermag' )
        );
        return apply_filters( 'supermag_header_logo_menu_display_position', $supermag_header_logo_menu_display_position );
    }
endif;

/**
 * Header logo/text display options alternative
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_header_id_display_opt
 *
 */
if ( !function_exists('supermag_header_id_display_opt') ) :
    function supermag_header_id_display_opt() {
        $supermag_header_id_display_opt =  array(
            'logo-only'         => __( 'Logo Only ( First Select Logo Above )', 'supermag' ),
            'title-only'        => __( 'Site Title Only', 'supermag' ),
            'title-and-tagline' =>  __( 'Site Title and Tagline', 'supermag' ),
            'logo-and-title' =>  __( 'Logo and Site Title', 'supermag' ),
            'logo-and-tagline' =>  __( 'Logo and Tagline', 'supermag' ),
            'logo-and-title-and-tagline' =>  __( 'Logo,Site Title and Tagline', 'supermag' ),
            'disable'           => __( 'Disable', 'supermag' )
        );
        return apply_filters( 'supermag_header_id_display_opt', $supermag_header_id_display_opt );
    }
endif;

/**
 * Header Display Options
 *
 * @since SuperMag 1.3.0
 *
 * @param null
 * @return array $supermag_header_date_format
 *
 */
if ( !function_exists('supermag_header_date_format') ) :
	function supermag_header_date_format() {
		$supermag_header_date_format =  array(
			'default' => __( 'Default', 'supermag' ),
			'wp-date-format' => __( 'From WordPress Date Setting', 'supermag' )
		);
		return apply_filters( 'supermag_header_date_format', $supermag_header_date_format );
	}
endif;

/**
 * Header Display Options
 *
 * @since SuperMag 1.3.1
 *
 * @param null
 * @return array $supermag_header_time_format
 *
 */
if ( !function_exists('supermag_header_time_format') ) :
	function supermag_header_time_format() {
		$supermag_header_time_format =  array(
			12 => __( '12 hours', 'supermag' ),
			24 => __( '24 hours', 'supermag' )
		);
		return apply_filters( 'supermag_header_time_format', $supermag_header_time_format );
	}
endif;


/**
 * Header Media Position options
 *
 * @since SuperMag 1.5.0
 *
 * @param null
 * @return array $supermag_header_media_position
 *
 */
if ( !function_exists('supermag_header_media_position') ) :
	function supermag_header_media_position() {
		$supermag_header_media_position =  array(
			'very-top' => __( 'Very Top', 'supermag' ),
			'above-logo' => __( 'Above Site Identity', 'supermag' ),
			'above-menu' => __( 'Below Site Identity and Above Menu', 'supermag' ),
			'below-menu' => __( 'Below Menu', 'supermag' )
		);
		return apply_filters( 'supermag_header_media_position', $supermag_header_media_position );
	}
endif;

/**
 * Header breaking news options col
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_breaking_news_per_slide
 *
 */
if ( !function_exists('supermag_breaking_news_per_slide') ) :
    function supermag_breaking_news_per_slide() {
        $supermag_breaking_news_per_slide =  array(
            1 => __( '1', 'supermag' ),
            2 => __( '2', 'supermag' ),
            3 => __( '3', 'supermag' )
        );
        return apply_filters( 'supermag_breaking_news_per_slide', $supermag_breaking_news_per_slide );
    }
endif;

/**
 * Header logo/text display options alternative
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_menu_alignment
 *
 */
if ( !function_exists('supermag_menu_alignment') ) :
    function supermag_menu_alignment() {
        $supermag_menu_alignment =  array(
            'menu-left' => __( 'Left', 'supermag' ),
            'menu-right'=> __( 'Right', 'supermag' )
        );
        return apply_filters( 'supermag_menu_alignment', $supermag_menu_alignment );
    }
endif;

/**
 * Feature slider selection
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_slider_selection_from
 *
 */
if ( !function_exists('supermag_slider_selection_from') ) :
    function supermag_slider_selection_from() {
        $supermag_slider_selection_from =  array(
            'from-recent'   => __( 'Recents posts', 'supermag' ),
            'from-category' => __( 'Category', 'supermag' ),
            'from-tag' => __( 'Tag', 'supermag' ),
            'from-custom'   => __( 'Custom', 'supermag' )
        );
        return apply_filters( 'supermag_slider_selection_from', $supermag_slider_selection_from );
    }
endif;

/**
 * Feature side display options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_feature_side_display_options
 *
 */
if ( !function_exists('supermag_feature_side_display_options') ) :
    function supermag_feature_side_display_options() {
        $supermag_feature_side_display_options =  array(
            'from-recent'   => __( 'Recents posts', 'supermag' ),
            'from-category' => __( 'Category', 'supermag' ),
            'post-4'        => __( 'Post 4', 'supermag' ),
            'add-4'         => __( 'Add 4', 'supermag' ),
            'post-1-add-3'  => __( 'Post 1 - Add 3', 'supermag' ),
            'post-2-add-2'  => __( 'Post 2 - Add 2', 'supermag' ),
            'post-3-add-1'  => __( 'Post 3 - Add 1', 'supermag' )
        );
        return apply_filters( 'supermag_feature_side_display_options', $supermag_feature_side_display_options );
    }
endif;

/**
 *  Beaking news selection
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_breaking_news_selection_from
 *
 */
if ( !function_exists('supermag_breaking_news_selection_from') ) :
    function supermag_breaking_news_selection_from() {
        $supermag_breaking_news_selection_from =  array(
            'from-recent'   => __( 'Recents posts', 'supermag' ),
            'from-category' => __( 'Category', 'supermag' )
        );
        return apply_filters( 'supermag_breaking_news_selection_from', $supermag_breaking_news_selection_from );
    }
endif;

/**
 * Global layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_default_layout
 *
 */
if ( !function_exists('supermag_default_layout') ) :
    function supermag_default_layout() {
        $supermag_default_layout =  array(
            'fullwidth' => __( 'Fullwidth', 'supermag' ),
            'boxed'     => __( 'Boxed', 'supermag' )
        );
        return apply_filters( 'supermag_default_layout', $supermag_default_layout );
    }
endif;

/**
 * Sidebar layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_sidebar_layout
 *
 */
if ( !function_exists('supermag_sidebar_layout') ) :
    function supermag_sidebar_layout() {
        $supermag_sidebar_layout =  array(
	        'right-sidebar' => esc_html__( 'Right Sidebar', 'supermag' ),
	        'left-sidebar'  => esc_html__( 'Left Sidebar' , 'supermag' ),
	        'both-sidebar'  => esc_html__( 'Both Sidebar' , 'supermag' ),
	        'middle-col'    => esc_html__( 'Middle Column' , 'supermag' ),
	        'no-sidebar'    => esc_html__( 'No Sidebar', 'supermag' )
        );
        return apply_filters( 'supermag_sidebar_layout', $supermag_sidebar_layout );
    }
endif;

/**
 * Blog layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_blog_layout
 *
 */
if ( !function_exists('supermag_blog_layout') ) :
    function supermag_blog_layout() {
        $supermag_blog_layout =  array(
            'left-image' => __( 'Left Image', 'supermag' ),
            'large-image' => __( 'Large Image', 'supermag' ),
            'no-image' => __( 'No Image', 'supermag' )
        );
        return apply_filters( 'supermag_blog_layout', $supermag_blog_layout );
    }
endif;

/**
 * Button design options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_button_design
 *
 */
if ( !function_exists('supermag_button_design') ) :
    function supermag_button_design() {
        $supermag_button_design =  array(
            'rectangle'         => __( 'Rectangle', 'supermag' ),
            'rounded-rectangle' => __( 'Rounded Rectangle', 'supermag' )
        );
        return apply_filters( 'supermag_button_design', $supermag_button_design );
    }
endif;
/**
 * Blog archive image options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_blog_layout
 *
 */
if ( !function_exists('supermag_blog_archive_image_layout') ) :
    function supermag_blog_archive_image_layout() {
        $supermag_blog_layout =  array(
            'left-image'        => __( 'Left Image', 'supermag' ),
            'large-image'       => __( 'Large Image', 'supermag' ),
            'alternate-image'   => __( 'Alternate Image', 'supermag' ),
            'no-image'          => __( 'No Image', 'supermag' )
        );
        return apply_filters( 'supermag_blog_archive_image_layout', $supermag_blog_layout );
    }
endif;

/**
 * Blog archive content options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_blog_layout
 *
 */
if ( !function_exists('supermag_blog_archive_content_layout') ) :
    function supermag_blog_archive_content_layout() {
        $supermag_blog_layout =  array(
            'excerpt' => __( 'Excerpt', 'supermag' ),
            'content' => __( 'Content', 'supermag' )
        );
        return apply_filters( 'supermag_blog_archive_content_layout', $supermag_blog_layout );
    }
endif;

/**
 * Featured options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_single_fi_options
 *
 */
if ( !function_exists('supermag_single_fi_options') ) :
    function supermag_single_fi_options() {
        $supermag_single_fi_options =  array(
            'left-align'    => __( 'Left Align - Thumbnail', 'supermag' ),
            'right-align'   => __( 'Right Align - Thumbnail', 'supermag' ),
            'center-align'  => __( 'Center Align - Large Image', 'supermag' ),
            'no-image'      => __( 'No image', 'supermag' )
        );
        return apply_filters( 'supermag_single_fi_options', $supermag_single_fi_options );
    }
endif;

/**
 * Breadcrumb Options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array supermag_breadcrumb_options
 *
 */
if ( !function_exists('supermag_breadcrumb_options') ) :
    function supermag_breadcrumb_options() {
        $supermag_breadcrumb_options =  array(
            'simple'    => __( 'Default : Theme Default', 'supermag' ),
            'advanced'  => __( 'Advanced : Breadcrumb NavXT', 'supermag' ),
            'disable'   => __( 'Disable', 'supermag' )
        );
        return apply_filters( 'supermag_breadcrumb_options', $supermag_breadcrumb_options );
    }
endif;

/**
 * Pagination Options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array supermag_pagination_options
 *
 */
if ( !function_exists('supermag_pagination_options') ) :
    function supermag_pagination_options() {
        $supermag_pagination_options =  array(
            'default'  => __( 'Default', 'supermag' ),
            'numeric'  => __( 'Numeric', 'supermag' ),
            'disable'  => __( 'Disable', 'supermag' ),
        );
        return apply_filters( 'supermag_pagination_options', $supermag_pagination_options );
    }
endif;

/**
 * Footer top sidebar number
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_footer_top_sidebar_number') ) :
    function supermag_footer_top_sidebar_number() {
        $supermag_footer_top_sidebar_number =  array(
            0  => 0,
            1  => 1,
            2  => 2,
            3  => 3,
            4  => 4
        );
        return apply_filters( 'supermag_footer_top_sidebar_number', $supermag_footer_top_sidebar_number );
    }
endif;

/**
 * Footer bottom sidebar number
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_footer_bottom_sidebar_number') ) :
    function supermag_footer_bottom_sidebar_number() {
        $supermag_footer_bottom_sidebar_number =  array(
            0  => 0,
            1  => 1,
            2  => 2,
            3  => 3,
            4  => 4
        );
        return apply_filters( 'supermag_footer_bottom_sidebar_number', $supermag_footer_bottom_sidebar_number );
    }
endif;

/**
 * Related posts display options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_related_posts_display_options') ) :
    function supermag_related_posts_display_options() {
        $supermag_related_posts_display_options =  array(
            'left-related-posts'  => __( 'Left to Featured Image', 'supermag' ),
            'right-related-posts' => __( 'Right to Featured Image', 'supermag' ),
            'below-related-posts' => __( 'Below Content', 'supermag' ),
            'no-related-posts'    => __( 'Do not show related post', 'supermag' )
        );
        return apply_filters( 'supermag_related_posts_display_options', $supermag_related_posts_display_options );
    }
endif;

/**
 * Related Post Display From Options
 *
 * @since SuperMag 1.3.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_related_post_display_from') ) :
	function supermag_related_post_display_from() {
		$supermag_related_post_display_from =  array(
			'cat'  => __( 'Related Posts From Categories', 'supermag' ),
			'tag'  => __( 'Related Posts From Tags', 'supermag' )
		);
		return apply_filters( 'supermag_related_post_display_from', $supermag_related_post_display_from );
	}
endif;

/**
 * Related posts layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_related_posts_layout') ) :
    function supermag_related_posts_layout() {
        $supermag_related_posts_layout =  array(
            1  => 1,
            2  => 2,
            3  => 3,
            4  => 4
        );
        return apply_filters( 'supermag_related_posts_layout', $supermag_related_posts_layout );
    }
endif;

/**
 * Font Type
 *
 * @since SuperMag 2.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_font_type') ) :
	function supermag_font_type() {
		$supermag_font_type =  array(
			'google'  => __( 'Google', 'supermag' ),
			'system'  =>  __( 'System', 'supermag' )
		);
		return apply_filters( 'supermag_font_type', $supermag_font_type );
	}
endif;

/**
 * Default Font Family
 *
 * @since SuperMag 2.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_system_fonts') ) :
	function supermag_system_fonts() {
		$supermag_system_fonts =  array(
			'Arial'  => __( 'Arial', 'supermag' ),
			'Tahoma'  =>  __( 'Tahoma', 'supermag' ),
			'Verdana'  =>  __( 'Verdana', 'supermag' ),
			'Helvetica'  =>  __( 'Helvetica', 'supermag' ),
			'Times New Roman'  =>  __( 'Times New Roman', 'supermag' ),
			'Trebuchet MS'  =>  __( 'Trebuchet MS', 'supermag' ),
			'Georgia'  =>  __( 'Georgia', 'supermag' ),
		);
		return apply_filters( 'supermag_system_fonts', $supermag_system_fonts );
	}
endif;

/**
 * Fonts array
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_fonts_array') ) :
    function supermag_fonts_array() {
        $supermag_fonts_array =  array(
            'ABeeZee:400,400italic' => 'ABeeZee',
            'Abel' => 'Abel',
            'Abril+Fatface' => 'Abril Fatface',
            'Aldrich' => 'Aldrich',
            'Alegreya:400,400italic,700,900' => 'Alegreya',
            'Alex+Brush' => 'Alex Brush',
            'Alfa+Slab+One' => 'Alfa Slab One',
            'Amaranth:400,400italic,700' => 'Amaranth',
            'Andada' => 'Andada',
            'Anton' => 'Anton',
            'Archivo+Black' => 'Archivo Black',
            'Archivo+Narrow:400,400italic,700' => 'Archivo Narrow',
            'Arimo:400,400italic,700' => 'Arimo',
            'Arvo:400,400italic,700' => 'Arvo',
            'Asap:400,400italic,700' => 'Asap',
            'Bangers' => 'Bangers',
            'BenchNine:400,700' => 'BenchNine',
            'Bevan' => 'Bevan',
            'Bitter:400,400italic,700' => 'Bitter',
            'Bree+Serif' => 'Bree Serif',
            'Cabin:400,400italic,500,600,700' => 'Cabin',
            'Cabin+Condensed:400,500,600,700' => 'Cabin Condensed',
            'Cantarell:400,400italic,700' => 'Cantarell',
            'Carme' => 'Carme',
            'Cherry+Cream+Soda' => 'Cherry Cream Soda',
            'Cinzel:400,700,900' => 'Cinzel',
            'Comfortaa:400,300,700' => 'Comfortaa',
            'Cookie' => 'Cookie',
            'Covered+By+Your+Grace' => 'Covered By Your Grace',
            'Crete+Round:400,400italic' => 'Crete Round',
            'Crimson+Text:400,400italic,600,700' => 'Crimson Text',
            'Cuprum:400,400italic' => 'Cuprum',
            'Dancing+Script:400,700' => 'Dancing Script',
            'Didact+Gothic' => 'Didact Gothic',
            'Droid+Sans:400,700' => 'Droid Sans',
            'Dosis:400,300,600,800' => 'Dosis',
            'Droid+Serif:400,400italic,700' => 'Droid Serif',
            'Economica:400,700,400italic' => 'Economica',
            'EB+Garamond' => 'EB Garamond',
            'Exo:400,300,400italic,600,800' => 'Exo',
            'Exo +2:400,300,400italic,600,700,900' => 'Exo 2',
            'Fira+Sans:400,500' => 'Fira Sans',
            'Fjalla+One' => 'Fjalla One',
            'Francois+One' => 'Francois One',
            'Fredericka+the+Great' => 'Fredericka the Great',
            'Fredoka+One' => 'Fredoka One',
            'Fugaz+One' => 'Fugaz One',
            'Great+Vibes' => 'Great Vibes',
            'Handlee' => 'Handlee',
            'Hammersmith+One' => 'Hammersmith One',
            'Hind:400,300,600,700' => 'Hind',
            'Inconsolata:400,700' => 'Inconsolata',
            'Indie+Flower' => 'Indie Flower',
            'Istok+Web:400,400italic,700' => 'Istok Web',
            'Josefin+Sans:400,600,700,400italic' => 'Josefin Sans',
            'Josefin+Slab:400,400italic,700,600' => 'Josefin Slab',
            'Jura:400,300,500,600' => 'Jura',
            'Karla:400,400italic,700' => 'Karla',
            'Kaushan+Script' => 'Kaushan Script',
            'Kreon:400,300,700' => 'Kreon',
            'Lateef' => 'Lateef',
            'Lato:400,300,400italic,900,700' => 'Lato',
            'Libre+Baskerville:400,400italic,700' => 'Libre Baskerville',
            'Limelight' => 'Limelight',
            'Lobster' => 'Lobster',
            'Lobster+Two:400,700,700italic' => 'Lobster Two',
            'Lora:400,400italic,700,700italic' => 'Lora',
            'Maven+Pro:400,500,700,900' => 'Maven Pro',
            'Merriweather:400,400italic,300,900,700' => 'Merriweather',
            'Merriweather+Sans:400,400italic,700,800' => 'Merriweather Sans',
            'Monda:400,700' => 'Monda',
            'Montserrat:400,700' => 'Montserrat',
            'Muli:400,300italic,300' => 'Muli',
            'News+Cycle:400,700' => 'News Cycle',
            'Noticia+Text:400,400italic,700' => 'Noticia Text',
            'Noto +Sans:400,400italic,700' => 'Noto Sans',
            'Noto +Serif:400,400italic,700' => 'Noto Serif',
            'Nunito:400,300,700' => 'Nunito',
            'Old+Standard +TT:400,400italic,700' => 'Old Standard TT',
            'Open+Sans:400,400italic,600,700' => 'Open Sans',
            'Open+Sans+Condensed:300,300italic,700' => 'Open Sans Condensed',
            'Oswald:400,300,700' => 'Oswald',
            'Oxygen:400,300,700' => 'Oxygen',
            'Pacifico' => 'Pacifico',
            'Passion+One:400,700,900' => 'Passion One',
            'Pathway+Gothic+One' => 'Pathway Gothic One',
            'Patua+One' => 'Patua One',
            'Poiret+One' => 'Poiret One',
            'Pontano+Sans' => 'Pontano Sans',
            'Play:400,700' => 'Play',
            'Playball' => 'Playball',
            'Playfair+Display:400,400italic,700,900' => 'Playfair Display',
            'PT+Sans:400,400italic,700' => 'PT Sans',
            'PT+Sans+Caption:400,700' => 'PT Sans Caption',
            'PT+Sans+Narrow:400,700' => 'PT Sans Narrow',
            'PT+Serif:400,400italic,700' => 'PT Serif',
            'Quattrocento+Sans:400,700,400italic' => 'Quattrocento Sans',
            'Questrial' => 'Questrial',
            'Quicksand:400,700' => 'Quicksand',
            'Raleway:400,300,500,600,700,900' => 'Raleway',
            'Righteous' => 'Righteous',
            'Roboto:400,500,300,700,400italic' => 'Roboto',
            'Roboto+Condensed:400,300,400italic,700' => 'Roboto Condensed',
            'Roboto+Slab:400,300,700' => 'Roboto Slab',
            'Rokkitt:400,700' => 'Rokkitt',
            'Ropa+Sans:400,400italic' => 'Ropa Sans',
            'Russo+One' => 'Russo One',
            'Sanchez:400,400italic' => 'Sanchez',
            'Satisfy' => 'Satisfy',
            'Shadows+Into+Light' => 'Shadows Into Light',
            'Sigmar+One' => 'Sigmar One',
            'Signika:400,300,700' => 'Signika',
            'Six+Caps' => 'Six Caps',
            'Slabo+27px' => 'Slabo 27px',
            'Source+Sans+Pro:400,400italic,600,900,300' => 'Source Sans Pro',
            'Squada+One' => 'Squada One',
            'Tangerine:400,700' => 'Tangerine',
            'Tinos:400,400italic,700' => 'Tinos',
            'Titillium+Web:400,300,400italic,700,900' => 'Titillium Web',
            'Ubuntu:400,400italic,500,700' => 'Ubuntu',
            'Ubuntu+Condensed' => 'Ubuntu Condensed',
            'Varela+Round' => 'Varela Round',
            'Vollkorn:400,400italic,700' => 'Vollkorn',
            'Voltaire' => 'Voltaire',
            'Yanone+Kaffeesatz:400,300,700' => 'Yanone Kaffeesatz'
        );
        return apply_filters( 'supermag_fonts_array', $supermag_fonts_array );
    }
endif;

/**
 * Related posts layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_single_navigation_options') ) :
    function supermag_single_navigation_options() {
        $supermag_single_navigation_options =  array(
            'title-only'  => __( 'Default ( Title )', 'supermag' ),
            'title-image' => __( 'Title and image', 'supermag' ),
            'image-only'  => __( 'Image', 'supermag' ),
            'disable'  => __( 'Disable', 'supermag' ),
        );
        return apply_filters( 'supermag_single_navigation_options', $supermag_single_navigation_options );
    }
endif;

/**
 * Blog Archive Display Options
 *
 * @since SuperMag 1.5.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_blog_archive_category_display_options') ) :
	function supermag_blog_archive_category_display_options() {
		$supermag_blog_archive_category_display_options =  array(
			'default'  => __( 'Default', 'supermag' ),
			'cat-color'  => __( 'Categories with Color', 'supermag' )
		);
		return apply_filters( 'supermag_blog_archive_category_display_options', $supermag_blog_archive_category_display_options );
	}
endif;

/**
 * Related posts layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_reset_options') ) :
    function supermag_reset_options() {
        $supermag_reset_options =  array(
            '0'                     => __( 'Do Not Reset', 'supermag' ),
            'reset-color-options'   => __( 'Reset Colors Options', 'supermag' ),
            'reset-font-options'    => __( 'Reset Font Options', 'supermag' ),
            'reset-all'             => __( 'Reset All', 'supermag' )
        );
        return apply_filters( 'supermag_reset_options', $supermag_reset_options );
    }
endif;

/**
 * Blog/Archive Column Layout
 *
 * @since SuperMag 1.3.1
 *
 * @param null
 * @return array supermag_blog_archive_col
 *
 */
if ( !function_exists('supermag_blog_archive_col') ) :
	function supermag_blog_archive_col() {
		$supermag_blog_archive_col =  array(
			'1'  => __( '1', 'supermag' ),
			'2'  => __( '2', 'supermag' ),
			'3'  => __( '3', 'supermag' ),
		);
		return apply_filters( 'supermag_blog_archive_col', $supermag_blog_archive_col );
	}
endif;

/**
 * Blog Image Size options
 *
 * @since SuperMag 1.4.0
 *
 * @param null
 * @return array $supermag_get_image_sizes_options
 *
 */
if ( !function_exists('supermag_get_image_sizes_options') ) :
    function supermag_get_image_sizes_options( $add_disable = false ) {
        global $_wp_additional_image_sizes;
        $choices = array();
        if ( true == $add_disable ) {
            $choices['disable'] = __( 'No Image', 'supermag' );
        }
        foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
            $choices[ $_size ] = $_size . ' ('. get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
        }
        $choices['full'] = __( 'full (original)', 'supermag' );
        if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {

            foreach ($_wp_additional_image_sizes as $key => $size ) {
                $choices[ $key ] = $key . ' ('. $size['width'] . 'x' . $size['height'] . ')';
            }

        }
        return apply_filters( 'supermag_get_image_sizes_options', $choices );
    }
endif;

/**
 *  Default Theme layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array $supermag_theme_layout
 *
 */
if ( !function_exists('supermag_get_default_theme_options') ) :
    function supermag_get_default_theme_options() {

        $default_theme_options = array(
            /*feature section options*/
            'supermag-slider-selection-from'  => 'from-recent',
            'supermag-slider-from-category'  => 0,
            'supermag-slider-from-tag'  => 0,

            'supermag-slide-1-image'  => '',
            'supermag-slide-1-title'  => '',
            'supermag-slide-1-desc'  => '',
            'supermag-slide-1-link'  => '',
            'supermag-slide-2-image'  => '',
            'supermag-slide-2-title'  => '',
            'supermag-slide-2-desc'  => '',
            'supermag-slide-2-link'  => '',
            'supermag-slide-3-image'  => '',
            'supermag-slide-3-title'  => '',
            'supermag-slide-3-desc'  => '',
            'supermag-slide-3-link'  => '',
            'supermag-slide-4-image'  => '',
            'supermag-slide-4-title'  => '',
            'supermag-slide-4-desc'  => '',
            'supermag-slide-4-link'  => '',
            'supermag-slide-5-image'  => '',
            'supermag-slide-5-title'  => '',
            'supermag-slide-5-desc'  => '',
            'supermag-slide-5-link'  => '',

            'supermag-feature-slider-show-categories'  => 1,
            'supermag-feature-slider-show-date'  => 1,
            'supermag-feature-slider-show-author'  => 1,
            'supermag-feature-slider-show-comments'  => 1,
            'supermag-feature-slider-post-number'  => 3,
            'supermag-feature-slider-content-words'  => 9,
            'supermag-feature-slider-speed'  => 2000,
            'supermag-feature-slider-pause'  => 4000,
            'supermag-feature-slider-enable-autoplay'  => 1,
            'supermag-feature-slider-enable-controls'  => 1,

            'supermag-feature-side-display-options'  => 'post-2-add-2',
            'supermag-feature-side-from-category'  => 0,
            'supermag-feature-post-one'  => -1,
            'supermag-feature-post-two'  => -1,
            'supermag-feature-post-three'  => -1,
            'supermag-feature-post-four'  => -1,
            'supermag-feature-side-show-title'  => 1,
            'supermag-feature-side-show-date'  => 1,
            'supermag-feature-side-show-author'  => 1,
            'supermag-feature-side-show-comments'  => 1,

            'supermag-feature-add-one'  => get_template_directory_uri()."/assets/img/supermag-add-1-240-172.png",
            'supermag-feature-add-one-link'  => "http://www.acmethemes.com/",
            'supermag-feature-add-two'  => get_template_directory_uri()."/assets/img/supermag-add-2-240-172.png",
            'supermag-feature-add-two-link'  => "http://www.acmethemes.com/themes/supermag/",
            'supermag-feature-add-three'  => get_template_directory_uri()."/assets/img/supermag-add-1-240-172.png",
            'supermag-feature-add-three-link'  => "http://www.acmethemes.com/",
            'supermag-feature-add-four'  => get_template_directory_uri()."/assets/img/supermag-add-2-240-172.png",
            'supermag-feature-add-four-link'  => "http://www.acmethemes.com/themes/supermag/",
            'supermag-enable-feature'  => 1,

            'supermag-feature-side-title-length'  => 6,

            /*header options*/
            'supermag-header-logo'  => '',
            'supermag-header-id-display-opt' => 'title-and-tagline',

            'supermag-show-date'  => 1,
            'supermag-header-date-format'  => 'default',
            'supermag-header-time-format'  => 12,
            'supermag-show-time'  => 1,

            'supermag-breaking-news-selection-from'  => 'from-recent',
            'supermag-breaking-news-from-category'  => 0,
            'supermag-breaking-news-title'  => __( 'Recent posts', 'supermag' ),
            'supermag-breaking-news-speed'  => 12000,
            'supermag-breaking-news-number'  => 5,
            'supermag-breaking-news-per-slide'  => 2,
            'supermag-breaking-news-options'  => 'slide',
            'supermag-breaking-news-below-menu'  => '',

            'supermag-facebook-url'  => '',
            'supermag-twitter-url'  => '',
            'supermag-linkedin-url'  => '',
            'supermag-instagram-url'  => '',
            'supermag-youtube-url'  => '',
            'supermag-google-plus-url'  => '',
            'supermag-pinterest-url'  => '',
            'supermag-flickr-url'  => '',
            'supermag-tumblr-url'  => '',
            'supermag-vk-url'  => '',
            'supermag-enable-social'  => '',

            'supermag-header-media-position'  => 'above-menu',
            'supermag-header-media-customizer-link'  => '',
            'supermag-header-image-link'  => esc_url( home_url() ),
            'supermag-header-image-link-new-tab'  => '',

            'supermag-header-main-banner-ads'  => get_template_directory_uri()."/assets/img/supermag-new-ad.png",
            'supermag-header-main-google-ads'  => '',
            'supermag-header-main-banner-ads-link'  => 'http://www.acmethemes.com/themes/supermag/',
            'supermag-header-main-show-banner-ads'  => 'image',
            'supermag-header-logo-ads-display-position'  => 'left-logo-right-ainfo',
            'supermag-header-main-banner-new-tab'  => 1,
            'supermag-menu-show-home-icon'  => 1,
            'supermag-menu-show-search'  => 1,
            'supermag-another-search-type'  => 1,
            'supermag-enable-random-post'  => 1,
            'supermag-enable-sticky-menu'  => '',

            /*footer options*/
            'supermag-footer-copyright'  => sprintf( __( 'AcmeThemes &copy; %s', 'supermag' ), date("Y") ),
            'supermag-footer-top-widgets-number'  => 4,
            'supermag-footer-bottom-widgets-number'  => 4,
            'supermag-footer-gotop'  => 1,
            'supermag-footer-power-text'  => 1,
            'supermag-footer-site-info'  => '',

            /*layout/design options*/
            'supermag-intro-image'  => '',
            'supermag-intro-bg-color'  => '#4db2ec',
            'supermag-enable-intro-loader'  => '',
            'supermag-default-layout'  => 'boxed',
            'supermag-enable-box-shadow'  => '',
            'supermag-button-design'  => 'rounded-rectangle',

            'supermag-front-page-sidebar-layout'  => 'right-sidebar',
            'supermag-sidebar-layout'  => 'right-sidebar',
            'supermag-archive-sidebar-layout'  => 'right-sidebar',

            'supermag-enable-sticky-sidebar'  => 1,
            'supermag-blog-archive-image-layout'  => 'left-image',
            'supermag-blog-archive-image-size' => 'full',
            'supermag-disable-image-zoom' => '',
            'supermag-blog-archive-content-layout'  => 'excerpt',
            'supermag-blog-archive-content-length'  => 60,
            'supermag-blog-archive-more-text'  => __( 'Read More', 'supermag' ),
            'supermag-blog-archive-category-display-options' => 'default',
            'supermag-exclude-categories'  => '',

            'supermag-blog-archive-show-date'  => 1,
            'supermag-blog-archive-show-author'  => 1,
            'supermag-blog-archive-show-comments'  => 1,
            'supermag-blog-archive-show-cats'  => 1,
            'supermag-blog-archive-show-tags'  => 1,

            'supermag-blog-col'     => 1,
            'supermag-archive-col'     => 1,

            /*color*/
            'supermag-site-title-color'  => '#4db2ec',
            'supermag-site-title-hover-color'  => '#2d2d2d',
            'supermag-site-tagline-color'  => '#7a7a7a',
            'supermag-body-text-color'  => '#2d2d2d',
            'supermag-heading-color'  => '#2d2d2d',
            'supermag-primary-color'  => '#4db2ec',
            'supermag-primary-hover-color'  => '#3d3d3d',
            'supermag-link-color'  => '#2d2d2d',
            'supermag-link-hover-color'  => '#4db2ec',
            'supermag-header-top-bg-color'  => '#2d2d2d',
            'supermag-header-main-bg-color'  => '#ffffff',
            'supermag-menu-main-bg-color'  => '#2d2d2d',
            'supermag-menu-active-bg-color'  => '#4db2ec',
            'supermag-menu-hover-bg-color'  => '#4db2ec',
            'supermag-menu-text-color'  => '#FFFFFF',
            'supermag-menu-border-bottom-color'  => '#393939',
            'supermag-breadcrumb-bg-color'  => '#f2f2f2',
            'supermag-sidebar-bg-color'  => '#f2f2f2',
            'supermag-footer-bg-color'  => '#2d2d2d',
            'supermag-footer-heading-color'  => '#ffffff',
            'supermag-footer-text-color'  => '#ffffff',
            'supermag-footer-link-color'  => '#ffffff',
            'supermag-footer-link-hover-color'  => '#4db2ec',
            'supermag-cat-hover-color'  => '#2d2d2d',

            /*font family*/
            'supermag-font-type'  => 'google',
            'supermag-site-title-fm'  => 'Roboto:400,500,300,700,400italic',
            'supermag-site-tagline-fm'  => 'Roboto:400,500,300,700,400italic',
            'supermag-menu-fm'  => 'Roboto:400,500,300,700,400italic',
            'supermag-heading-fm'  => 'Roboto:400,500,300,700,400italic',
            'supermag-body-fm'  => 'Roboto:400,500,300,700,400italic',

            'supermag-site-title-system-fm'  => 'Verdana',
            'supermag-site-tagline-system-fm'  => 'Verdana',
            'supermag-menu-system-fm'  => 'Verdana',
            'supermag-heading-system-fm'  => 'Verdana',
            'supermag-body-system-fm'  => 'Verdana',
            
            'supermag-custom-css'  => '',

            /*single related post options*/
            'supermag-show-author-info'  => '',
            'supermag-single-post-layout'  => 'large-image',
            'supermag-single-image-layout'  => 'full',
            'supermag-single-category-display-options' => 'default',
            /*single related post options*/

            'supermag-related-posts-display'  => 'below-related-posts',
            'supermag-related-post-display-from'  => 'cat',
            'supermag-related-title'  => __( 'Related posts', 'supermag' ),
            'supermag-related-posts-message'  => __( 'Only apply when you choose "Below Content" in -Related Posts Display Options', 'supermag' ),
            'supermag-related-posts-column-number'  => 3,
            'supermag-related-posts-show-image'  =>1,
            'supermag-related-posts-first-featured'  =>'',
            'supermag-related-posts-show-date'  =>1,
            'supermag-related-posts-show-author'  =>1,
            'supermag-related-posts-show-comments'  =>1,
            'supermag-related-posts-show-categories'  =>1,
            'supermag-related-posts-number'  => 3,
            'supermag-related-posts-content-words'  => 9,

            'supermag-single-navigation-options'  => 'title-image',
            'supermag-hide-comment'  => '',
            'supermag-comment-title'  => __( 'Leave a Comment', 'supermag' ),
            'supermag-comment-button-text'  => __( 'Add Comment', 'supermag' ),
            'supermag-comment-notes-after'  => '',

            'supermag-single-show-date'  =>1,
            'supermag-single-show-author'  =>1,
            'supermag-single-show-cats'  =>1,
            'supermag-single-show-tags'  =>1,

            /*theme options*/
            'supermag-search-placholder'  => __( 'Search', 'supermag' ),
            'supermag-breadcrumb-options'  => 'simple',
            'supermag-you-are-here-text'  => __( 'You are here', 'supermag' ),
            'supermag-pagination-option'  => 'default',
            'supermag-side-show-message'  => '',
            'supermag-hide-front-page-content'  => '',
            'supermag-enable-mega-menu'  => 1,
            'supermag-enable-date-diff'  => '',

            /*no image*/
            'supermag-no-image-thumbnail'  => get_template_directory_uri().'/assets/img/no-image-500-280.png',
            'supermag-no-image-medium'  => get_template_directory_uri().'/assets/img/no-image-660-365.png',
            'supermag-no-image-large'  => get_template_directory_uri().'/assets/img/no-image-840-480.png',
            'supermag-no-image-post-thumb'  => get_template_directory_uri().'/assets/img/no-image-240-172.png',

	        /*woocommerce*/
            'supermag-wc-shop-archive-sidebar-layout'     => 'no-sidebar',
            'supermag-wc-product-column-number'           => 4,
            'supermag-wc-shop-archive-total-product'      => 16,
            'supermag-wc-single-product-sidebar-layout'   => 'no-sidebar',
            
            /*reset options*/
            'supermag-reset-options'  => '0'

        );
        return apply_filters( 'supermag_default_theme_options', $default_theme_options );
    }
endif;

/**
 *  Get theme options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array supermag_theme_options
 *
 */
if ( !function_exists('supermag_get_theme_options') ) :
    function supermag_get_theme_options() {
        $supermag_default_theme_options = supermag_get_default_theme_options();
        $supermag_get_theme_options = get_theme_mod( 'supermag_theme_options');

        if( is_array($supermag_get_theme_options )){
            return array_merge( $supermag_default_theme_options ,$supermag_get_theme_options );
        }
        else{
            return $supermag_default_theme_options;
        }
    }
endif;