<?php
/*active callback function for options*/
if ( !function_exists('supermag_active_callback_blog_archive_content_layout') ) :
    function supermag_active_callback_blog_archive_content_layout() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if(
            'excerpt' == $supermag_customizer_all_values['supermag-blog-archive-content-layout']
        ){
            return true;
        }
        return false;
    }
endif;

/*adding sections for blog layout options panel*/
$wp_customize->add_section( 'supermag-design-blog-layout-option', array(
    'priority'       => 30,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Blog/Archive Layout Options', 'supermag' ),
    'panel'          => 'supermag-design-panel'
) );

/*blog image layout*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-image-layout]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-blog-archive-image-layout'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_blog_archive_image_layout();
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-image-layout]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Image Layout Options', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-blog-archive-image-layout]',
    'type'	  	=> 'select'
) );

/*blog content layout*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-content-layout]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-blog-archive-content-layout'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_blog_archive_content_layout();
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-content-layout]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Show Description From', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-blog-archive-content-layout]',
    'type'	  	=> 'select'
) );

/*Content length*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-content-length]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-blog-archive-content-length'],
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-content-length]', array(
    'label'		=> __( 'Description Length In Words', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-blog-archive-content-length]',
    'type'	  	=> 'number',
    'active_callback'   => 'supermag_active_callback_blog_archive_content_layout'
) );

/*Read More Text*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-more-text]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-blog-archive-more-text'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-more-text]', array(
    'label'		=> __( 'Read More Text', 'supermag' ),
    'description'=> __( 'Left Empty to Disable', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-blog-archive-more-text]',
    'type'	  	=> 'text'
) );

/*Entry Footer/Category Display Options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-category-display-options]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-category-display-options'],
	'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_blog_archive_category_display_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-category-display-options]', array(
	'choices'  	=> $choices,
	'label'		=> __( 'Entry Footer/Category Display Options', 'supermag' ),
	'section'   => 'supermag-design-blog-layout-option',
	'settings'  => 'supermag_theme_options[supermag-blog-archive-category-display-options]',
	'type'	  	=> 'select',
) );

/*Exclude Categories In Blog Page*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-exclude-categories]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-exclude-categories'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-exclude-categories]', array(
    'label'		=> __( 'Exclude Categories In Blog/Archive Pages', 'supermag' ),
    'description'=>  __( 'Enter categories ids in comma separated eg: 3,5,7,95. For including all categories left blank', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-exclude-categories]',
    'type'	  	=> 'text'
) );

/*blog col*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-col]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-col'],
	'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_blog_archive_col();
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-col]', array(
	'choices'  	=> $choices,
	'label'		=> __( 'Blog Columns', 'supermag' ),
	'section'   => 'supermag-design-blog-layout-option',
	'settings'  => 'supermag_theme_options[supermag-blog-col]',
	'type'	  	=> 'select'
) );

/*Archive col*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-archive-col]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-archive-col'],
	'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_blog_archive_col();
$wp_customize->add_control( 'supermag_theme_options[supermag-archive-col]', array(
	'choices'  	=> $choices,
	'label'		=> __( 'Archive Columns', 'supermag' ),
	'section'   => 'supermag-design-blog-layout-option',
	'settings'  => 'supermag_theme_options[supermag-archive-col]',
	'type'	  	=> 'select'
) );

/*blog image layout*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-image-size]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-blog-archive-image-size'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_get_image_sizes_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-image-size]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Image Layout Options', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-blog-archive-image-size]',
    'type'	  	=> 'select',
) );

/*enable image zoom*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-disable-image-zoom]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-disable-image-zoom'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );

$wp_customize->add_control( 'supermag_theme_options[supermag-disable-image-zoom]', array(
    'label'		=> __( 'Disable Zoom Image on Hover', 'supermag' ),
    'section'   => 'supermag-design-blog-layout-option',
    'settings'  => 'supermag_theme_options[supermag-disable-image-zoom]',
    'type'	  	=> 'checkbox',
) );

/*show date*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-show-date]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-show-date'],
	'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-show-date]', array(
	'label'		        => __( 'Show Date', 'supermag' ),
	'section'           => 'supermag-design-blog-layout-option',
	'settings'          => 'supermag_theme_options[supermag-blog-archive-show-date]',
	'type'	  	        => 'checkbox',
	'priority'          => 60,
) );

/*show author*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-show-author]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-show-author'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-show-author]', array(
	'label'		        => __( 'Show Author', 'supermag' ),
	'section'           => 'supermag-design-blog-layout-option',
	'settings'          => 'supermag_theme_options[supermag-blog-archive-show-author]',
	'type'	  	        => 'checkbox',
	'priority'          => 70
) );

/*show cats*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-show-cats]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-show-cats'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-show-cats]', array(
	'label'		        => __( 'Show Cats', 'supermag' ),
	'section'           => 'supermag-design-blog-layout-option',
	'settings'          => 'supermag_theme_options[supermag-blog-archive-show-cats]',
	'type'	  	        => 'checkbox',
	'priority'          => 80
) );

/*show tag*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-show-tags]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-show-tags'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-show-tags]', array(
	'label'		        => __( 'Show Tags', 'supermag' ),
	'section'           => 'supermag-design-blog-layout-option',
	'settings'          => 'supermag_theme_options[supermag-blog-archive-show-tags]',
	'type'	  	        => 'checkbox',
	'priority'          => 90
) );

/*show comments*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-blog-archive-show-comments]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-blog-archive-show-comments'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-blog-archive-show-comments]', array(
	'label'		        => __( 'Show Comments', 'supermag' ),
	'section'           => 'supermag-design-blog-layout-option',
	'settings'          => 'supermag_theme_options[supermag-blog-archive-show-comments]',
	'type'	  	        => 'checkbox',
	'priority'          => 100
) );