<?php
/*customizing default supermag-font-family options*/
$wp_customize->add_section( 'supermag-font-family', array(
    'priority'       => 40,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Font Family', 'supermag' ),
    'panel'          => 'supermag-design-panel'
) );

require_once supermag_file_directory('acmethemes/customizer/design-options/system-fonts.php');

/*Site Title Font Family*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-site-title-fm]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-site-title-fm'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_fonts_array();
$wp_customize->add_control( 'supermag_theme_options[supermag-site-title-fm]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Site Title Font Family', 'supermag' ),
    'section'   => 'supermag-font-family',
    'settings'  => 'supermag_theme_options[supermag-site-title-fm]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_if_google_font_type',
) );

/*Site Tagline Font Family*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-site-tagline-fm]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-site-tagline-fm'],
    'sanitize_callback' => 'supermag_sanitize_select',
) );
$choices = supermag_fonts_array();
$wp_customize->add_control( 'supermag_theme_options[supermag-site-tagline-fm]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Site Tagline Font Family', 'supermag' ),
    'section'   => 'supermag-font-family',
    'settings'  => 'supermag_theme_options[supermag-site-tagline-fm]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_if_google_font_type',
) );

/*Menu Font Family*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-menu-fm]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-menu-fm'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_fonts_array();
$wp_customize->add_control( 'supermag_theme_options[supermag-menu-fm]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Menu Font Family', 'supermag' ),
    'section'   => 'supermag-font-family',
    'settings'  => 'supermag_theme_options[supermag-menu-fm]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_if_google_font_type',
) );

/*Heading Font Family*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-heading-fm]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-heading-fm'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_fonts_array();
$wp_customize->add_control( 'supermag_theme_options[supermag-heading-fm]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Heading Font Family', 'supermag' ),
    'section'   => 'supermag-font-family',
    'settings'  => 'supermag_theme_options[supermag-heading-fm]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_if_google_font_type',
) );

/*Body Font Family*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-body-fm]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-body-fm'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_fonts_array();
$wp_customize->add_control( 'supermag_theme_options[supermag-body-fm]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Body Font Family', 'supermag' ),
    'section'   => 'supermag-font-family',
    'settings'  => 'supermag_theme_options[supermag-body-fm]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_if_google_font_type',
) );