<?php
/*adding sections for header options panel*/
$wp_customize->add_section( 'supermag-intro-loader', array(
    'priority'       => 2,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Intro Loader Options', 'supermag' ),
    'description'    => __( 'If you do not select any intro image, default intro will display.', 'supermag' ),
    'panel'          => 'supermag-design-panel'
) );

/*intro load enable*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-enable-intro-loader]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-enable-intro-loader'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-enable-intro-loader]', array(
	'label'		=> __( 'Enable Intro Loader', 'supermag' ),
	'section'   => 'supermag-intro-loader',
	'settings'  => 'supermag_theme_options[supermag-enable-intro-loader]',
	'type'	  	=> 'checkbox',
	'priority'  => 1
) );

/*intro image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-intro-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-intro-image'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-intro-image]',
        array(
            'label'		=> __( 'Intro Loader Middle Image', 'supermag' ),
            'section'   => 'supermag-intro-loader',
            'settings'  => 'supermag_theme_options[supermag-intro-image]',
            'type'	  	=> 'image',
            'priority'  => 10
        )
    )
);

/*intro bg*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-intro-bg-color]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-intro-bg-color'],
    'sanitize_callback' => 'sanitize_hex_color'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-intro-bg-color]', array(
    'label'		=> __( 'Background Color', 'supermag' ),
    'section'   => 'supermag-intro-loader',
    'settings'  => 'supermag_theme_options[supermag-intro-bg-color]',
    'type'	  	=> 'color',
    'priority'  => 20
) );