<?php
/*adding sections feature side section*/
$wp_customize->add_section( 'supermag-feature-side', array(
    'priority'       => 20,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Slider Right Section', 'supermag' ),
    'panel'          => 'supermag-feature-panel'
) );

/*feature side layout options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-display-options]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-display-options'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_feature_side_display_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-display-options]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Select Layout For Featured Side', 'supermag' ),
    'section'   => 'supermag-feature-side',
    'settings'  => 'supermag_theme_options[supermag-feature-side-display-options]',
    'type'	  	=> 'select',
    'priority'  => 10
) );

/*feature side cat*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-from-category]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-from-category'],
    'sanitize_callback' => 'supermag_sanitize_number'
) );

$wp_customize->add_control(
    new Supermag_Customize_Category_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-side-from-category]',
        array(
            'label'		        => __( 'Select Category For Side', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-side-from-category]',
            'type'	  	        => 'category_dropdown',
            'priority'          => 20,
            'active_callback'   => 'supermag_side_cat'
        )
    )
);

/*feature side post-one*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-post-one]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-post-one'],
    'sanitize_callback' => 'supermag_sanitize_number'
) );
$wp_customize->add_control(
    new Supermag_Customize_Post_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-post-one]',
        array(
            'label'		        => __( 'Select Post One', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-post-one]',
            'type'	  	        => 'post_dropdown',
            'priority'          => 30,
            'active_callback'   => 'supermag_post_one'
        )
    )
);

/*feature side post-two*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-post-two]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-post-two'],
    'sanitize_callback' => 'supermag_sanitize_number'
) );
$wp_customize->add_control(
    new Supermag_Customize_Post_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-post-two]',
        array(
            'label'		        => __( 'Select Post Two', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-post-two]',
            'type'	  	        => 'post_dropdown',
            'priority'          => 40,
            'active_callback'   => 'supermag_post_two'
        )
    )
);

/*feature side post-three*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-post-three]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-post-three'],
    'sanitize_callback' => 'supermag_sanitize_number'
) );
$wp_customize->add_control(
    new Supermag_Customize_Post_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-post-three]',
        array(
            'label'		        => __( 'Select Post Three', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-post-three]',
            'type'	  	        => 'post_dropdown',
            'priority'          => 50,
            'active_callback'   => 'supermag_post_three'
        )
    )
);

/*feature side post-four*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-post-four]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-post-four'],
    'sanitize_callback' => 'supermag_sanitize_number',
) );
$wp_customize->add_control(
    new Supermag_Customize_Post_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-post-four]',
        array(
            'label'		        => __( 'Select Post Four', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-post-four]',
            'type'	  	        => 'post_dropdown',
            'priority'          => 60,
            'active_callback'   => 'supermag_post_four'
        )
    )
);

/*show title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-show-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-show-title'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-show-title]', array(
    'label'		        => __( 'Show Title', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-side-show-title]',
    'type'	  	        => 'checkbox',
    'priority'          => 70,
    'active_callback'   => 'supermag_cat_and_post'
) );

/*show date*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-show-date]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-show-date'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-show-date]', array(
    'label'		        => __( 'Show Date', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-side-show-date]',
    'type'	  	        => 'checkbox',
    'priority'          => 80,
    'active_callback'   => 'supermag_cat_and_post'
) );

/*show author*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-show-author]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-show-author'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-show-author]', array(
    'label'		        => __( 'Show Author', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-side-show-author]',
    'type'	  	        => 'checkbox',
    'priority'          => 90,
    'active_callback'   => 'supermag_cat_and_post'
) );

/*show comments*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-show-comments]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-side-show-comments'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-show-comments]', array(
    'label'		        => __( 'Show Comments', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-side-show-comments]',
    'type'	  	        => 'checkbox',
    'priority'          => 100,
    'active_callback'   => 'supermag_cat_and_post'
) );

/*message*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-side-show-message]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-side-show-message'],
    'sanitize_callback' => 'esc_attr'
) );
$wp_customize->add_control(
    new Supermag_Customize_Message_Control(
        $wp_customize,
        'supermag_theme_options[supermag-side-show-message]',
        array(
            'section'           => 'supermag-feature-side',
            'description'       => '<hr />',
            'settings'          => 'supermag_theme_options[supermag-side-show-message]',
            'type'	  	        => 'message',
            'priority'          => 110,
            'active_callback'   => 'supermag_cat_and_post'
        )
    )
);

/*Advertisement*/
/*slider side ad one*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-one]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-one'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-add-one]',
        array(
            'label'		        => __( 'Enter Image One', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-add-one]',
            'type'	  	        => 'image',
            'priority'          => 120,
            'description'       => __( 'Recommended image size of 240*172', 'supermag' ),
            'active_callback'   => 'supermag_add_one'
        )
    )
);

/*slider side ad one link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-one-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-one-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-add-one-link]', array(
    'label'		        => __( 'Image One Link', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-add-one-link]',
    'type'	  	        => 'url',
    'priority'          => 130,
    'active_callback'   => 'supermag_add_one'
) );

/*slider side ad two*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-two]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-two'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-add-two]',
        array(
            'label'		        => __( 'Enter Image Two', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-add-two]',
            'type'	  	        => 'image',
            'priority'          => 140,
            'description'       => __( 'Recommended image size of 240*172', 'supermag' ),
            'active_callback'   => 'supermag_add_two'
        )
    )
);

/*slider side ad two link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-two-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-two-link'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-add-two-link]', array(
    'label'		        => __( 'Image Two Link', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-add-two-link]',
    'type'	  	        => 'url',
    'priority'          => 150,
    'active_callback'   => 'supermag_add_two'
) );

/*slider side ad three*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-three]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-three'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-add-three]',
        array(
            'label'		        => __( 'Enter Image Three', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-add-three]',
            'type'	  	        => 'image',
            'priority'          => 160,
            'description'       => __( 'Recommended image size of 240*172', 'supermag' ),
            'active_callback'   => 'supermag_add_three'
        )
    )
);

/*slider side ad three link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-three-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-three-link'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-add-three-link]', array(
    'label'		        => __( 'Image Three Link', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-add-three-link]',
    'type'	  	        => 'url',
    'priority'          => 170,
    'active_callback'   => 'supermag_add_three'
) );

/*slider side ad four*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-four]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-four'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-feature-add-four]',
        array(
            'label'		        => __( 'Enter Image Four', 'supermag' ),
            'section'           => 'supermag-feature-side',
            'settings'          => 'supermag_theme_options[supermag-feature-add-four]',
            'type'	  	        => 'image',
            'priority'          => 180,
            'description'       => __( 'Recommended image size of 240*172', 'supermag' ),
            'active_callback'   => 'supermag_add_four'
        )
    )
);

/*slider side ad four link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-add-four-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-add-four-link'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-add-four-link]', array(
    'label'		        => __( 'Image Four Link', 'supermag' ),
    'section'           => 'supermag-feature-side',
    'settings'          => 'supermag_theme_options[supermag-feature-add-four-link]',
    'type'	  	        => 'url',
    'priority'          => 190,
    'active_callback'   => 'supermag_add_four'
) );
/*Advertisement end*/

/*title length*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-side-title-length]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-feature-side-title-length'],
	'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-side-title-length]', array(
	'label'		=> __( 'Title Length in Words', 'supermag' ),
	'section'   => 'supermag-feature-side',
	'settings'  => 'supermag_theme_options[supermag-feature-side-title-length]',
	'type'	  	=> 'number',
	'priority'  => 200,
	'active_callback'   => 'supermag_cat_and_post'
) );

/*callback functions*/
if ( !function_exists('supermag_side_cat') ) :
    function supermag_side_cat(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'from-category' == $layout ){
            return true;
        }
        else{
            return false;
        }
    }
endif;

if ( !function_exists('supermag_cat_and_post') ) :
    function supermag_cat_and_post(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'add-4' == $layout ){
            return false;
        }
        else{
            return true;
        }
    }
endif;

if ( !function_exists('supermag_post_one') ) :
    function supermag_post_one(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'add-4' == $layout || 'from-recent' == $layout || 'from-category' == $layout ){
            return false;
        }
        else{
            return true;
        }
    }
endif;

if ( !function_exists('supermag_post_two') ) :
    function supermag_post_two(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'add-4' == $layout || 'post-1-add-3' == $layout || 'from-recent' == $layout || 'from-category' == $layout ){
            return false;
        }
        else{
            return true;
        }
    }
endif;

if ( !function_exists('supermag_post_three') ) :
    function supermag_post_three(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'post-4' == $layout || 'post-3-add-1' == $layout ){
            return true;
        }
        else{
            return false;
        }
    }
endif;

if ( !function_exists('supermag_post_four') ) :
    function supermag_post_four(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'post-4' == $layout ){
            return true;
        }
        else{
            return false;
        }
    }
endif;

/*add start*/
if ( !function_exists('supermag_add_one') ) :
    function supermag_add_one(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'post-4' == $layout || 'from-recent' == $layout || 'from-category' == $layout ){
            return false;
        }
        else{
            return true;
        }
    }
endif;

if ( !function_exists('supermag_add_two') ) :
    function supermag_add_two(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'post-4' == $layout || 'post-3-add-1' == $layout || 'from-recent' == $layout || 'from-category' == $layout ){
            return false;
        }
        else{
            return true;
        }
    }
endif;

if ( !function_exists('supermag_add_three') ) :
    function supermag_add_three(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'add-4' == $layout || 'post-1-add-3' == $layout ){
            return true;
        }
        else{
            return false;
        }
    }
endif;

if ( !function_exists('supermag_add_four') ) :
    function supermag_add_four(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
        if( 'add-4' == $layout ){
            return true;
        }
        else{
            return false;
        }
    }
endif;