<?php
/*active callback function for slider*/
if ( !function_exists('supermag_active_callback_slider_from_cat') ) :
    function supermag_active_callback_slider_from_cat() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if( 'from-category' == $supermag_customizer_all_values['supermag-slider-selection-from'] ){
            return true;
        }
        return false;
    }
endif;

if ( !function_exists('supermag_active_callback_slider_from_tag') ) :
    function supermag_active_callback_slider_from_tag() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if( 'from-tag' == $supermag_customizer_all_values['supermag-slider-selection-from'] ){
            return true;
        }
        return false;
    }
endif;

if ( !function_exists('supermag_active_callback_slider_from_custom') ) :
    function supermag_active_callback_slider_from_custom() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if( 'from-custom' == $supermag_customizer_all_values['supermag-slider-selection-from'] ){
            return true;
        }
        return false;
    }
endif;

/*adding sections for front-page theme options panel*/
$wp_customize->add_section( 'supermag-feature-slider', array(
    'priority'       => 10,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Featured Slider', 'supermag' ),
    'panel'          => 'supermag-feature-panel'
) );

/*Slider Selection From*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slider-selection-from]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slider-selection-from'],
    'sanitize_callback' => 'supermag_sanitize_select',
) );
$choices = supermag_slider_selection_from();
$wp_customize->add_control( 'supermag_theme_options[supermag-slider-selection-from]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Slider Selection From', 'supermag' ),
    'section'   => 'supermag-feature-slider',
    'settings'  => 'supermag_theme_options[supermag-slider-selection-from]',
    'type'	  	=> 'select',
    'priority'  => 1
) );

/*slider from category*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slider-from-category]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slider-from-category'],
    'sanitize_callback' => 'supermag_sanitize_number',
) );

$wp_customize->add_control(
    new Supermag_Customize_Category_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slider-from-category]',
        array(
            'label'		        => __( 'Select Category For Slider', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slider-from-category]',
            'type'	  	        => 'category_dropdown',
            'priority'          => 5,
            'active_callback'   => 'supermag_active_callback_slider_from_cat'
        )
    )
);

/*slider from tag*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slider-from-tag]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slider-from-tag'],
    'sanitize_callback' => 'supermag_sanitize_number',
) );

$wp_customize->add_control(
    new Supermag_Customize_Tag_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slider-from-tag]',
        array(
            'label'		        => __( 'Select Tag For Slider', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slider-from-tag]',
            'type'	  	        => 'tag_dropdown',
            'priority'          => 10,
            'active_callback'   => 'supermag_active_callback_slider_from_tag'
        )
    )
);

/*Slider from custom*/
/*slide 1 image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-1-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-1-image'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slide-1-image]',
        array(
            'label'		        => __( 'Slide 1 Image', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slide-1-image]',
            'type'	  	        => 'image',
            'priority'          => 20,
            'active_callback'   => 'supermag_active_callback_slider_from_custom'
        )
    )
);

/*slide 1 title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-1-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-1-title'],
    'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-1-title]', array(
    'label'		        => __( 'Slide 1 Title', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-1-title]',
    'type'	  	        => 'text',
    'priority'          => 30,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 1 desc*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-1-desc]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-1-desc'],
    'sanitize_callback' => 'esc_textarea',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-1-desc]', array(
    'label'		        => __( 'Slide 1 Description', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-1-desc]',
    'type'	  	        => 'textarea',
    'priority'          => 40,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 1 link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-1-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-1-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-1-link]', array(
    'label'		        => __( 'Slide 1 Link', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-1-link]',
    'type'	  	        => 'url',
    'priority'          => 50,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 2 image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-2-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-2-image'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slide-2-image]',
        array(
            'label'		        => __( 'Slide 2 Image', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slide-2-image]',
            'type'	  	        => 'image',
            'priority'          => 60,
            'active_callback'   => 'supermag_active_callback_slider_from_custom'
        )
    )
);

/*slide 2 title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-2-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-2-title'],
    'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-2-title]', array(
    'label'		        => __( 'Slide 2 Title', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-2-title]',
    'type'	  	        => 'text',
    'priority'          => 70,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 2 desc*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-2-desc]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-2-desc'],
    'sanitize_callback' => 'esc_textarea',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-2-desc]', array(
    'label'		        => __( 'Slide 2 Description', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-2-desc]',
    'type'	  	        => 'textarea',
    'priority'          => 80,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 2 link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-2-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-2-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-2-link]', array(
    'label'		        => __( 'Slide 2 Link', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-2-link]',
    'type'	  	        => 'url',
    'priority'          => 90,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 3 image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-3-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-3-image'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slide-3-image]',
        array(
            'label'		        => __( 'Slide 3 Image', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slide-3-image]',
            'type'	  	        => 'image',
            'priority'          => 100,
            'active_callback'   => 'supermag_active_callback_slider_from_custom'
        )
    )
);

/*slide 3 title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-3-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-3-title'],
    'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-3-title]', array(
    'label'		        => __( 'Slide 3 Title', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-3-title]',
    'type'	  	        => 'text',
    'priority'          => 110,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 3 desc*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-3-desc]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-3-desc'],
    'sanitize_callback' => 'esc_textarea',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-3-desc]', array(
    'label'		        => __( 'Slide 3 Description', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-3-desc]',
    'type'	  	        => 'textarea',
    'priority'          => 130,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 3 link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-3-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-3-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-3-link]', array(
    'label'		        => __( 'Slide 3 Link', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-3-link]',
    'type'	  	        => 'url',
    'priority'          => 130,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 4 image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-4-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-4-image'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slide-4-image]',
        array(
            'label'		        => __( 'Slide 4 Image', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slide-4-image]',
            'type'	  	        => 'image',
            'priority'          => 140,
            'active_callback'   => 'supermag_active_callback_slider_from_custom'
        )
    )
);

/*slide 4 title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-4-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-4-title'],
    'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-4-title]', array(
    'label'		        => __( 'Slide 4 Title', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-4-title]',
    'type'	  	        => 'text',
    'priority'          => 150,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 4 desc*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-4-desc]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-4-desc'],
    'sanitize_callback' => 'esc_textarea',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-4-desc]', array(
    'label'		        => __( 'Slide 4 Description', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-4-desc]',
    'type'	  	        => 'textarea',
    'priority'          => 160,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 4 link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-4-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-4-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-4-link]', array(
    'label'		        => __( 'Slide 4 Link', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-4-link]',
    'type'	  	        => 'url',
    'priority'          => 170,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 5 image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-5-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-5-image'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-slide-5-image]',
        array(
            'label'		        => __( 'Slide 5 Image', 'supermag' ),
            'section'           => 'supermag-feature-slider',
            'settings'          => 'supermag_theme_options[supermag-slide-5-image]',
            'type'	  	        => 'image',
            'priority'          => 180,
            'active_callback'   => 'supermag_active_callback_slider_from_custom'
        )
    )
);

/*slide 5 title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-5-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-5-title'],
    'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-5-title]', array(
    'label'		        => __( 'Slide 5 Title', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-5-title]',
    'type'	  	        => 'text',
    'priority'          => 190,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 5 desc*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-5-desc]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-5-desc'],
    'sanitize_callback' => 'esc_textarea',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-5-desc]', array(
    'label'		        => __( 'Slide 5 Description', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-5-desc]',
    'type'	  	        => 'textarea',
    'priority'          => 200,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );

/*slide 5 link*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-slide-5-link]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-slide-5-link'],
    'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-slide-5-link]', array(
    'label'		        => __( 'Slide 5 Link', 'supermag' ),
    'section'           => 'supermag-feature-slider',
    'settings'          => 'supermag_theme_options[supermag-slide-5-link]',
    'type'	  	        => 'url',
    'priority'          => 210,
    'active_callback'   => 'supermag_active_callback_slider_from_custom'
) );