<?php
/*active callback function for options*/
if ( !function_exists('supermag_active_callback_slider_from_cat_post') ) :
    function supermag_active_callback_slider_from_cat_post() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if(
            'from-category' == $supermag_customizer_all_values['supermag-slider-selection-from'] ||
            'from-tag' == $supermag_customizer_all_values['supermag-slider-selection-from'] ||
            'from-recent' == $supermag_customizer_all_values['supermag-slider-selection-from']
        ){
            return true;
        }
        return false;
    }
endif;

/*adding sections for slider Options*/
$wp_customize->add_section( 'supermag-slider-options', array(
    'priority'       => 10,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Featured Slider Options', 'supermag' ),
    'description'    => __( 'Some of the options not display if you have selected slider from "Custom"', 'supermag' ),
    'panel'          => 'supermag-feature-panel'
) );

/*Category posts show categories*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-show-categories]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-show-categories'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-show-categories]', array(
    'label'		        => __( 'Show Categories', 'supermag' ),
    'section'           => 'supermag-slider-options',
    'settings'          => 'supermag_theme_options[supermag-feature-slider-show-categories]',
    'type'	  	        => 'checkbox',
    'priority'          => 60,
    'active_callback'   => 'supermag_active_callback_slider_from_cat_post'
) );

/*Category posts show date*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-show-date]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-show-date'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-show-date]', array(
    'label'		        => __( 'Show Date', 'supermag' ),
    'section'           => 'supermag-slider-options',
    'settings'          => 'supermag_theme_options[supermag-feature-slider-show-date]',
    'type'	  	        => 'checkbox',
    'priority'          => 70,
    'active_callback'   => 'supermag_active_callback_slider_from_cat_post'
) );

/*Category posts show author*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-show-author]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-show-author'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-show-author]', array(
    'label'		        => __( 'Show Author', 'supermag' ),
    'section'           => 'supermag-slider-options',
    'settings'          => 'supermag_theme_options[supermag-feature-slider-show-author]',
    'type'	  	        => 'checkbox',
    'priority'          => 80,
    'active_callback'   => 'supermag_active_callback_slider_from_cat_post'
) );

/*Category posts show comments*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-show-comments]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-show-comments'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-show-comments]', array(
    'label'		        => __( 'Show Comments', 'supermag' ),
    'section'           => 'supermag-slider-options',
    'settings'          => 'supermag_theme_options[supermag-feature-slider-show-comments]',
    'type'	  	        => 'checkbox',
    'priority'          => 80,
    'active_callback'   => 'supermag_active_callback_slider_from_cat_post'
) );

/*Category posts number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-post-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-post-number'],/*3*/
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-post-number]', array(
    'label'		        => __( 'Number Of Posts To Show', 'supermag' ),
    'section'           => 'supermag-slider-options',
    'settings'          => 'supermag_theme_options[supermag-feature-slider-post-number]',
    'type'	  	        => 'number',
    'priority'          => 100,
    'active_callback'   => 'supermag_active_callback_slider_from_cat_post'
) );

/*Category posts words count*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-content-words]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-content-words'],/*9*/
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-content-words]', array(
    'label'		=> __( 'Number of Words In Contents', 'supermag' ),
    'section'   => 'supermag-slider-options',
    'settings'  => 'supermag_theme_options[supermag-feature-slider-content-words]',
    'type'	  	=> 'number',
    'priority'  => 100
) );

/*other slider options*/
/*Slider speed options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-speed]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-speed'],
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-speed]', array(
    'label'		    => __( 'Slider Speed', 'supermag' ),
    'description'   => __( 'Slide transition duration (in ms)', 'supermag' ),
    'section'       => 'supermag-slider-options',
    'settings'      => 'supermag_theme_options[supermag-feature-slider-speed]',
    'type'	  	    => 'number',
    'priority'      => 110
) );

/*Slider pause options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-pause]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-pause'],
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-pause]', array(
    'label'		    => __( 'Slider Pause', 'supermag' ),
    'description'   => __( 'The amount of time (in ms) between each auto transition', 'supermag' ),
    'section'       => 'supermag-slider-options',
    'settings'      => 'supermag_theme_options[supermag-feature-slider-pause]',
    'type'	  	    => 'number',
    'priority'      => 115
) );

/*enable autoplay*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-enable-autoplay]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-enable-autoplay'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-enable-autoplay]', array(
    'label'		=> __( 'Enable Autoplay', 'supermag' ),
    'description'=> __( 'Slides will automatically transition', 'supermag' ),
    'section'   => 'supermag-slider-options',
    'settings'  => 'supermag_theme_options[supermag-feature-slider-enable-autoplay]',
    'type'	  	=> 'checkbox',
    'priority'  => 110
) );

/*enable controls*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-feature-slider-enable-controls]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-feature-slider-enable-controls'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-feature-slider-enable-controls]', array(
    'label'		    => __( 'Enable Controls', 'supermag' ),
    'description'   => __( 'The "Next" / "Prev" controls will be added', 'supermag' ),
    'section'       => 'supermag-slider-options',
    'settings'      => 'supermag_theme_options[supermag-feature-slider-enable-controls]',
    'type'	  	    => 'checkbox',
    'priority'      => 120
) );