<?php
/*adding sections for footer options*/
$wp_customize->add_section( 'supermag-footer-option', array(
    'priority'       => 80,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Footer Option', 'supermag' )
) );

/*footer copyright*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-copyright]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-copyright'],
    'sanitize_callback' => 'wp_kses_post',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-copyright]', array(
    'label'		=> __( 'Copyright Text', 'supermag' ),
    'section'   => 'supermag-footer-option',
    'settings'  => 'supermag_theme_options[supermag-footer-copyright]',
    'type'	  	=> 'text',
    'priority'  => 10
) );

/*footer top widget number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-top-widgets-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-top-widgets-number'],
    'sanitize_callback' => 'wp_kses_post'
) );
$choices = supermag_footer_top_sidebar_number();
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-top-widgets-number]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Number Of Sidebars ( section column ) In Top Footer Area', 'supermag' ),
    'section'   => 'supermag-footer-option',
    'settings'  => 'supermag_theme_options[supermag-footer-top-widgets-number]',
    'type'	  	=> 'select',
    'priority'  => 20
) );

/*footer bottom widget number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-bottom-widgets-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-bottom-widgets-number'],
    'sanitize_callback' => 'wp_kses_post'
) );
$choices = supermag_footer_bottom_sidebar_number();
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-bottom-widgets-number]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Number Of Sidebars ( section column ) In Bottom Footer Area', 'supermag' ),
    'section'   => 'supermag-footer-option',
    'settings'  => 'supermag_theme_options[supermag-footer-bottom-widgets-number]',
    'type'	  	=> 'select',
    'priority'  => 30
) );

/*footer got to top enable-disable */
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-gotop]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-gotop'],
    'sanitize_callback' => 'wp_kses_post'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-gotop]', array(
    'label'		=> __( 'Enable go to top', 'supermag' ),
    'section'   => 'supermag-footer-option',
    'settings'  => 'supermag_theme_options[supermag-footer-gotop]',
    'type'	  	=> 'checkbox',
    'priority'  => 40
) );

/*footer got to top enable-disable */
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-power-text]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-power-text'],
    'sanitize_callback' => 'wp_kses_post'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-power-text]', array(
    'label'		=> __( ' Enable Theme Name And Powered By Text ', 'supermag' ),
    'section'   => 'supermag-footer-option',
    'settings'  => 'supermag_theme_options[supermag-footer-power-text]',
    'type'	  	=> 'checkbox',
    'priority'  => 40
) );

/*footer copyright*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-footer-site-info]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-footer-site-info'],
    'sanitize_callback' => 'wp_kses_post',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-footer-site-info]', array(
    'label'		    => __( 'Your Own Powered By Text', 'supermag' ),
    'description'   => __( 'First enable Theme Name And Powered By Text above', 'supermag' ),
    'section'       => 'supermag-footer-option',
    'settings'      => 'supermag_theme_options[supermag-footer-site-info]',
    'type'	  	    => 'text',
    'priority'      => 70
) );