<?php
/*active callback function for breaking news*/
if ( !function_exists('supermag_active_callback_breaking_news_from_cat') ) :
    function supermag_active_callback_breaking_news_from_cat() {
        $supermag_customizer_all_values = supermag_get_theme_options();
        if( 'from-category' == $supermag_customizer_all_values['supermag-breaking-news-selection-from'] ){
            return true;
        }
        return false;
    }
endif;

/*adding sections for header options panel*/
$wp_customize->add_section( 'supermag-header-news', array(
    'priority'       => 20,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Breaking News Options', 'supermag' ),
    'panel'          => 'supermag-header-panel'
) );

/*Breaking news options options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-options]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-options'],
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_breaking_news_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-options]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Breaking News Options', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-options]',
    'type'	  	=> 'select',
    'priority'  => 10
) );

/*Breaking News Selection From*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-selection-from]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-selection-from'],
    'sanitize_callback' => 'supermag_sanitize_select',
) );
$choices = supermag_breaking_news_selection_from();
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-selection-from]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Breaking News Selection From', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-selection-from]',
    'type'	  	=> 'select',
    'priority'  => 15
) );

/*Breaking News Cat*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-from-category]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-from-category'],
    'sanitize_callback' => 'supermag_sanitize_number'
) );

$wp_customize->add_control(
    new Supermag_Customize_Category_Dropdown_Control(
        $wp_customize,
        'supermag_theme_options[supermag-breaking-news-from-category]',
        array(
            'label'		=> __( 'Select Category', 'supermag' ),
            'section'   => 'supermag-header-news',
            'settings'  => 'supermag_theme_options[supermag-breaking-news-from-category]',
            'type'	  	=> 'category_dropdown',
            'priority'  => 18,
            'active_callback' => 'supermag_active_callback_breaking_news_from_cat'
        )
    )
);

/*header news title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-title'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-title]', array(
    'label'		=> __( 'Breaking News Title', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-title]',
    'type'	  	=> 'text',
    'priority'  => 19
) );

/*header breaking news number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-speed]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-speed'],
    'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-speed]', array(
    'label'		=> __( 'Breaking News Speed', 'supermag' ),
    'description'=> __( 'Transition duration (in ms)', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-speed]',
    'type'	  	=> 'number',
    'priority'  => 20
) );

/*header breaking news number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-number'],
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-number]', array(
    'label'		=> __( 'Breaking News Number', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-number]',
    'type'	  	=> 'number',
    'priority'  => 25
) );

/*header breaking news per slide*/
$choices = supermag_breaking_news_per_slide();
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-per-slide]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-breaking-news-per-slide'],
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-per-slide]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Breaking News Per Slide', 'supermag' ),
    'description'=> __( 'If Breaking News from Slide', 'supermag' ),
    'section'   => 'supermag-header-news',
    'settings'  => 'supermag_theme_options[supermag-breaking-news-per-slide]',
    'type'	  	=> 'select',
    'priority'  => 30
) );

/*header breaking news below Menu*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-breaking-news-below-menu]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-breaking-news-below-menu'],
	'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-breaking-news-below-menu]', array(
	'label'		=> __( 'Show Breaking News Below Menu', 'supermag' ),
	'section'   => 'supermag-header-news',
	'settings'  => 'supermag_theme_options[supermag-breaking-news-below-menu]',
	'type'	  	=> 'checkbox',
	'priority'  => 40
) );