<?php
/**
 * Returns Supermag and AcmeThemes important links
 *
 * @since SuperMag 1.0.0
 */
if ( ! function_exists( 'supermag_important_links' ) ) :
    function supermag_important_links(){
        $important_links = array(
            'theme_docs' => array(
                'link'	=> esc_url( 'http://www.doc.acmethemes.com/supermagpro' ),
                'text' 	=> __( 'Theme Documentation', 'supermag' )
            ),
            'theme_demo' => array(
                'link'	=> esc_url( 'http://www.demo.acmethemes.com/supermagpro' ),
                'text' 	=> __( 'Theme Demo', 'supermag' )
            ),
            'theme_author' => array(
                'link'	=> esc_url( 'http://www.acmethemes.com/' ),
                'text' 	=> __( 'Theme Author', 'supermag' )
            ),
            'support' => array(
                'link'	=> esc_url( 'http://www.acmethemes.com/supports/forum/supermagpro/' ),
                'text' 	=> __( 'Support Forum', 'supermag' )
            ),
            'facebook' => array(
                'link'	=> esc_url( 'https://www.facebook.com/1653267951605720/' ),
                'text' 	=> __( 'Facebook', 'supermag' )
            ),
            'twitter' => array(
                'link'	=> esc_url( 'https://twitter.com/acme_themes' ),
                'text' 	=> __( 'Twitter', 'supermag' )
            ),
            'linkedin' => array(
                'link'	=> esc_url( 'https://www.linkedin.com/in/acmethemes' ),
                'text' 	=> __( 'Linkedin', 'supermag' )
            )
        );
        $important_links_text = '';
        foreach ( $important_links as $important_link) {
            $important_links_text .= '<p><a target="_blank" href="' . $important_link['link'] .'" >' . esc_attr( $important_link['text'] ) .' </a></p>';
        }
        return $important_links_text;
    }
endif;

/*adding theme options panel*/
$wp_customize->add_section( 'supermag-imp-links', array(
    'priority'       => 300,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Important Links', 'supermag' )
) );

/*front  supermag supermag-side-show-message*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-side-show-message]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-side-show-message'],
    'sanitize_callback' => 'esc_attr'
) );
$wp_customize->add_control(
    new Supermag_Customize_Message_Control(
        $wp_customize,
        'supermag_theme_options[supermag-side-show-message]',
        array(
            'section'       => 'supermag-imp-links',
            'settings'      => 'supermag_theme_options[supermag-side-show-message]',
            'type'	  	    => 'message',
            'priority'      => 10,
            'description'   => supermag_important_links()
        )
    )
);