<?php
/*adding sections for header options panel*/
$option_media = "<a href='".esc_url( admin_url( 'options-media.php' ) )."' target='_blank'>";
$acme_fix_images = "<a href='".esc_url( admin_url( 'themes.php?page=acme-fix-images-setting' ) )."' target='_blank'>";
$wp_customize->add_section( 'supermag-no-images', array(
    'priority'       => 100,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Custom No Images', 'supermag' ),
    'description'    => sprintf( __( 'Recommended Images sizes: Thumbnail : 500*280, Medium : 660*365, Large : 840*480 and Post-Thumbnail : 240*172.
    You can also setup for different images size %1$s here %2$s. Please use %3$s Acme Fix Images %4$s after changing image size. When you download and activate that plugin, you can Fix All Thumbnails from %5$s
     here %6$s. Note : If you remove these images default images will be used.
    ', 'supermag' ), $option_media,'</a>', "<a href='https://wordpress.org/support/plugin/acme-fix-images' target='_blank'>",'</a>',$acme_fix_images,'</a>'),
    'panel'          => 'supermag-options',
) );


/*No Image For Thumbnail*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-no-image-thumbnail]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-no-image-thumbnail'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-no-image-thumbnail]',
        array(
            'label'		    => __( 'No Image For Thumbnail', 'supermag' ),
            'description'   => __( 'Recommended Images size 500*280', 'supermag' ),
            'section'       => 'supermag-no-images',
            'settings'      => 'supermag_theme_options[supermag-no-image-thumbnail]',
            'type'	  	    => 'image',
            'priority'      => 10
        )
    )
);

/*No Image For Medium*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-no-image-medium]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-no-image-medium'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-no-image-medium]',
        array(
            'label'		    => __( 'No Image For Medium', 'supermag' ),
            'description'   => __( 'Recommended Images size 660*365', 'supermag' ),
            'section'       => 'supermag-no-images',
            'settings'      => 'supermag_theme_options[supermag-no-image-medium]',
            'type'	  	    => 'image',
            'priority'      => 10
        )
    )
);

/*No Image For Large*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-no-image-large]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-no-image-large'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-no-image-large]',
        array(
            'label'		    => __( 'No Image For Large', 'supermag' ),
            'description'   => __( 'Recommended Images size 840*480', 'supermag' ),
            'section'       => 'supermag-no-images',
            'settings'      => 'supermag_theme_options[supermag-no-image-large]',
            'type'	  	    => 'image',
            'priority'      => 10
        )
    )
);

/*No Image For Large*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-no-image-post-thumb]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-no-image-post-thumb'],
    'sanitize_callback' => 'esc_url_raw'
) );
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'supermag_theme_options[supermag-no-image-post-thumb]',
        array(
            'label'		=> __( 'No Image For Post Thumbnail', 'supermag' ),
            'description'=> __( 'Recommended Images size 240*172', 'supermag' ),
            'section'   => 'supermag-no-images',
            'settings'  => 'supermag_theme_options[supermag-no-image-post-thumb]',
            'type'	  	=> 'image',
            'priority'  => 10
        )
    )
);