<?php
/**
 * reset options
 * @param  array $reset_options
 * @return void
 *
 * @since SuperMag 1.0
 */
if ( ! function_exists( 'supermag_reset_db_options' ) ) :
    function supermag_reset_db_options( $reset_options ) {
        set_theme_mod( 'supermag_theme_options', $reset_options );
    }
endif;

function supermag_reset_db_setting( ){
	$supermag_customizer_all_values = supermag_get_theme_options();
	$input = $supermag_customizer_all_values['supermag-reset-options'];
	if( '0' == $input ){
		return;
	}

    $supermag_default_theme_options = supermag_get_default_theme_options();
    $supermag_get_theme_options = get_theme_mod( 'supermag_theme_options');

    $supermag_get_theme_options['supermag-reset-options'] = $supermag_default_theme_options['supermag-reset-options'];

    switch ( $input ) {
        case "reset-color-options":
            $supermag_get_theme_options['supermag-site-title-color'] = $supermag_default_theme_options['supermag-site-title-color'];
            $supermag_get_theme_options['supermag-site-title-hover-color'] = $supermag_default_theme_options['supermag-site-title-hover-color'];
            $supermag_get_theme_options['supermag-site-tagline-color'] = $supermag_default_theme_options['supermag-site-tagline-color'];
            $supermag_get_theme_options['supermag-body-text-color'] = $supermag_default_theme_options['supermag-body-text-color'];
            $supermag_get_theme_options['supermag-heading-color'] = $supermag_default_theme_options['supermag-heading-color'];
            $supermag_get_theme_options['supermag-primary-color'] = $supermag_default_theme_options['supermag-primary-color'];
            $supermag_get_theme_options['supermag-primary-hover-color'] = $supermag_default_theme_options['supermag-primary-hover-color'];
            $supermag_get_theme_options['supermag-link-color'] = $supermag_default_theme_options['supermag-primary-hover-color'];
            $supermag_get_theme_options['supermag-link-hover-color'] = $supermag_default_theme_options['supermag-link-hover-color'];
            $supermag_get_theme_options['supermag-header-top-bg-color'] = $supermag_default_theme_options['supermag-header-top-bg-color'];
            $supermag_get_theme_options['supermag-header-main-bg-color'] = $supermag_default_theme_options['supermag-header-main-bg-color'];
            $supermag_get_theme_options['supermag-menu-main-bg-color'] = $supermag_default_theme_options['supermag-menu-main-bg-color'];
            $supermag_get_theme_options['supermag-menu-active-bg-color'] = $supermag_default_theme_options['supermag-menu-active-bg-color'];
            $supermag_get_theme_options['supermag-menu-hover-bg-color'] = $supermag_default_theme_options['supermag-menu-hover-bg-color'];
            $supermag_get_theme_options['supermag-menu-text-color'] = $supermag_default_theme_options['supermag-menu-text-color'];
            $supermag_get_theme_options['supermag-menu-border-bottom-color'] = $supermag_default_theme_options['supermag-menu-border-bottom-color'];
            $supermag_get_theme_options['supermag-footer-bg-color'] = $supermag_default_theme_options['supermag-footer-bg-color'];
            $supermag_get_theme_options['supermag-footer-heading-color'] = $supermag_default_theme_options['supermag-footer-heading-color'];
            $supermag_get_theme_options['supermag-footer-text-color'] = $supermag_default_theme_options['supermag-footer-text-color'];
            $supermag_get_theme_options['supermag-footer-link-color'] = $supermag_default_theme_options['supermag-footer-link-color'];
            $supermag_get_theme_options['supermag-footer-link-hover-color'] = $supermag_default_theme_options['supermag-footer-link-hover-color'];

            supermag_reset_db_options($supermag_get_theme_options);
            break;
        case "reset-font-options":
            $supermag_get_theme_options['supermag-site-title-fm'] = $supermag_default_theme_options['supermag-site-title-fm'];
            $supermag_get_theme_options['supermag-site-tagline-fm'] = $supermag_default_theme_options['supermag-site-tagline-fm'];
            $supermag_get_theme_options['supermag-menu-fm'] = $supermag_default_theme_options['supermag-menu-fm'];
            $supermag_get_theme_options['supermag-heading-fm'] = $supermag_default_theme_options['supermag-heading-fm'];
            $supermag_get_theme_options['supermag-body-fm'] = $supermag_default_theme_options['supermag-body-fm'];
            supermag_reset_db_options($supermag_get_theme_options);
            break;
        case "reset-all":
            supermag_reset_db_options($supermag_default_theme_options);
            break;
        default:
            break;
    }
}
add_action( 'customize_save_after','supermag_reset_db_setting' );

/*adding sections for Reset Options*/
$wp_customize->add_section( 'supermag-reset-options', array(
    'priority'       => 220,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Reset Options', 'supermag' ),
    'description'    => __( "Category color options won't reset", 'supermag' )
) );

/*Reset Options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-reset-options]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-reset-options'],
    'transport'			=> 'postMessage',
    'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_reset_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-reset-options]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Reset Options', 'supermag' ),
    'description'=> __( 'Caution: Reset theme settings according to the given options. Refresh the page after saving to view the effects. ', 'supermag' ),
    'section'   => 'supermag-reset-options',
    'settings'  => 'supermag_theme_options[supermag-reset-options]',
    'type'	  	=> 'select'
) );