<?php
/*callback functions*/
if( !function_exists('supermag_below_related_posts')):
    function supermag_below_related_posts(){
        $supermag_customizer_all_values = supermag_get_theme_options();
        $layout = $supermag_customizer_all_values['supermag-related-posts-display'];
        if('below-related-posts' == $layout){
            return true;
        }
        else{
            return false;
        }
    }
endif;

/*adding sections for header options panel*/
$wp_customize->add_section( 'supermag-related-posts', array(
    'priority'       => 10,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Single Post Related Post Options', 'supermag' ),
    'description'    => __( 'Note : Each of the following options can be override in a single post.', 'supermag' ),
    'panel'          => 'supermag-single-post'
) );

/*Related posts display options*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-display]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-display'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$choices = supermag_related_posts_display_options();
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-display]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Related Posts Display Options', 'supermag' ),
    'section'   => 'supermag-related-posts',
    'settings'  => 'supermag_theme_options[supermag-related-posts-display]',
    'type'	  	=> 'select',
    'priority'  => 10
) );

/*related post by tag or category*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-post-display-from]', array(
	'capability'		=> 'edit_theme_options',
	'default'			=> $defaults['supermag-related-post-display-from'],
	'sanitize_callback' => 'supermag_sanitize_select'
) );
$choices = supermag_related_post_display_from();
$wp_customize->add_control( 'supermag_theme_options[supermag-related-post-display-from]', array(
	'choices'  	=> $choices,
	'label'		=> __( 'Related Post Display From Options', 'supermag' ),
	'section'   => 'supermag-related-posts',
	'settings'  => 'supermag_theme_options[supermag-related-post-display-from]',
	'type'	  	=> 'select',
	'priority'  => 15
) );

/*Related title*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-title]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-title'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-title]', array(
    'label'		=> __( 'Related Posts title', 'supermag' ),
    'section'   => 'supermag-related-posts',
    'settings'  => 'supermag_theme_options[supermag-related-title]',
    'type'	  	=> 'text',
    'priority'  => 20
) );

/*message*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-message]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-message'],
    'sanitize_callback' => 'esc_attr'
) );
$wp_customize->add_control(
    new Supermag_Customize_Message_Control(
        $wp_customize,
        'supermag_theme_options[supermag-related-posts-message]',
        array(
            'description'   => $defaults['supermag-related-posts-message'],
            'section'   => 'supermag-related-posts',
            'settings'  => 'supermag_theme_options[supermag-related-posts-message]',
            'type'	  	=> 'message',
            'active_callback'=> 'supermag_below_related_posts',
            'priority'  => 25
        )
    )
);

/*Select number of columns */
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-column-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-column-number'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$choices = supermag_related_posts_layout();
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-column-number]', array(
    'choices'  	=> $choices,
    'label'		=> __( 'Select Number Of Columns ', 'supermag' ),
    'section'   => 'supermag-related-posts',
    'settings'  => 'supermag_theme_options[supermag-related-posts-column-number]',
    'type'	  	=> 'select',
    'active_callback'=> 'supermag_below_related_posts',
    'priority'  => 30
) );

/*Related posts layout show image*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-show-image]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-show-image'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-show-image]', array(
    'label'		        => __( 'Show Image', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-show-image]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 40
) );

/*Related posts first featured*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-first-featured]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-first-featured'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-first-featured]', array(
    'label'		        => __( ' Enable First Post Featured ', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-first-featured]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 50
) );

/*Related posts show categories*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-show-categories]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-show-categories'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-show-categories]', array(
    'label'		        => __( 'Show Categories', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-show-categories]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 60
) );

/*Related posts show date*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-show-date]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-show-date'],
    'sanitize_callback' => 'supermag_sanitize_checkbox'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-show-date]', array(
    'label'		        => __( 'Show Date', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-show-date]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 70
) );

/*Related posts show author*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-show-author]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-show-author'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-show-author]', array(
    'label'		        => __( 'Show Author', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-show-author]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 80
) );

/*Show number of comments */
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-show-comments]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-show-comments'],
    'sanitize_callback' => 'supermag_sanitize_checkbox',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-show-comments]', array(
    'label'		        => __( 'Show Number Of Comments ', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-show-comments]',
    'type'	  	        => 'checkbox',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 80
) );

/*Related posts number*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-number]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-number'],/*3*/
    'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-number]', array(
    'label'		        => __( 'Number of posts to show', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-number]',
    'type'	  	        => 'number',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 100
) );

/*Related posts words count*/
$wp_customize->add_setting( 'supermag_theme_options[supermag-related-posts-content-words]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['supermag-related-posts-content-words'],/*9*/
    'sanitize_callback' => 'absint'
) );
$wp_customize->add_control( 'supermag_theme_options[supermag-related-posts-content-words]', array(
    'label'		        => __( 'Number of words in contents', 'supermag' ),
    'section'           => 'supermag-related-posts',
    'settings'          => 'supermag_theme_options[supermag-related-posts-content-words]',
    'type'	  	        => 'number',
    'active_callback'   => 'supermag_below_related_posts',
    'priority'          => 100
) );