<?php
/**
 * Blog thumb size
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_blog_image_size') ) :
    function supermag_blog_image_size() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_no_image_thumbnail = $supermag_customizer_all_values['supermag-no-image-thumbnail'];
        $supermag_no_image_medium = $supermag_customizer_all_values['supermag-no-image-medium'];
        $supermag_no_image_large = $supermag_customizer_all_values['supermag-no-image-large'];

        if ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'no-image') {
            $blog_thumb_size = 'no-image';
            $blog_no_image ='';
        }
        elseif ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'large-image') {
            $blog_thumb_size = 'large';
            $blog_no_image = $supermag_no_image_large;
        }
        elseif ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'alternate-image') {
            $blog_thumb_size = 'medium';
            $blog_no_image = $supermag_no_image_medium;
        }
        else {
            $blog_thumb_size = 'thumbnail';
            $blog_no_image = $supermag_no_image_thumbnail;
        }
        $blog_thumbnails = array(
            'thumb_size' => $blog_thumb_size,
            'no_image' => $blog_no_image,
        );
        return $blog_thumbnails;
    }
endif;

/**
 * Blog content
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( !function_exists('supermag_shorter_excerpt') ):
    function supermag_shorter_excerpt() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_blog_archive_content_length = $supermag_customizer_all_values['supermag-blog-archive-content-length'];
        return absint( $supermag_blog_archive_content_length );

    }
endif;

if ( !function_exists('supermag_blog_content_layout') ) :
    function supermag_blog_content_layout() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_blog_archive_content_length = $supermag_customizer_all_values['supermag-blog-archive-content-length'];
        $supermag_blog_archive_content_layout = $supermag_customizer_all_values['supermag-blog-archive-content-layout'];
        if( $supermag_blog_archive_content_length <= 0 ){
            return '';
        }
        if( 'content' == $supermag_blog_archive_content_layout ){
            the_content();
        }
        else{
            add_filter( 'excerpt_length', 'supermag_shorter_excerpt');
            the_excerpt();
            remove_filter( 'excerpt_length', 'supermag_shorter_excerpt');
        }
    }
endif;

/**
 * More Text
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return string
 *
 */
if ( !function_exists('supermag_blog_archive_more_text') ) :
    function supermag_blog_archive_more_text( ) {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_blog_archive_read_more = $supermag_customizer_all_values['supermag-blog-archive-more-text'];
        $supermag_blog_archive_read_more = esc_html( $supermag_blog_archive_read_more );
        return $supermag_blog_archive_read_more;
    }
endif;

/**
 * Feature Image Display
 *
 * @since SuperMag 1.0.3
 *
 * @param null
 * @return string
 *
 */
if ( !function_exists('supermag_featured_image_display') ) :
    function supermag_featured_image_display( $post_id ) {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_single_post_layout = $supermag_customizer_all_values['supermag-single-post-layout'];
        $supermag_featured_image_display_option_meta = get_post_meta( $post_id, 'supermag_featured_image_display_option', true );
        if( !empty ( $supermag_featured_image_display_option_meta ) &&
            'default-featured-image' != $supermag_featured_image_display_option_meta ){
            $supermag_single_post_layout = $supermag_featured_image_display_option_meta;
        }
        return $supermag_single_post_layout;
    }
endif;