<?php
/**
 * Breadcrumbs Setting
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if( ! function_exists( 'supermag_breadcrumbs' ) ):
	function supermag_breadcrumbs() {
		if ( ! function_exists( 'breadcrumb_trail' ) ) {
			require supermag_file_directory('acmethemes/library/breadcrumbs/breadcrumbs.php');
		}
		$breadcrumb_args = array(
			'container'   => 'div',
			'show_browse' => false
		);

		$supermag_customizer_all_values = supermag_get_theme_options();

		$supermag_you_are_here_text = $supermag_customizer_all_values['supermag-you-are-here-text'];
		if( !empty( $supermag_you_are_here_text ) ){
			$supermag_you_are_here_text = "<span class='breadcrumb'>".$supermag_you_are_here_text."</span>";
		}

		echo "<div id='vayanewsbreadcrumbs' class='breadcrumbs init-animate clearfix'>".$supermag_you_are_here_text."<div id='supermag-breadcrumbs' class='clearfix'>";
		breadcrumb_trail( $breadcrumb_args );
		echo "</div></div>";
	}
endif;
