<?php
/**
 * Breaking News
 *
 * @since SuperMag 1.3.1
 *
 * @param null
 * @return void
 *
 */
if( ! function_exists( 'supermag_fe_breking_news' ) ):
	function supermag_fe_breking_news() {
		$supermag_customizer_all_values = supermag_get_theme_options();
		$supermag_breaking_news_options = $supermag_customizer_all_values['supermag-breaking-news-options'];

		if ( 'disable' != $supermag_breaking_news_options ) {

			$supermag_number_bn = $supermag_customizer_all_values['supermag-breaking-news-number'];
			$supermag_breaking_news_selection_from = $supermag_customizer_all_values['supermag-breaking-news-selection-from'];
			if( 'from-category' == $supermag_breaking_news_selection_from ){
				$supermag_breaking_news_category = $supermag_customizer_all_values['supermag-breaking-news-from-category'];
				if( 0 != $supermag_breaking_news_category ){
					$supermag_bn_args =    array(
						'category' => $supermag_breaking_news_category,
						'posts_per_page' => $supermag_number_bn
					);
				}
				else{
					$supermag_bn_args = array(
						'post_status' => 'publish',
						'posts_per_page' => $supermag_number_bn
					);
				}
			}
			else{
				$supermag_bn_args = array(
					'post_status' => 'publish',
					'posts_per_page' => $supermag_number_bn
				);
			}
			if( is_single( )){
				$supermag_bn_args['exclude'] = get_the_ID();
            }

			$recent_posts = wp_get_recent_posts($supermag_bn_args);
			if ( !empty( $recent_posts ) ):
				if ( !empty( $supermag_customizer_all_values['supermag-breaking-news-title'] ) ){
					$bn_title = $supermag_customizer_all_values['supermag-breaking-news-title'];
				}
				else{
					$bn_title = __( 'Recent posts', 'supermag' );
				}
				$supermag_breaking_news_speed = $supermag_customizer_all_values['supermag-breaking-news-speed'];
				$supermag_breaking_news_per_slide = $supermag_customizer_all_values['supermag-breaking-news-per-slide'];

				$ul_class = 'bn';
				if( 'slide' ==  $supermag_breaking_news_options ) {
					$ul_class = 'duper-bn';
				}
				?>
				<div class="header-latest-posts bn-wrapper float-left">
					<div class="bn-title">
						<?php echo esc_html( $bn_title ); ?>
					</div>
					<ul class="<?php echo $ul_class; ?>" data-speed="<?php echo absint( $supermag_breaking_news_speed ); ?>" data-mode="horizontal" data-column="<?php echo absint( $supermag_breaking_news_per_slide );?>">
						<?php foreach ($recent_posts as $recent): ?>
							<li class="bn-content">
								<a href="<?php echo esc_url( get_permalink($recent["ID"]) ); ?>" title="<?php echo esc_attr( $recent['post_title'] ); ?>">
									<?php echo esc_html( $recent['post_title'] ); ?>
								</a>
							</li>
						<?php endforeach; ?>
					</ul>
				</div> <!-- .header-latest-posts -->
			<?php
			endif;
		}
	}
endif;