<?php
/**
 * Column clearfix function
 *
 * @since SuperMag 1.0.0
 *
 * @param int $supermag_column_number
 * @param int $supermag_featured_index
 * @param int $supermag_enable_first_featured

 * @return void
 *
 */
if ( !function_exists('supermag_col_clearfix') ) :

    function supermag_col_clearfix( $supermag_column_number, $supermag_featured_index, $supermag_enable_first_featured = 0 ) {
        if( 1 == $supermag_enable_first_featured ){
            $supermag_remainder_clear = 1;
        }
        else{
            $supermag_remainder_clear = 0;
        }
        /*visible css*/
        $clearfix = '';
        $visible_min_992 = '';
        $visible_in_992_641 = '';
        $visible_in_641_481 = '';
        $visible_max_481 = "<div class='clearfix visible-max-481'></div>";

        if( 1 == $supermag_column_number && $supermag_featured_index % 1 == $supermag_remainder_clear ){
            $clearfix = "<div class='clearfix'></div>";
        }
        elseif( 2 == $supermag_column_number ){
            if( $supermag_featured_index % 2 == $supermag_remainder_clear ){
                $visible_min_992 = "<div class='clearfix visible-min-992'></div>";
            }
        }
        elseif( 3 == $supermag_column_number ){
            if( $supermag_featured_index % 3 == $supermag_remainder_clear ){
                $visible_min_992 = "<div class='clearfix visible-min-992'></div>";
            }
            if( $supermag_featured_index % 2 == $supermag_remainder_clear ){
                $visible_in_641_481 = "<div class='clearfix visible-in-641-481'></div>";
            }
        }
        elseif( 4 == $supermag_column_number ){
            if( $supermag_featured_index % 4 == $supermag_remainder_clear ){
                $visible_min_992 = "<div class='clearfix visible-min-992'></div>";
            }
            if( $supermag_featured_index % 2 == $supermag_remainder_clear ){
                $visible_in_641_481 = "<div class='clearfix visible-in-641-481'></div>";
            }
        }

        else{
            /*do nothing*/
        }
        $supermag_col_clearfix = $clearfix.$visible_min_992.$visible_in_992_641.$visible_in_641_481.$visible_max_481;
        return $supermag_col_clearfix;
    }
endif;