<?php
/**
 * Previous Post ID
 *
 * @since SuperMag 1.0.0
 *
 * @param int $post_id
 * @return int previous_post id
 *
 */
if ( !function_exists('supermag_get_previous_post_id') ) :

    function supermag_get_previous_post_id( $post_id ) {
        /*Get a global post reference since get_adjacent_post() references it*/
        global $post;

        /*Store the existing post object for later so we don't lose it*/
        $oldGlobal = $post;

        /*Get the post object for the specified post and place it in the global variable*/
        $post = get_post( $post_id );

        /*Get the post object for the previous post*/
        $previous_post = get_previous_post();

        /*Reset our global object*/
        $post = $oldGlobal;

        if ( '' == $previous_post )
            return 0;

        return $previous_post->ID;
    }
endif;

/**
 * Next Post ID
 *
 * @since SuperMag 1.0.0
 *
 * @param int $post_id
 * @return int next_post id
 *
 */
if ( !function_exists('supermag_get_next_post_id') ) :

    function supermag_get_next_post_id( $post_id ) {
        /*Get a global post reference since get_adjacent_post() references it*/
        global $post;

        /*Store the existing post object for later so we don't lose it*/
        $oldGlobal = $post;

        /*Get the post object for the specified post and place it in the global variable*/
        $post = get_post( $post_id );

        /*Get the post object for the previous post*/
        $next_post = get_next_post();

        /*Reset our global object*/
        $post = $oldGlobal;

        if ( '' == $next_post )
            return 0;

        return $next_post->ID;
    }
endif;

/**
 * Navigation function
 *
 * @since SuperMag 1.0.0
 *
 * @param int $post_id
 * @param string $type
 * @return int next_post id
 *
 */
if ( !function_exists('supermag_single_navigation') ) :

    function supermag_single_navigation( $post_id, $type = 'default' ){
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_no_image_post_thumb = $supermag_customizer_all_values['supermag-no-image-post-thumb'];

        $previous_post_id = supermag_get_previous_post_id( $post_id );
        $next_post_id = supermag_get_next_post_id( $post_id );
        if ( has_post_thumbnail( $previous_post_id ) ):
            $post_thumb_previous = wp_get_attachment_image_src(get_post_thumbnail_id( $previous_post_id ), 'post-thumbnail');
        else:
            $post_thumb_previous[0] = $supermag_no_image_post_thumb;
        endif;

        if ( has_post_thumbnail( $next_post_id ) ):
            $post_thumb_next = wp_get_attachment_image_src(get_post_thumbnail_id( $next_post_id ), 'post-thumbnail');
        else:
            $post_thumb_next[0] = $supermag_no_image_post_thumb;
        endif;

        $navigation = '';
        if( 'title-image' ==  $type ){
            $previous   = get_previous_post_link( '<div class="nav-previous title-image">%link</div>', '<figure class="widget-image"><img src="'.$post_thumb_previous[0].'"></figure>'.get_the_title( $previous_post_id ).'', false );
            $next       = get_next_post_link( '<div class="nav-next title-image">%link</div>', '<figure class="widget-image"><img src="'.$post_thumb_next[0].'"></figure>'.get_the_title( $next_post_id ).'', false );
        }
        else{
            $previous   = get_previous_post_link( '<div class="nav-previous image-only">%link</div>', '<figure class="widget-image"><img src="'.$post_thumb_previous[0].'"></figure>', false );
            $next       = get_next_post_link( '<div class="nav-next image-only">%link</div>', '<figure class="widget-image"><img src="'.$post_thumb_next[0].'"></figure>', false );
        }

       /*Only add markup if there's somewhere to navigate to.*/
        if ( $previous || $next ) {
            $navigation = _navigation_markup( $previous . $next, 'post-navigation' );
        }
        echo $navigation;
    }
endif;