<?php
/**
 * Setting post views in meta
 *
 * @since SuperMag 1.0.0
 *
 * @param int $postID
 * @return void
 *
 */
if ( !function_exists('supermag_set_post_views') ) :

    function supermag_set_post_views( $postID ) {
        $count_key = 'supermag_post_views_count';
        $count = get_post_meta( $postID, $count_key, true);
        if($count==''){
            $count = 0;
            delete_post_meta( $postID, $count_key );
            add_post_meta( $postID, $count_key, '0' );
        }
        else{
            $count++;
            update_post_meta( $postID, $count_key, $count );
        }
    }
endif;

/**
 * Track post views
 * To keep the count accurate, lets get rid of prefetching
 * remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
 *
 * @since SuperMag 1.0.0
 *
 * @param int $postID
 * @return void
 *
 */
if ( !function_exists('supermag_track_post_views') ) :

    function supermag_track_post_views ($post_id) {
        if ( !is_singular() ) return;
        if ( empty ( $post_id) ) {
            global $post;
            $post_id = $post->ID;
        }
        supermag_set_post_views($post_id);
    }
endif;
add_action( 'wp_head', 'supermag_track_post_views');

/**
 * Getting post views from meta
 *
 * @since SuperMag 1.0.0
 *
 * @param int $postID
 * @return int count
 *
 */
if ( !function_exists('supermag_get_post_views') ) :

    function supermag_get_post_views( $postID ) {
        $count_key = 'supermag_post_views_count';
        $count = get_post_meta( $postID, $count_key, true);
        if ( $count == '' ) {
            return 1;
        }
        else {
            return $count;
        }
    }
endif;