<?php
/**
 * Related posts data
 *
 * @since SuperMag 1.0.0
 *
 * @param int $post_id
 * @return array $supermag_related_posts_data
 *
 */
if ( !function_exists('supermag_related_posts_data') ) :

    function supermag_related_posts_data ( $post_id = null ) {

        $supermag_customizer_all_values = supermag_get_theme_options();

        $supermag_related_posts_display = 'default-related-posts';
        $supermag_related_title = esc_html( $supermag_customizer_all_values['supermag-related-title'] );
        $supermag_related_posts_column_number = absint( $supermag_customizer_all_values['supermag-related-posts-column-number'] );

        $supermag_related_posts_show_image = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-image'] );
        $supermag_related_posts_first_featured = esc_attr( $supermag_customizer_all_values['supermag-related-posts-first-featured'] );
        $supermag_related_posts_show_date = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-date'] );
        $supermag_related_posts_show_author = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-author'] );
        $supermag_related_posts_show_comments = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-comments'] );
        $supermag_related_posts_show_categories = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-categories'] );

        $supermag_related_posts_number = absint( $supermag_customizer_all_values['supermag-related-posts-number'] );
        $supermag_related_posts_content_words = absint( $supermag_customizer_all_values['supermag-related-posts-content-words'] );

        /*now meta value*/
        $supermag_related_posts_meta_display = get_post_meta( $post_id, 'supermag-related-posts-display', true );
        if( !supermag_is_null_or_empty($supermag_related_posts_meta_display) ){
            $supermag_related_posts_display = $supermag_related_posts_meta_display;
        }
        if( 'default-related-posts' != $supermag_related_posts_display ){
            /*title*/
            $supermag_related_meta_title = get_post_meta( $post_id, 'supermag-related-title', true );
            if( !supermag_is_null_or_empty($supermag_related_meta_title) ){
                $supermag_related_title = $supermag_related_meta_title;
            }

            /*image*/
            $supermag_related_posts_meta_show_image = get_post_meta( $post_id, 'supermag-related-posts-show-image', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_show_image) ){
                $supermag_related_posts_show_image = $supermag_related_posts_meta_show_image;
            }
            /*first featured*/
            $supermag_related_posts_meta_first_featured = get_post_meta( $post_id, 'supermag-related-posts-first-featured', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_first_featured) ){
                $supermag_related_posts_first_featured = $supermag_related_posts_meta_first_featured;
            }
            /*show date*/
            $supermag_related_posts_meta_show_date = get_post_meta( $post_id, 'supermag-related-posts-show-date', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_show_date) ){
                $supermag_related_posts_show_date = $supermag_related_posts_meta_show_date;
            }
            /*show author*/
            $supermag_related_posts_meta_show_author = get_post_meta( $post_id, 'supermag-related-posts-show-author', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_show_author) ){
                $supermag_related_posts_show_author = $supermag_related_posts_meta_show_author;
            }
            /*show comments*/
            $supermag_related_posts_meta_show_comments = get_post_meta( $post_id, 'supermag-related-posts-show-comments', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_show_comments) ){
                $supermag_related_posts_show_comments = $supermag_related_posts_meta_show_comments;
            }
            /*show categories*/
            $supermag_related_posts_meta_show_categories = get_post_meta( $post_id, 'supermag-related-posts-show-categories', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_show_categories) ){
                $supermag_related_posts_show_categories = $supermag_related_posts_meta_show_categories;
            }
            /*number*/
            $supermag_related_posts_meta_number = get_post_meta( $post_id, 'supermag-related-posts-number', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_number) ){
                $supermag_related_posts_number = $supermag_related_posts_meta_number;
            }
            /*words*/
            $supermag_content_meta_words = get_post_meta( $post_id, 'supermag-related-posts-content-words', true );
            if( !supermag_is_null_or_empty($supermag_content_meta_words) ){
                $supermag_related_posts_content_words = $supermag_content_meta_words;
            }
            /*column number*/
            $supermag_related_posts_meta_column_number = get_post_meta( $post_id, 'supermag-related-posts-column-number', true );
            if( !supermag_is_null_or_empty($supermag_related_posts_meta_column_number) ){
                $supermag_related_posts_column_number = $supermag_related_posts_meta_column_number;
            }
        }
        $supermag_related_posts_data = array(
            'supermag-related-posts-display' => $supermag_related_posts_display,
            'supermag-related-title' => $supermag_related_title,
            'supermag-related-posts-column-number' => $supermag_related_posts_column_number,
            'supermag-related-posts-show-image' => $supermag_related_posts_show_image,
            'supermag-related-posts-first-featured' => $supermag_related_posts_first_featured,
            'supermag-related-posts-show-date' => $supermag_related_posts_show_date,
            'supermag-related-posts-show-author' => $supermag_related_posts_show_author,
            'supermag-related-posts-show-comments' => $supermag_related_posts_show_comments,
            'supermag-related-posts-show-categories' => $supermag_related_posts_show_categories,
            'supermag-related-posts-number' => $supermag_related_posts_number,
            'supermag-related-posts-content-words' => $supermag_related_posts_content_words
        );
        return $supermag_related_posts_data;
    }

endif;

/**
 * Show Related posts below
 *
 * @since SuperMag 1.0.0
 *
 * @param array $supermag_related_posts_data
 * @param int $post_id
 * @return void
 *
 */
if ( !function_exists('supermag_related_post_below') ) :

    function supermag_related_post_below( $supermag_related_posts_data, $post_id ) {
	    $supermag_customizer_all_values = supermag_get_theme_options();

        $supermag_related_title = esc_html( $supermag_related_posts_data['supermag-related-title'] );
        $supermag_related_posts_show_image = esc_attr( $supermag_related_posts_data['supermag-related-posts-show-image'] );
        $supermag_related_posts_first_featured = esc_attr( $supermag_related_posts_data['supermag-related-posts-first-featured'] );
        $supermag_related_posts_show_date = esc_attr( $supermag_related_posts_data['supermag-related-posts-show-date'] );
        $supermag_related_posts_show_author = esc_attr( $supermag_related_posts_data['supermag-related-posts-show-author'] );
        $supermag_related_posts_show_comments = esc_attr( $supermag_related_posts_data['supermag-related-posts-show-comments'] );
        $supermag_related_posts_show_categories = esc_attr( $supermag_related_posts_data['supermag-related-posts-show-categories'] );
        $supermag_related_posts_number = absint( $supermag_related_posts_data['supermag-related-posts-number'] );
        $supermag_related_posts_column_number = absint( $supermag_related_posts_data['supermag-related-posts-column-number'] );
        $supermag_related_posts_content_words = absint( $supermag_related_posts_data['supermag-related-posts-content-words'] );

	    $supermag_related_post_display_from = $supermag_customizer_all_values['supermag-related-post-display-from'];
	    $supermag_cat_post_args = array(
		    'post__not_in' => array($post_id),
		    'post_type' => 'post',
            'posts_per_page'      => $supermag_related_posts_number,
		    'post_status'         => 'publish',
		    'ignore_sticky_posts' => true
	    );
	    if( 'tag' == $supermag_related_post_display_from ){

		    $tags = get_post_meta( $post_id, 'related-posts', true );
		    if ( !$tags ) {
			    $tags = wp_get_post_tags( $post_id, array('fields'=>'ids' ) );
			    $supermag_cat_post_args['tag__in'] = $tags;
		    }
		    else {
			    $supermag_cat_post_args['tag_slug__in'] = explode(',', $tags);
		    }
	    }
	    else{

		    $cats = get_post_meta( $post_id, 'related-posts', true );
		    if ( !$cats ) {
			    $cats = wp_get_post_categories( $post_id, array('fields'=>'ids' ) );
			    $supermag_cat_post_args['category__in'] = $cats;
		    }
		    else {
			    $supermag_cat_post_args['cat'] = $cats;
		    }
	    }
	    $supermag_featured_query = new WP_Query($supermag_cat_post_args);
	    if( $supermag_featured_query->have_posts() ){
	        ?>
            <h2 class="widget-title">
			    <?php echo esc_html( $supermag_related_title ); ?>
            </h2>
            <ul class="featured-entries-col featured-entries featured-acme-col-posts">
			    <?php
			    $supermag_featured_index = 1;
			    if( 1 == $supermag_related_posts_column_number ){
				    $supermag_column = 'acme-col-1';
			    }
                elseif( 2 == $supermag_related_posts_column_number ){
				    $supermag_column = 'acme-col-2';
			    }
                elseif( 3 == $supermag_related_posts_column_number ){
				    $supermag_column = 'acme-col-3';
			    }
                elseif( 4 == $supermag_related_posts_column_number ){
				    $supermag_column = 'acme-col-4';
			    }
			    else{
				    $supermag_column = 'acme-col-3';
			    }

			    while ( $supermag_featured_query->have_posts() ) :$supermag_featured_query->the_post();
				    if( 1 == $supermag_featured_index && 1 == $supermag_related_posts_first_featured ){
					    $supermag_list_classes = $supermag_column.' featured-post-main';
				    }
				    else{
					    $supermag_list_classes = $supermag_column;
				    }
				    ?>
                    <li class="<?php echo esc_attr( $supermag_list_classes ); ?>">
					    <?php if ( 1 == $supermag_related_posts_show_image ) {
						    $thumb = 'large';
						    ?>
                            <figure class="widget-image">
                                <a href="<?php the_permalink(); ?>">
								    <?php
								    if( has_post_thumbnail() ):
									    the_post_thumbnail( $thumb );
								    else:
									    ?>
                                        <div class="no-image-widgets">
										    <?php
										    the_title( sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
										    if( !get_the_title() ){
											    the_date( '', sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
										    }
										    ?>
                                        </div>
									    <?php
								    endif;
								    ?>
                                </a>
                            </figure>
						    <?php
					    }
					    ?>
                        <div class="featured-desc">
						    <?php
						    if( 1 == $supermag_related_posts_show_date || 1 == $supermag_related_posts_show_author || 1 == $supermag_related_posts_show_comments ) { ?>
                                <div class="above-entry-meta">
								    <?php
								    if ( 1 == $supermag_related_posts_show_date ){
									    $archive_year  = get_the_date('Y');
									    $archive_month = get_the_date('m');
									    $archive_day   = get_the_date('d');
									    ?>
                                        <span>
                                            <i class="fa fa-calendar"></i>
                                            <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                <?php echo get_the_date(); ?>
                                            </a>
                                        </span>
									    <?php
								    }
								    if( 1 == $supermag_related_posts_show_author ) { ?>
                                        <span><i class="fa fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
									    <?php
								    }
								    if( 1 == $supermag_related_posts_show_comments ){ ?>
                                        <span><i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?></span>
									    <?php
								    }
								    ?>
                                </div>
							    <?php
						    }
						    ?>
                            <a href="<?php the_permalink()?>">
                                <h4 class="title">
								    <?php the_title(); ?>
                                </h4>
                            </a>
						    <?php
						    if( 0 != $supermag_related_posts_content_words){
							    $content = supermag_words_count( get_the_excerpt(), $supermag_related_posts_content_words);
							    echo '<div class="details">'.$content.'</div>';
						    }
						    if( 1 == $supermag_related_posts_show_categories ){?>
                                <div class="below-entry-meta">
								    <?php supermag_list_category(); ?>
                                </div>
							    <?php
						    }
						    ?>
                        </div>
                    </li>
				    <?php
				    echo supermag_col_clearfix( $supermag_related_posts_column_number, $supermag_featured_index ,$supermag_related_posts_first_featured );
				    $supermag_featured_index++;
			    endwhile;
			    wp_reset_postdata();
			    ?>
            </ul>
            <div class="clearfix"></div>
	        <?php
        }
    }
endif;

/**
 * Related posts main function
 *
 * @since SuperMag 1.0.0
 *
 * @param int $post_id
 * @return void
 *
 */
if ( !function_exists('supermag_related_posts') ) :

    function supermag_related_posts( $post_id ) {
        $supermag_related_posts_data = supermag_related_posts_data( $post_id );
        $supermag_related_posts_display = esc_attr($supermag_related_posts_data['supermag-related-posts-display']);
        $supermag_customizer_all_values = supermag_get_theme_options();
        if( 'default-related-posts' == $supermag_related_posts_display ){
            $supermag_related_posts_display = esc_attr( $supermag_customizer_all_values['supermag-related-posts-display'] );
        }

        if( 'no-related-posts' == $supermag_related_posts_display ){
            return;
        }
        if( 'left-related-posts' == $supermag_related_posts_display || 'right-related-posts' == $supermag_related_posts_display ){
            $categories = get_the_category($post_id);
            if ($categories) {
                $category_ids = array();
                foreach ($categories as $category) {
                    $category_ids[] = $category->term_id;
                }
                $args = array(
                    'category__in' => $category_ids,
                    'post__not_in' => array($post_id),
                    'posts_per_page' => 5,
                    'ignore_sticky_posts' => true
                );
                $related_query = new WP_Query($args);
                if ($related_query->have_posts()) {
                    echo '<ul>';
                    while ($related_query->have_posts()) {
                        $related_query->the_post();
                        ?>
                        <li>
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
                        </li>
                        <?php
                    }
                    echo '</ul>';
                } else {
                    ?>
                    <ul>
                        <li><?php _e('No related post.', 'supermag'); ?></li>
                    </ul>
                    <?php
                }
                wp_reset_postdata();
            }
        }
        else{
            supermag_related_post_below( $supermag_related_posts_data, $post_id );
        }
    }
endif;