<?php
/**
 * Return content of fixed length
 *
 * @since SuperMag 1.0.0
 *
 * @param string $supermag_content
 * @param int $length
 * @return string
 *
 */
if ( ! function_exists( 'supermag_words_count' ) ) :
	function supermag_words_count( $supermag_content = null, $length = 16 ) {
		$length = absint( $length );
		$source_content = preg_replace( '`\[[^\]]*\]`', '', $supermag_content );
		$trimmed_content = wp_trim_words( $source_content, $length, '...' );
		return $trimmed_content;
	}
endif;