<?php
/**
 * Excerpt length
 *
 * @since SuperMag 1.0.0
 *
 * @param int $excerpt_length
 * @return int $excerpt_length
 *
 */
if ( !function_exists('supermag_alter_excerpt') ) :
    function supermag_alter_excerpt( $excerpt_length){
		if( is_admin() ){
			return $excerpt_length;
		}
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_blog_archive_content_length = $supermag_customizer_all_values['supermag-blog-archive-content-length'];

        $excerpt_length = absint( $excerpt_length );

        if ( $supermag_blog_archive_content_length > $excerpt_length ) {
            $excerpt_length = $supermag_blog_archive_content_length;
        }
        return $excerpt_length;
    }
endif;
add_filter('excerpt_length', 'supermag_alter_excerpt');

/**
 * Excerpt more text
 *
 * @since SuperMag 1.0.0
 *
 * @param string $supermag_excerpt_more
 * @return string $supermag_excerpt_more
 *
 */
if ( !function_exists('supermag_excerpt_more') ) :
    function supermag_excerpt_more($supermag_excerpt_more) {
		if( is_admin() ){
			return $supermag_excerpt_more;
		}
        $supermag_excerpt_more = wp_kses_post( $supermag_excerpt_more );

        if ( !empty( $supermag_excerpt_more ) ) {
            $supermag_excerpt_more = '&hellip;';
        }
        return $supermag_excerpt_more;
    }
endif;
add_filter('excerpt_more', 'supermag_excerpt_more');