<?php
/**
 * Exclude category in blog page
 *
 * @since  SuperMag 1.0.0
 *
 * @param null
 * @return int
 */
if( ! function_exists( 'supermag_exclude_category_in_blog_page' ) ) :
    function supermag_exclude_category_in_blog_page( $query ) {

        if( $query->is_main_query() && ( $query->is_home  || is_archive() )  ) {
            $supermag_customizer_all_values = supermag_get_theme_options();
            $exclude_categories = $supermag_customizer_all_values['supermag-exclude-categories'];
            if ( ! empty( $exclude_categories ) ) {
                $cats = explode( ',', $exclude_categories );
                $cats = array_filter( $cats, 'is_numeric' );
                $string_exclude = '';
                if ( ! empty( $cats ) ) {
                    $string_exclude = '-' . implode( ',-', $cats);
                    $query->set( 'cat', $string_exclude );
                }
            }
        }
        return $query;
    }
endif;
add_filter( 'pre_get_posts', 'supermag_exclude_category_in_blog_page' );