<?php
/**
 * Setting global variables for all theme options saved values
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_set_global' ) ) :

    function supermag_set_global() {
        /*Getting saved values start*/
        $supermag_saved_theme_options = supermag_get_theme_options();
        $GLOBALS['supermag_customizer_all_values'] = $supermag_saved_theme_options;
        /*Getting saved values end*/
    }
endif;
add_action( 'supermag_action_before_head', 'supermag_set_global', 0 );

/**
 * Doctype Declaration
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_doctype' ) ) :
    function supermag_doctype() {
        ?><!DOCTYPE html><html <?php language_attributes(); ?>>
        <?php
    }
endif;
add_action( 'supermag_action_before_head', 'supermag_doctype', 10 );

/**
 * Code inside head tags but before wp_head function
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_before_wp_head' ) ) :

    function supermag_before_wp_head() {
        ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="<?php echo esc_url('http://gmpg.org/xfn/11')?>">
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
        <?php
    }
endif;
add_action( 'supermag_action_before_wp_head', 'supermag_before_wp_head', 10 );

/**
 * Add body class
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_body_class' ) ) :

    function supermag_body_class( $supermagbody_classes ) {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        if ( $supermag_customizer_all_values['supermag-default-layout'] == 'boxed') {
            $supermagbody_classes[] = 'boxed-layout';
        }
	    if ( 1 == $supermag_customizer_all_values['supermag-enable-box-shadow'] ) {
		    $supermagbody_classes[] = 'supermag-enable-box-shadow';
	    }

	    if ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'large-image') {
            $supermagbody_classes[] = 'blog-large-image';
        }
        elseif ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'alternate-image') {
            $supermagbody_classes[] = 'blog-alternate-image';
        }
        elseif ( $supermag_customizer_all_values['supermag-blog-archive-image-layout'] == 'no-image') {
            $supermagbody_classes[] = 'blog-no-image';
        }
        $supermagbody_classes[] = supermag_sidebar_selection();
        if( 1 == $supermag_customizer_all_values['supermag-enable-sticky-sidebar'] ){
            $supermagbody_classes[] = 'at-sticky-sidebar';
        }

        /*added*/
        if( is_singular()){
            $supermag_single_post_layout = supermag_featured_image_display( get_the_ID() );
            if ( $supermag_single_post_layout == 'large-image') {
                $supermagbody_classes[] = 'single-large-image';
            }
        }
        if ( 1 == $supermag_customizer_all_values['supermag-disable-image-zoom'] ) {
            $supermagbody_classes[] = 'blog-disable-image-zoom';
        }
        
        $supermag_header_logo_menu_display_position = $supermag_customizer_all_values['supermag-header-logo-ads-display-position'];
        $supermagbody_classes[] = esc_attr( $supermag_header_logo_menu_display_position );
        
        return $supermagbody_classes;
    }
endif;
add_action( 'body_class', 'supermag_body_class', 10, 1);

/**
 * Intro Loader
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_intro_loader' ) ) :

    function supermag_intro_loader() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_enable_intro_loader = $supermag_customizer_all_values['supermag-enable-intro-loader'];
        if( 1 != $supermag_enable_intro_loader ){
            return;
        }
        $supermag_intro_image =  $supermag_customizer_all_values['supermag-intro-image'];
        $supermag_intro_bg_image = $supermag_customizer_all_values['supermag-intro-bg-color'];
        ?>
        <div id="supermag-intro-loader" style="background: <?php echo esc_url( $supermag_intro_bg_image ); ?>">
            <div id="supermag-mask" class="loader-outer">
                <?php
                if( !empty( $supermag_intro_image ) ){
                    echo "<img src='".esc_url( $supermag_intro_image )."'>";
                }
                else{
                    echo "<div class='at-loader'></div>";
                }
                ?>
            </div>
        </div>
    <?php
}
endif;
add_action( 'supermag_action_before', 'supermag_intro_loader', 10 );

/**
 * Page start
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_page_start' ) ) :

    function supermag_page_start() {
        ?>
        <div id="page" class="hfeed site">
    <?php
    }
endif;
add_action( 'supermag_action_before', 'supermag_page_start', 15 );

/**
 * Skip to content
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_skip_to_content' ) ) :

    function supermag_skip_to_content() {
        ?>
        <a class="skip-link screen-reader-text" href="#content" title="link"><?php esc_html_e( 'Skip to content', 'supermag' ); ?></a>
    <?php
    }
endif;
add_action( 'supermag_action_before_header', 'supermag_skip_to_content', 10 );

/**
 * Main header
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_header' ) ) :

    function supermag_header() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
	    $supermag_header_media_position = $supermag_customizer_all_values['supermag-header-media-position'];
	    if( 'very-top' == $supermag_header_media_position ){
		    supermag_header_markup();
	    }
        ?>
        <header id="masthead" class="site-header">
            <div class="top-header-section clearfix">
                <div class="wrapper">
                    <?php
                    if ( 1 == $supermag_customizer_all_values['supermag-show-date'] || 1 == $supermag_customizer_all_values['supermag-show-time']){
                        echo ' <div class="header-latest-posts float-left bn-title">';
                        if( 1 == $supermag_customizer_all_values['supermag-show-date'] ){
                            supermag_date_display();
                        }
                        if( 1 == $supermag_customizer_all_values['supermag-show-time'] ){
	                        $supermag_header_time_format = $supermag_customizer_all_values['supermag-header-time-format'];
                            echo "<div class='supermag-clock format-".esc_attr($supermag_header_time_format)."'></div>";
                        }
                        echo "</div>";
                    }
                    /*breaking news*/
                    $supermag_breaking_news_below_menu = $supermag_customizer_all_values['supermag-breaking-news-below-menu'];
                    If( 1 != $supermag_breaking_news_below_menu ){
	                    supermag_fe_breking_news();
                    }
                    ?>
                    <div class="right-header float-right">
                        <?php
                        if ( isset($supermag_customizer_all_values['supermag-enable-social'] ) && $supermag_customizer_all_values['supermag-enable-social'] == 1 ) {
                            /* Social Links*/
                            ?>
                            <div class="socials">
                                <?php
                                if ( !empty( $supermag_customizer_all_values['supermag-facebook-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-facebook-url'] ); ?>" class="facebook" data-title="Facebook" target="_blank">
                                        <span class="font-icon-social-facebook"><i class="fa fa-facebook"></i></span>
                                    </a>
                                <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-twitter-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-twitter-url'] ); ?>" class="twitter" data-title="Twitter" target="_blank">
                                        <span class="font-icon-social-twitter"><i class="fa fa-twitter"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-linkedin-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-linkedin-url'] ); ?>" class="linkedin" data-title="Linkedin" target="_blank">
                                        <span class="font-icon-social-linkedin"><i class="fa fa-linkedin"></i></span>
                                    </a>
                                <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-instagram-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-instagram-url'] ); ?>" class="instagram" data-title="Instagram" target="_blank">
                                        <span class="font-icon-social-instagram"><i class="fa fa-instagram"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-youtube-url'] ) ) { ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-youtube-url'] ); ?>" class="youtube" data-title="Youtube" target="_blank">
                                        <span class="font-icon-social-youtube"><i class="fa fa-youtube"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-google-plus-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-google-plus-url'] ); ?>" class="google-plus" data-title="Google Plus" target="_blank">
                                        <span class="font-icon-social-google-plus"><i class="fa fa-google-plus"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-pinterest-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-pinterest-url'] ); ?>" class="pinterest" data-title="Pinterest" target="_blank">
                                        <span class="font-icon-social-pinterest"><i class="fa fa-pinterest"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-flickr-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-flickr-url'] ); ?>" class="flickr" data-title="Flickr" target="_blank">
                                        <span class="font-icon-social-flickr"><i class="fa fa-flickr"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-tumblr-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-tumblr-url'] ); ?>" class="tumblr" data-title="Tumblr" target="_blank">
                                        <span class="font-icon-social-tumblr"><i class="fa fa-tumblr"></i></span>
                                    </a>
                                    <?php
                                }
                                if ( !empty( $supermag_customizer_all_values['supermag-vk-url'] ) ) {
                                    ?>
                                    <a href="<?php echo esc_url( $supermag_customizer_all_values['supermag-vk-url'] ); ?>" class="vk" data-title="VK" target="_blank">
                                        <span class="font-icon-social-vk"><i class="fa fa-vk"></i></span>
                                    </a>
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
            <!-- .top-header-section -->
            <div class="header-wrapper clearfix">
                <div class="header-container">
	                <?php
	                if( 'above-logo' == $supermag_header_media_position ){
		                supermag_header_markup();
	                }
	                ?>

                    <div class="wrapper">
                        <div class="site-branding clearfix">
                            <?php if ( 'disable' != $supermag_customizer_all_values['supermag-header-id-display-opt'] ):?>
                            <div class="site-logo float-left">
                                <?php
                                if ( 'logo-only' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-title' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-title-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                ):
                                    if ( function_exists( 'the_custom_logo' ) ) :
                                        the_custom_logo();
                                    else :
                                        if( !empty( $supermag_customizer_all_values['supermag-header-logo'] ) ):
                                            $supermag_header_alt = get_bloginfo('name');
                                            ?>
                                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                                <img src="<?php echo esc_url( $supermag_customizer_all_values['supermag-header-logo'] ); ?>" alt="<?php echo esc_attr( $supermag_header_alt ); ?>">
                                            </a>
                                            <?php
                                        endif;/*supermag-header-logo*/
                                    endif;
                                endif;
                                if( 'title-only' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'title-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-title' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-title-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                ):/*else is title-only or title-and-tagline*/
                                    if ( is_front_page() && is_home() ) : ?>
                                        <h1 class="site-title">
                                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                                        </h1>
                                    <?php else : ?>
                                        <p class="site-title">
                                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                                        </p>
                                        <?php
                                    endif;
                                endif;
                                if ( 'title-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                    || 'logo-and-title-and-tagline' == $supermag_customizer_all_values['supermag-header-id-display-opt']
                                ):
                                    $description = get_bloginfo( 'description', 'display' );
                                    if ( $description || is_customize_preview() ) : ?>
                                        <p class="site-description"><?php echo esc_html( $description ); ?></p>
                                    <?php endif;
                                endif;
                                ?>
                            </div><!--site-logo-->
                            <?php endif;/*<!--supermag-header-id-display-opt-->*/

                            if (  'hide' != $supermag_customizer_all_values['supermag-header-main-show-banner-ads']
                            || is_active_sidebar( 'supermag-header' )
                            ):
                                ?>
                                <div class="header-ainfo float-right">
                                    <?php
                                    if( 'image' == $supermag_customizer_all_values['supermag-header-main-show-banner-ads']
                                        || 1 == $supermag_customizer_all_values['supermag-header-main-show-banner-ads'] ){
                                        $supermag_header_main_banner_ads_link = $supermag_customizer_all_values['supermag-header-main-banner-ads-link'];
                                        $supermag_header_main_banner_new_tab = $supermag_customizer_all_values['supermag-header-main-banner-new-tab'];
                                        $blank = '';
                                        if( 1 == $supermag_header_main_banner_new_tab ){
                                            $blank = "target='_blank'";
                                        }
                                        ?>
                                        <a href="<?php echo esc_url( $supermag_header_main_banner_ads_link ); ?>" <?php echo $blank;?>>
                                            <img src="<?php echo esc_url( $supermag_customizer_all_values['supermag-header-main-banner-ads'] )?>" alt="<?php _e('Banner Ads','supermag')?>">
                                        </a>
                                        <?php
                                    }
                                    else{
                                        $supermag_header_main_google_ads = $supermag_customizer_all_values['supermag-header-main-google-ads'];
                                        echo $supermag_header_main_google_ads;
                                    }
                                    if( is_active_sidebar( 'supermag-header' ) ) :
                                        dynamic_sidebar( 'supermag-header' );
                                    endif;
                                    ?>
                                </div><!--.header-ainfo-->
                                <?php
                            endif;
                            ?>
                            <div class="clearfix"></div>
                            <?php
                            if ( is_active_sidebar( 'supermag-menu-before' ) ) {
                                dynamic_sidebar( 'supermag-menu-before' );
                            }
                            ?>
                        </div>
                    </div>
	                <?php
	                if( 'above-menu' == $supermag_header_media_position ){
		                supermag_header_markup();
	                }

                    $supermag_enable_sticky_menu = '';
                    if ( 1 == $supermag_customizer_all_values['supermag-enable-sticky-menu'] ){
                        $supermag_enable_sticky_menu = 'supermag-enable-sticky-menu';
                    }
                    ?>
                    <nav id="site-navigation" class="main-navigation <?php echo esc_attr( $supermag_enable_sticky_menu );?> clearfix">
                        <div class="header-main-menu wrapper clearfix">
                            <?php
                            if (isset( $supermag_customizer_all_values['supermag-menu-show-home-icon']) && $supermag_customizer_all_values['supermag-menu-show-home-icon'] == 1 ) {
                                if ( is_front_page() ) {
                                    $home_icon_class = 'home-icon front_page_on';
                                } else {
                                    $home_icon_class = 'home-icon';
                                }
                                ?>
                                <div class="<?php echo esc_attr( $home_icon_class ); ?>">
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"><i class="fa fa-home"></i></a>
                                </div>
                                <?php
                            }
                            if( !has_nav_menu('primary') ){
                                echo "<div class='acmethemes-nav'>";
                            }
                            wp_nav_menu(array('theme_location' => 'primary','container' => 'div', 'container_class' => 'acmethemes-nav'));
                            if( !has_nav_menu('primary') ){
                                echo "</div>";
                            }
                            if ( 1 == $supermag_customizer_all_values['supermag-enable-random-post'] ){
                                $sticky = get_option( 'sticky_posts' );
                                $supermag_random_post_query = new WP_Query(
                                    array (
                                        'orderby' => 'rand',
                                        'posts_per_page' => 1,
                                        'ignore_sticky_posts' => true,
                                        'post__not_in' => $sticky
                                    )
                                );
                                if ( $supermag_random_post_query->have_posts() ) {
                                    echo '<div class="random-post">';
                                    while ( $supermag_random_post_query->have_posts() ) {
                                        $supermag_random_post_query->the_post();
                                        ?>
                                        <a title="<?php echo esc_attr(get_the_title())?>" href="<?php the_permalink()?>">
                                            <i class="fa fa-random icon-menu"></i>
                                        </a>
                                        <?php
                                    }
                                    echo '</div>';/*random-post*/
                                }
                                wp_reset_postdata();
                            }
                            if ( 1 == $supermag_customizer_all_values['supermag-menu-show-search'] ):
                                if ( 1 == $supermag_customizer_all_values['supermag-another-search-type'] ){
                                    echo '<i class="fa fa-search icon-menu search-icon-menu"></i>';
                                    echo "<div class='menu-search-toggle'>";
                                    echo "<div class='menu-search-inner'>";
                                }
                                get_search_form();
                                if ( 1 == $supermag_customizer_all_values['supermag-another-search-type'] ){
                                    echo '</div>';/*menu-search-inner*/
                                    echo '</div>';/*menu-search-toggle*/
                                }
                            endif; ?>
                        </div>
                        <div class="responsive-slick-menu wrapper clearfix"></div>
                    </nav>
                    <!-- #site-navigation -->
	                <?php
	                If( 1 == $supermag_breaking_news_below_menu ){
	                    echo '<div class="wrapper"><div class="aftemenu-bn clearfix">';
		                supermag_fe_breking_news();
		                echo "</div></div>";
	                }
	                if( 'below-menu' == $supermag_header_media_position ){
		                supermag_header_markup();
	                }
	                ?>
                </div>
                <!-- .header-container -->
            </div>
            <!-- header-wrapper-->
        </header>
        <!-- #masthead -->
        <?php
    }
endif;
add_action( 'supermag_action_header', 'supermag_header', 10 );

/**
 * Before main content
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_before_content' ) ) :

    function supermag_before_content() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        ?>
        <div class="wrapper content-wrapper clearfix">
        <?php
        if ( is_front_page() && 1 == $supermag_customizer_all_values['supermag-enable-feature']) {
            echo '<div class="slider-feature-wrap clearfix">';
            /*Slide*/
            /**
             * supermag_action_feature_slider
             * @since SuperMag 1.0.0
             *
             * @hooked supermag_feature_slider -  0
             */
            do_action('supermag_action_feature_slider');
            /*Featured Post Beside Slider*/
            /**
             * supermag_action_feature_side
             * @since SuperMag 1.0.0
             *
             * @hooked supermag_feature_side-  0
             */
            do_action('supermag_action_feature_side');
            echo "</div>";
            $supermag_content_id = "home-content";
        } else {
            $supermag_content_id = "content";
        }
        ?>
    <div id="<?php echo esc_attr( $supermag_content_id ); ?>" class="site-content">
        <?php
        $sidebar_layout = supermag_sidebar_selection(get_the_ID());
        if( 'both-sidebar' == $sidebar_layout ) {
            echo '<div id="primary-wrap" class="clearfix">';
        }
        if( 'disable' != $supermag_customizer_all_values['supermag-breadcrumb-options'] && !is_front_page() ){
            if( 'advanced' == $supermag_customizer_all_values['supermag-breadcrumb-options'] ){
                if( function_exists('bcn_display')){
                    echo '<div id="supermag-breadcrumbs"><div class="breadcrumb-container">';
                    bcn_display();
                    echo "</div></div>";
                }
                else{
                    supermag_breadcrumbs();
                }
            }
            else{
                supermag_breadcrumbs();
            }
        }
    }
endif;
add_action( 'supermag_action_after_header', 'supermag_before_content', 10 );