<?php
/**
 * Post Navigation
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_posts_navigation') ) :
    function supermag_posts_navigation() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_pagination_option = $supermag_customizer_all_values['supermag-pagination-option'];
        if( 'disable' == $supermag_pagination_option ){
        	return;
        }
        if( 'default' == $supermag_pagination_option ){
            the_posts_navigation();
        }
        else{
            global $wp_query;
            $big = 999999999; // need an unlikely integer
            echo paginate_links(array(
                'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                'format' => '?paged=%#%',
                'current' => max(1, get_query_var('paged')),
                'total' => $wp_query->max_num_pages,
                'prev_text' => __('&laquo;', 'supermag'),
                'next_text' => __('&raquo;', 'supermag'),
            ));
        }
    }
endif;
add_action( 'supermag_action_navigation', 'supermag_posts_navigation', 10 );