<?php
/**
 * Default Slider
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 */
if ( !function_exists('supermag_default_slider') ) :
    function supermag_default_slider(){
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_single_slider_words = absint( $supermag_customizer_all_values['supermag-feature-slider-content-words']);
        ?>
        <li class="default-content">
            <a href="#">
                <img src="<?php echo esc_url( get_template_directory_uri()."/assets/img/no-image-660-365.png" ); ?>"/>
            </a>
            <div class="slider-desc">
                <div class="slider-details">
                    <a href="#">
                        <div class="slide-title">
                            <?php _e('Welcome to SuperMag','supermag'); ?>
                        </div>
                    </a>
                </div>
                <?php
                if( 0 != $supermag_single_slider_words){
                    echo '<div class="slide-caption">'.__('A very perfect theme for magazine','supermag').'</div>';
                }
                ?>
            </div>
        </li>
        <?php
    }
endif;

/**
 * Featured Slider array creation
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 */
if ( ! function_exists( 'supermag_display_feature_slider_array' ) ) :

    function supermag_display_feature_slider_array( ){
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_no_image_medium = $supermag_customizer_all_values['supermag-no-image-medium'];

        $supermag_slider_selection_from = $supermag_customizer_all_values['supermag-slider-selection-from'];
        $supermag_slider_number = absint( $supermag_customizer_all_values['supermag-feature-slider-post-number']);
        $supermag_show_cat = $supermag_customizer_all_values['supermag-feature-slider-show-categories'];
        $supermag_show_date = $supermag_customizer_all_values['supermag-feature-slider-show-date'];
        $supermag_show_author = $supermag_customizer_all_values['supermag-feature-slider-show-author'];
        $supermag_show_comment = $supermag_customizer_all_values['supermag-feature-slider-show-comments'];
        $supermag_single_slider_words = absint( $supermag_customizer_all_values['supermag-feature-slider-content-words']);
        $supermag_slider_args = array();
        if ( 'from-custom' ==  $supermag_slider_selection_from ){
            $supermag_slider_contents_array = array();

            $supermag_slide_1_image = $supermag_customizer_all_values['supermag-slide-1-image'];
            $supermag_slide_1_title = $supermag_customizer_all_values['supermag-slide-1-title'];
            $supermag_slide_1_desc = $supermag_customizer_all_values['supermag-slide-1-desc'];
            $supermag_slide_1_link = $supermag_customizer_all_values['supermag-slide-1-link'];
            if( !empty ( $supermag_slide_1_image )){
                $supermag_slider_contents_array[0]['supermag-slider-image'] = $supermag_slide_1_image;
            }
            if( !empty ( $supermag_slide_1_title )){
                $supermag_slider_contents_array[0]['supermag-slider-title'] = $supermag_slide_1_title;
            }
            if( !empty ( $supermag_slide_1_desc )){
                $supermag_slider_contents_array[0]['supermag-slider-desc'] = $supermag_slide_1_desc;
            }
            if( !empty ( $supermag_slide_1_link )){
                $supermag_slider_contents_array[0]['supermag-slider-link'] = $supermag_slide_1_link;
            }

            $supermag_slide_2_image = $supermag_customizer_all_values['supermag-slide-2-image'];
            $supermag_slide_2_title = $supermag_customizer_all_values['supermag-slide-2-title'];
            $supermag_slide_2_desc = $supermag_customizer_all_values['supermag-slide-2-desc'];
            $supermag_slide_2_link = $supermag_customizer_all_values['supermag-slide-2-link'];
            if( !empty ( $supermag_slide_2_image )){
                $supermag_slider_contents_array[1]['supermag-slider-image'] = $supermag_slide_2_image;
            }
            if( !empty ( $supermag_slide_2_title )){
                $supermag_slider_contents_array[1]['supermag-slider-title'] = $supermag_slide_2_title;
            }
            if( !empty ( $supermag_slide_2_desc )){
                $supermag_slider_contents_array[1]['supermag-slider-desc'] = $supermag_slide_2_desc;
            }
            if( !empty ( $supermag_slide_2_link )){
                $supermag_slider_contents_array[1]['supermag-slider-link'] = $supermag_slide_2_link;
            }

            $supermag_slide_3_image = $supermag_customizer_all_values['supermag-slide-3-image'];
            $supermag_slide_3_title = $supermag_customizer_all_values['supermag-slide-3-title'];
            $supermag_slide_3_desc = $supermag_customizer_all_values['supermag-slide-3-desc'];
            $supermag_slide_3_link = $supermag_customizer_all_values['supermag-slide-3-link'];
            if( !empty ( $supermag_slide_3_image )){
                $supermag_slider_contents_array[2]['supermag-slider-image'] = $supermag_slide_3_image;
            }
            if( !empty ( $supermag_slide_3_title )){
                $supermag_slider_contents_array[2]['supermag-slider-title'] = $supermag_slide_3_title;
            }
            if( !empty ( $supermag_slide_3_desc )){
                $supermag_slider_contents_array[2]['supermag-slider-desc'] = $supermag_slide_3_desc;
            }
            if( !empty ( $supermag_slide_3_link )){
                $supermag_slider_contents_array[2]['supermag-slider-link'] = $supermag_slide_3_link;
            }

            $supermag_slide_4_image = $supermag_customizer_all_values['supermag-slide-4-image'];
            $supermag_slide_4_title = $supermag_customizer_all_values['supermag-slide-4-title'];
            $supermag_slide_4_desc = $supermag_customizer_all_values['supermag-slide-4-desc'];
            $supermag_slide_4_link = $supermag_customizer_all_values['supermag-slide-4-link'];
            if( !empty ( $supermag_slide_4_image )){
                $supermag_slider_contents_array[3]['supermag-slider-image'] = $supermag_slide_4_image;
            }
            if( !empty ( $supermag_slide_4_title )){
                $supermag_slider_contents_array[3]['supermag-slider-title'] = $supermag_slide_4_title;
            }
            if( !empty ( $supermag_slide_4_desc )){
                $supermag_slider_contents_array[3]['supermag-slider-desc'] = $supermag_slide_4_desc;
            }
            if( !empty ( $supermag_slide_4_link )){
                $supermag_slider_contents_array[3]['supermag-slider-link'] = $supermag_slide_4_link;
            }

            $supermag_slide_5_image = $supermag_customizer_all_values['supermag-slide-5-image'];
            $supermag_slide_5_title = $supermag_customizer_all_values['supermag-slide-5-title'];
            $supermag_slide_5_desc = $supermag_customizer_all_values['supermag-slide-5-desc'];
            $supermag_slide_5_link = $supermag_customizer_all_values['supermag-slide-5-link'];
            if( !empty ( $supermag_slide_5_image )){
                $supermag_slider_contents_array[4]['supermag-slider-image'] = $supermag_slide_5_image;
            }
            if( !empty ( $supermag_slide_5_title )){
                $supermag_slider_contents_array[4]['supermag-slider-title'] = $supermag_slide_5_title;
            }
            if( !empty ( $supermag_slide_5_desc )){
                $supermag_slider_contents_array[4]['supermag-slider-desc'] = $supermag_slide_5_desc;
            }
            if( !empty ( $supermag_slide_5_link )){
                $supermag_slider_contents_array[4]['supermag-slider-link'] = $supermag_slide_5_link;
            }
            if( !empty( $supermag_slider_contents_array )){
                foreach( $supermag_slider_contents_array as $supermag_slider_content_array ){
                    if( isset( $supermag_slider_content_array['supermag-slider-link'] ) ){
                        $supermag_slider_link = esc_url( $supermag_slider_content_array['supermag-slider-link'] );
                    }
                    else{
                        $supermag_slider_link = '#';
                    }
                    if( isset( $supermag_slider_content_array['supermag-slider-image'] ) ){
                        $supermag_slider_image = esc_url( $supermag_slider_content_array['supermag-slider-image'] );
                    }
                    else{
                        $supermag_slider_image = esc_url( $supermag_no_image_medium );
                    }
                    if( isset( $supermag_slider_content_array['supermag-slider-title'] ) ){
                        $supermag_slider_title = esc_html( $supermag_slider_content_array['supermag-slider-title'] );
                    }
                    else{
                        $supermag_slider_title = '';
                    }
                    if( isset( $supermag_slider_content_array['supermag-slider-desc'] ) ){
                        $supermag_slider_desc = esc_html( $supermag_slider_content_array['supermag-slider-desc'] );
                    }
                    else{
                        $supermag_slider_desc = '';
                    }
                    ?>
                    <li>
                        <a href="<?php echo $supermag_slider_link; ?>">
                            <img src="<?php echo $supermag_slider_image; ?>"/>
                        </a>
                        <div class="slider-desc">
                            <div class="slider-details">
                                <a href="<?php echo $supermag_slider_link; ?>">
                                    <div class="slide-title">
                                        <?php echo $supermag_slider_title; ?>
                                    </div>
                                </a>
                            </div>
                            <?php
                            if( 0 != $supermag_single_slider_words){
                                $content = supermag_words_count( $supermag_slider_desc ,$supermag_single_slider_words );
                                echo '<div class="slide-caption">'.esc_html( $content ).'</div>';
                            }
                            ?>
                        </div>
                    </li>
                    <?php
                }
            }
            else{
                supermag_default_slider();
            }
        }
        else{
            if( 'from-recent' == $supermag_slider_selection_from ){
                $supermag_slider_args =    array(
                    'post_type' => 'post',
                    'posts_per_page' => $supermag_slider_number,
                    'ignore_sticky_posts ' => true
                );
            }
            elseif( 'from-tag' == $supermag_slider_selection_from ){
                $supermag_slider_tag = $supermag_customizer_all_values['supermag-slider-from-tag'];
                if( 0 != $supermag_slider_tag ){
                    $supermag_slider_args =    array(
                        'post_type' => 'post',
                        'tag_id' => $supermag_slider_tag,
                        'posts_per_page' => $supermag_slider_number,
                        'ignore_sticky_posts ' => true
                    );
                }
            }
            else{
                $supermag_slider_category = $supermag_customizer_all_values['supermag-slider-from-category'];
                if( 0 != $supermag_slider_category ){
                    $supermag_slider_args =    array(
                        'post_type' => 'post',
                        'cat' => $supermag_slider_category,
                        'posts_per_page' => $supermag_slider_number,
                        'ignore_sticky_posts ' => true
                    );
                }
            }
        }
        if( !empty( $supermag_slider_args )){
            $sticky = get_option( 'sticky_posts' );
            $supermag_slider_args['post__not_in'] = $sticky;
            // the query
            $supermag_slider_post_query = new WP_Query( $supermag_slider_args );
            if ( $supermag_slider_post_query->have_posts() ) :

                $i = 0;
                while ( $supermag_slider_post_query->have_posts() ) : $supermag_slider_post_query->the_post();
                    if (has_post_thumbnail()) {
                        $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium');
                    } else {
                        $image_url[0] = $supermag_no_image_medium;
                    }
                    ?>
                    <li>
                        <a href="<?php the_permalink(); ?>">
                            <img src="<?php echo esc_url( $image_url[0] ); ?>" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" />
                        </a>
                        <div class="slider-desc">
                            <?php if( 1 == $supermag_show_date || 1 == $supermag_show_author || 1== $supermag_show_comment ){
                                ?>
                                <div class="above-slider-details">
                                    <?php
                                    $archive_year  = get_the_date('Y');
                                    $archive_month = get_the_date('m');
                                    $archive_day   = get_the_date('d');
                                    ?>
                                    <?php if ( 1 == $supermag_show_date ){
                                        ?>
                                        <i class="fa fa-calendar"></i>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                            <?php echo esc_html( get_the_date() ); ?>
                                        </a>
                                        <?php
                                    }
                                    if ( 1 == $supermag_show_author ){
                                        ?>
                                        <i class="fa fa-user"></i>
                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo esc_attr( get_the_author() ); ?>">
                                            <?php echo esc_html( get_the_author() ); ?>
                                        </a>
                                        <?php
                                    }
                                    if ( 1 == $supermag_show_comment ){
                                        ?>
                                        <i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <?php
                            }
                            ?>
                            <div class="slider-details">
                                <a href="<?php the_permalink()?>">
                                    <div class="slide-title">
                                        <?php the_title(); ?>
                                    </div>
                                    <?php
                                    if( 0 != $supermag_single_slider_words){
                                        $content = supermag_words_count(get_the_excerpt(),$supermag_single_slider_words);
                                        echo '<div class="slide-caption">'.esc_html( $content ).'</div>';
                                    }
                                    ?>
                                </a>
                            </div>

                            <div>
                                <?php
                                if( 1 == $supermag_show_cat ){
                                    supermag_list_category();
                                }
                                ?>
                            </div>
                        </div>
                    </li>
                    <?php
                    $i++;
                endwhile;
                wp_reset_postdata();
            endif;
        }
        elseif( 'from-custom' !=  $supermag_slider_selection_from ) {
            supermag_default_slider();
        }
    }
endif;
/**
 * Display Featured Slider
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_feature_slider') ) :
    function supermag_feature_slider() {
	    $supermag_customizer_all_values = supermag_get_theme_options();
        $supermag_feature_slider_speed = $supermag_customizer_all_values['supermag-feature-slider-speed'];
        $supermag_feature_slider_pause = $supermag_customizer_all_values['supermag-feature-slider-pause'];
        $supermag_feature_slider_autoplay = $supermag_customizer_all_values['supermag-feature-slider-enable-autoplay'];
        $supermag_feature_slider_controls = $supermag_customizer_all_values['supermag-feature-slider-enable-controls'];
        ?>
        <div class="slider-section">
            <ul class="home-bxslider" data-speed="<?php echo absint( $supermag_feature_slider_speed );?>" data-pause="<?php echo absint( $supermag_feature_slider_pause );?>" data-auto="<?php echo esc_attr( $supermag_feature_slider_autoplay );?>" data-controls="<?php echo esc_attr( $supermag_feature_slider_controls );?>">
                <?php supermag_display_feature_slider_array(); ?>
            </ul>
        </div>
        <?php
    }
endif;
add_action( 'supermag_action_feature_slider', 'supermag_feature_slider', 0 );