<?php
/**
 * Feature side
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_feature_side') ) :
    function supermag_feature_side() {

	    $supermag_customizer_all_values = supermag_get_theme_options();
        echo '<div class="besides-slider">';
        echo '<div class="besides-slider-left">';
        $supermag_beside_slider_ids = array();
        $supermag_beside_adds = array();
        $supermag_slider_side_args = array();
        $supermag_featured_main_layout = $supermag_customizer_all_values['supermag-feature-side-display-options'];
	    $supermag_feature_side_title_length = $supermag_customizer_all_values['supermag-feature-side-title-length'];


        if(isset($supermag_customizer_all_values['supermag-feature-side-display-options']) && !empty($supermag_customizer_all_values['supermag-feature-side-display-options'])){
            if( 'from-recent' == $supermag_featured_main_layout ){
                $supermag_slider_side_args =    array(
                    'post_type' => 'post',
                    'posts_per_page' => 4,
                    'ignore_sticky_posts ' => true
                );
            }
            elseif( 'from-category' == $supermag_featured_main_layout ){
                $supermag_feature_side_from_category = $supermag_customizer_all_values['supermag-feature-side-from-category'];
                if( 0 != $supermag_feature_side_from_category ){
                    $supermag_slider_side_args =    array(
                        'post_type' => 'post',
                        'cat' => $supermag_feature_side_from_category,
                        'posts_per_page' => 4
                    );
                }
                else{
                    $supermag_slider_side_args =    array(
                        'post_type' => 'post',
                        'posts_per_page' => 4,
                        'ignore_sticky_posts ' => true
                    );
                }
            }
            elseif( 'post-4' == $supermag_featured_main_layout ){

                if(isset($supermag_customizer_all_values['supermag-feature-post-one']) && -1 != $supermag_customizer_all_values['supermag-feature-post-one'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-one'];
                }
                if(isset($supermag_customizer_all_values['supermag-feature-post-two']) && -1 != $supermag_customizer_all_values['supermag-feature-post-two'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-two'];
                }
                if(isset($supermag_customizer_all_values['supermag-feature-post-three']) && -1 != $supermag_customizer_all_values['supermag-feature-post-three'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-three'];
                }
                if(isset($supermag_customizer_all_values['supermag-feature-post-four']) && -1 != $supermag_customizer_all_values['supermag-feature-post-four'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-four'];
                }
            }
            elseif( 'add-4' == $supermag_featured_main_layout ){
                $supermag_beside_slider_ids = array();
                if( !empty($supermag_customizer_all_values['supermag-feature-add-one']) ){
                    $supermag_beside_adds[0]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-one'];
                    $supermag_beside_adds[0]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-one-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-two']) ){
                    $supermag_beside_adds[1]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-two'];
                    $supermag_beside_adds[1]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-two-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-three']) ){
                    $supermag_beside_adds[2]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-three'];
                    $supermag_beside_adds[2]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-three-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-four']) ){
                    $supermag_beside_adds[3]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-four'];
                    $supermag_beside_adds[3]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-four-link'];
                }
            }
            elseif( 'post-1-add-3' == $supermag_featured_main_layout ){
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-one'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-one'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-one']) ){
                    $supermag_beside_adds[0]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-one'];
                    $supermag_beside_adds[0]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-one-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-two']) ){
                    $supermag_beside_adds[1]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-two'];
                    $supermag_beside_adds[1]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-two-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-three']) ){
                    $supermag_beside_adds[2]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-three'];
                    $supermag_beside_adds[2]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-three-link'];
                }
            }
            elseif( 'post-2-add-2' == $supermag_featured_main_layout ){
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-one'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-one'];
                }
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-two'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-two'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-one']) ){
                    $supermag_beside_adds[0]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-one'];
                    $supermag_beside_adds[0]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-one-link'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-two']) ){
                    $supermag_beside_adds[1]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-two'];
                    $supermag_beside_adds[1]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-two-link'];
                }
            }
            elseif( 'post-3-add-1' == $supermag_featured_main_layout ){
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-one'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-one'];
                }
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-two'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-two'];
                }
                if( -1 != $supermag_customizer_all_values['supermag-feature-post-three'] ){
                    $supermag_beside_slider_ids[] = $supermag_customizer_all_values['supermag-feature-post-three'];
                }
                if( !empty($supermag_customizer_all_values['supermag-feature-add-one']) ){
                    $supermag_beside_adds[0]['supermag-feature-add'] = $supermag_customizer_all_values['supermag-feature-add-one'];
                    $supermag_beside_adds[0]['supermag-feature-add-link'] = $supermag_customizer_all_values['supermag-feature-add-one-link'];
                }
            }
            else{
                $supermag_beside_adds = array();
            }

        }
        $supermag_float_fixed = 1;
        if( !empty( $supermag_beside_slider_ids ) ||
            'from-category' == $supermag_featured_main_layout ||
            'from-recent' == $supermag_featured_main_layout
        ){
            if( empty( $supermag_slider_side_args ) ){
                $supermag_slider_side_args = array(
                    'post_type' => 'post',
                    'posts_per_page' => count($supermag_beside_slider_ids),
                    'post__in' => $supermag_beside_slider_ids,
                    'orderby' => 'post__in',
                    'ignore_sticky_posts' => true
                );
            }
            $sticky = get_option( 'sticky_posts' );
            $supermag_slider_side_args['post__not_in'] = $sticky;
            $beside_query = new WP_Query($supermag_slider_side_args);
            if ($beside_query->have_posts()) {

	            $supermag_customizer_all_values = supermag_get_theme_options();

                $supermag_no_image_post_thumb = $supermag_customizer_all_values['supermag-no-image-post-thumb'];

                while ($beside_query->have_posts()) {
                    $beside_query->the_post();
                    if (has_post_thumbnail()) {
                        $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(), 'post-thumbnail');
                    }
                    else {
                        $image_url[0] = $supermag_no_image_post_thumb;
                    }
                    ?>
                    <div class="beside-post clearfix">
                        <a href="<?php the_permalink(); ?>">
                            <figure class="beside-thumb clearfix">
                                <img src="<?php echo esc_url( $image_url[0] ); ?>" alt="<?php echo the_title_attribute(); ?>" title="<?php echo the_title_attribute(); ?>" />
                                <div class="overlay"></div>
                            </figure>
                        </a>
                        <div class="beside-caption clearfix">
                            <?php
                            if ( 1 == $supermag_customizer_all_values['supermag-feature-side-show-title'] ) {
                                ?>
                                <h3 class="post-title">
                                    <a href="<?php the_permalink()?>">
	                                    <?php
	                                    $title = supermag_words_count( get_the_title() ,$supermag_feature_side_title_length);
	                                    echo esc_html( $title);
	                                    ?>
                                    </a>
                                </h3>
                                <?php
                            }

                            if ( isset($supermag_customizer_all_values['supermag-feature-side-show-date']) && $supermag_customizer_all_values['supermag-feature-side-show-date'] == 1 ) {
                                $supermag_show_date = $supermag_customizer_all_values['supermag-feature-side-show-date'];
                            }
                            else{
                                $supermag_show_date = 0;
                            }
                            if ( isset($supermag_customizer_all_values['supermag-feature-side-show-author']) && $supermag_customizer_all_values['supermag-feature-side-show-author'] == 1 ) {
                                $supermag_show_author = $supermag_customizer_all_values['supermag-feature-side-show-author'];
                            }
                            else{
                                $supermag_show_author = 0;
                            }
                            if ( isset($supermag_customizer_all_values['supermag-feature-side-show-comments']) && $supermag_customizer_all_values['supermag-feature-side-show-comments'] == 1 ) {
                                $supermag_show_comment = $supermag_customizer_all_values['supermag-feature-side-show-comments'];
                            }
                            else{
                                $supermag_show_comment = 0;
                            }
                            if( 1 == $supermag_show_date || 1 == $supermag_show_author || 1== $supermag_show_comment ){
                                ?>
                                <div class="post-date">
                                    <?php if ( 1 == $supermag_show_date ){
                                        $archive_year  = get_the_date('Y');
                                        $archive_month = get_the_date('m');
                                        $archive_day   = get_the_date('d');
                                        ?>
                                        <i class="fa fa-calendar"></i>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                            <?php echo esc_html( get_the_date() ); ?>
                                        </a>
                                        <?php
                                    }
                                    if ( 1 == $supermag_show_author ){
                                        ?>
                                        <i class="fa fa-user"></i>
                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo esc_attr( get_the_author() ); ?>">
                                            <?php echo esc_html( get_the_author() ); ?>
                                        </a>
                                        <?php
                                    }
                                    if ( 1 == $supermag_show_comment ){
                                        ?>
                                        <i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <div class="above-slider-details"></div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                    <?php
                    if( 2 == $supermag_float_fixed ){
                        echo "</div>";
                        echo '<div class="besides-slider-right">';
                    }
                    $supermag_float_fixed++;
                }
            }
            wp_reset_postdata();
        }
        if( !empty( $supermag_beside_adds ) ) {
            foreach ( $supermag_beside_adds as $supermag_beside_add_id){
                ?>
                <div class="beside-post clearfix">
                    <figure class="beside-thumb clearfix">
                        <a href="<?php echo esc_url( $supermag_beside_add_id['supermag-feature-add-link']); ?>" target="_blank">
                            <img src="<?php echo esc_url( $supermag_beside_add_id['supermag-feature-add']); ?>">
                        </a>
                    </figure>
                </div>
                <?php
                if( 2 == $supermag_float_fixed ){
                    echo "</div>";
                    echo '<div class="besides-slider-right">';
                }
                $supermag_float_fixed++;
            }
        }
        echo '</div><!-- .feature-side-slider-left -->';
        echo '</div><!-- .feature-side-slider -->';
    }
endif;
add_action( 'supermag_action_feature_side', 'supermag_feature_side', 0 );