<?php
/**
 * Checks if there are options already present from free version and adds it to the Pro theme options
 *
 * @since SuperMag 1.0
 * @hook after_theme_switch
 */
function supermag_setup_options() {
    //Perform action only if theme_mods_supermagpro[supermag_theme_options] does not exist
    if( !get_theme_mod( 'supermag_theme_options' ) ) {
        //Perform action only if theme_mods_supermag free version exists
        if ( $supermag_free_options = get_option ( 'theme_mods_supermag' ) ) {
            if ( isset( $supermag_free_options['supermag_theme_options'] ) ) {
                $supermag_pro_default_options = supermag_get_default_theme_options();

                $supermag_theme_options = $supermag_free_options;

                $supermag_theme_options['supermag_theme_options'] = array_merge( $supermag_pro_default_options , $supermag_free_options['supermag_theme_options'] );

                update_option('theme_mods_supermagpro', $supermag_theme_options );
            }
        }
    }
}
add_action('after_switch_theme', 'supermag_setup_options');