<?php
/**
 * Main include functions ( to support child theme )
 *
 * @since SuperMag 1.0.0
 *
 * @param string $file_path, path from the theme
 * @return string full path of file inside theme
 *
 */
if( !function_exists('supermag_file_directory') ){
    function supermag_file_directory( $file_path ){
        if( file_exists( trailingslashit( get_stylesheet_directory() ) . $file_path) ) {
            return trailingslashit( get_stylesheet_directory() ) . $file_path;
        }
        else{
            return trailingslashit( get_template_directory() ) . $file_path;
        }
    }
}

/**
 * Check empty or null
 *
 * @since SuperMag 1.0.0
 *
 * @param string $str, string
 * @return boolean
 *
 */
if( !function_exists('supermag_is_null_or_empty') ){
    function supermag_is_null_or_empty( $str ){
        return ( !isset($str) || trim($str)==='' );
    }
}

/*file for library*/
require_once supermag_file_directory('acmethemes/library/tgm/class-tgm-plugin-activation.php');

/**
 * Customizer additions.
 */
require_once supermag_file_directory('acmethemes/customizer/customizer.php');

/**
 * Include Functions
 */
require_once supermag_file_directory('acmethemes/functions/blog-thumb-size.php');

require_once supermag_file_directory('acmethemes/functions/breadcrumbs.php');

require_once supermag_file_directory('acmethemes/functions/category-list.php');

require_once supermag_file_directory('acmethemes/functions/comment-list.php');

require_once supermag_file_directory('acmethemes/functions/date-display.php');

require_once supermag_file_directory('acmethemes/functions/pagination.php');

require_once supermag_file_directory('acmethemes/functions/post-view.php');

require_once supermag_file_directory('acmethemes/functions/related-posts.php');

require_once supermag_file_directory('acmethemes/functions/sidebar-selection.php');

require_once supermag_file_directory('acmethemes/functions/words-count.php');

require_once supermag_file_directory('acmethemes/functions/wp-get-attachment.php');

require_once supermag_file_directory('acmethemes/functions/col-clearfix.php');

require_once supermag_file_directory('acmethemes/functions/header.php');

require_once supermag_file_directory('acmethemes/functions/breaking-news.php');

/*WooCommerce*/
require_once supermag_file_directory('acmethemes/woocommerce/functions-woocommerce.php');

/**
 * Implement Mega menus
 */
$supermag_customizer_all_values = supermag_get_theme_options();
$supermag_enable_mega_menu = $supermag_customizer_all_values['supermag-enable-mega-menu'];
if( 1 == $supermag_enable_mega_menu ){
	require_once supermag_file_directory('acmethemes/mega-menu/mega-menu.php');
}

/**
 * Implement Custom Metaboxes
 */
require_once supermag_file_directory('acmethemes/metabox/metabox.php');

/**
 * Include Hooks
 */
require_once supermag_file_directory('acmethemes/hooks/tgm.php');

require_once supermag_file_directory('acmethemes/hooks/front-page.php');

require_once supermag_file_directory('acmethemes/hooks/exclude-cats.php');

require_once supermag_file_directory('acmethemes/hooks/slider-selection.php');

require_once supermag_file_directory('acmethemes/hooks/slider-side.php');

require_once supermag_file_directory('acmethemes/hooks/comment-forms.php');

require_once supermag_file_directory('acmethemes/hooks/excerpts.php');

require_once supermag_file_directory('acmethemes/hooks/footer.php');

require_once supermag_file_directory('acmethemes/hooks/header.php');

require_once supermag_file_directory('acmethemes/hooks/navigation.php');

/*theme switch code*/
require_once supermag_file_directory('acmethemes/hooks/theme-switch.php');

require_once supermag_file_directory('acmethemes/hooks/siteorigin-panels.php');

require_once supermag_file_directory('acmethemes/hooks/acme-demo-setup.php');

/**
 * Include sidebar and widgets
 */
require_once supermag_file_directory('acmethemes/sidebar-widget/acme-cat-col.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-col-posts.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-col-posts-pro.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-popular-posts.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-gallery.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-video-gallery.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-slider.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-gallery-slider.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-news-ticker.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-ad.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-tab.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/acme-author.php');

require_once supermag_file_directory('acmethemes/sidebar-widget/sidebar.php');

/*core functions imported from functions.php*/
require_once supermag_file_directory('acmethemes/core.php');
require_once supermag_file_directory('acmethemes/gutenberg/gutenberg-init.php');

/*themes info*/
require_once supermag_file_directory('acmethemes/at-theme-info/class-at-theme-info.php');