<?php
/**
 * Supermag sidebar layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_sidebar_layout_options') ) :
    function supermag_sidebar_layout_options() {
        $supermag_sidebar_layout_options = array(
	        'default-sidebar' => array(
		        'value'     => 'default-sidebar',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/default-sidebar.png'
	        ),
	        'left-sidebar' => array(
		        'value'     => 'left-sidebar',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/left-sidebar.png'
	        ),
	        'right-sidebar' => array(
		        'value' => 'right-sidebar',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/right-sidebar.png'
	        ),
	        'both-sidebar' => array(
		        'value' => 'both-sidebar',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/both-sidebar.png'
	        ),
	        'middle-col' => array(
		        'value'     => 'middle-col',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/middle-col.png'
	        ),
	        'no-sidebar' => array(
		        'value'     => 'no-sidebar',
		        'thumbnail' => get_template_directory_uri() . '/acmethemes/images/no-sidebar.png'
	        )
        );
        return apply_filters( 'supermag_sidebar_layout_options', $supermag_sidebar_layout_options );
    }
endif;

/**
 * Custom Metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if( !function_exists( 'supermag_add_metabox' )):
    function supermag_add_metabox() {
        add_meta_box(
            'supermag_sidebar_layout', // $id
            __( 'Sidebar Layout', 'supermag' ), // $title
            'supermag_sidebar_layout_callback', // $callback
            'post', // $page
            'normal', // $context
            'high'
        ); // $priority

        add_meta_box(
            'supermag_sidebar_layout', // $id
            __( 'Sidebar Layout', 'supermag' ), // $title
            'supermag_sidebar_layout_callback', // $callback
            'page', // $page
            'normal', // $context
            'high'
        ); // $priority
    }
endif;
add_action('add_meta_boxes', 'supermag_add_metabox');

/**
 * Callback function for metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_sidebar_layout_callback') ) :
    function supermag_sidebar_layout_callback(){
        global $post;
        $supermag_sidebar_layout_options = supermag_sidebar_layout_options();
        $supermag_sidebar_layout = 'default-sidebar';
        $supermag_sidebar_meta_layout = get_post_meta( $post->ID, 'supermag_sidebar_layout', true );
        if( !supermag_is_null_or_empty($supermag_sidebar_meta_layout) ){
            $supermag_sidebar_layout = $supermag_sidebar_meta_layout;
        }
        wp_nonce_field( basename( __FILE__ ), 'supermag_sidebar_layout_nonce' );
        ?>
        <table class="form-table page-meta-box">
            <tr>
                <td colspan="4"><h4><?php _e( 'Choose Sidebar Template', 'supermag' ); ?></h4></td>
            </tr>
            <tr>
                <td>
                    <?php
                    foreach ($supermag_sidebar_layout_options as $field) {
                        ?>
                        <div class="hide-radio radio-image-wrapper" style="float:left; margin-right:30px;">
                            <input id="<?php echo $field['value']; ?>" type="radio" name="supermag_sidebar_layout" value="<?php echo $field['value']; ?>" <?php checked( $field['value'], $supermag_sidebar_layout ); ?>/>
                            <label class="description" for="<?php echo $field['value']; ?>">
                                <img src="<?php echo esc_url( $field['thumbnail'] ); ?>" alt="" />
                            </label>
                        </div>
                    <?php } // end foreach
                    ?>
                    <div class="clear"></div>
                </td>
            </tr>
            <tr>
                <td><em class="f13"><?php _e( 'You can set up the sidebar content', 'supermag' ); ?> <a href="<?php echo admin_url('/widgets.php'); ?>"><?php _e( 'here', 'supermag' ); ?></a></em></td>
            </tr>

        </table>
    <?php
}
endif;

/**
 * save the custom metabox data
 * @hooked to save_post hook
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_save_sidebar_layout') ) :
    function supermag_save_sidebar_layout( $post_id ) {

        // Verify the nonce before proceeding.
        if ( !isset( $_POST[ 'supermag_sidebar_layout_nonce' ] ) || !wp_verify_nonce( $_POST[ 'supermag_sidebar_layout_nonce' ], basename( __FILE__ ) ) )
            return;

        // Stop WP from clearing custom fields on autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE)
            return;

        if ('page' == $_POST['post_type']) {
            if (!current_user_can( 'edit_page', $post_id ) )
                return $post_id;
        } elseif (!current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }

        //Execute this saving function
        if(isset($_POST['supermag_sidebar_layout'])){
            $old = get_post_meta( $post_id, 'supermag_sidebar_layout', true);
            $new = sanitize_text_field($_POST['supermag_sidebar_layout']);
            if ($new && $new != $old) {
                update_post_meta($post_id, 'supermag_sidebar_layout', $new);
            } elseif ('' == $new && $old) {
                delete_post_meta($post_id,'supermag_sidebar_layout', $old);
            }
        }
    }
endif;
add_action('save_post', 'supermag_save_sidebar_layout');

/**
 * Custom Metabox for Related Posts
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_add_metabox_1') ) :
    function supermag_add_metabox_1() {
        add_meta_box(
            'supermag-related-posts-display', // $id
            __( 'Related Posts Options', 'supermag' ), // $title
            'supermag_related_posts_display_callback', // $callback
            'post', // $page
            'normal', // $context
            'high'
        ); // $priority
    }
endif;
add_action('add_meta_boxes', 'supermag_add_metabox_1');

/**
 * Supermag sidebar layout options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_related_posts_check_options') ) :
    function supermag_related_posts_check_options() {
        $supermag_related_posts_check_options = array(
            'supermag-related-posts-show-image' => array(
                'value'     => 'supermag-related-posts-show-image',
                'title' => __( 'Show image', 'supermag' )
            ),
            'supermag-related-posts-first-featured' => array(
                'value'     => 'supermag-related-posts-first-featured',
                'title' => __( 'Enable first post featured', 'supermag' )
            ),
            'supermag-related-posts-show-categories' => array(
                'value'     => 'supermag-related-posts-show-categories',
                'title' => __( 'Show categories', 'supermag' )
            ),
            'supermag-related-posts-show-date' => array(
                'value' => 'supermag-related-posts-show-date',
                'title' => __( 'Show date', 'supermag' )
            ),
            'supermag-related-posts-show-author' => array(
                'value'     => 'supermag-related-posts-show-author',
                'title' => __( 'Show author', 'supermag' )
            ),
            'supermag-related-posts-show-comments' => array(
                'value'     => 'supermag-related-posts-show-comments',
                'title' => __( "Show number of comments", 'supermag' )
            )
        );
        return apply_filters( 'supermag_related_posts_check_options', $supermag_related_posts_check_options );
    }
endif;

/**
 * Callback function for reated post metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_related_posts_display_callback') ) :
    function supermag_related_posts_display_callback() {
        global $post;
        $supermag_related_posts_check_options = supermag_related_posts_check_options();
        wp_nonce_field( basename( __FILE__ ), 'supermag_related_posts_display_nonce' );

        $supermag_customizer_all_values = supermag_related_posts_data( $post->ID );

        $supermag_related_posts_display = esc_attr($supermag_customizer_all_values['supermag-related-posts-display']);
        $supermag_related_title = esc_html( $supermag_customizer_all_values['supermag-related-title'] );

        $supermag_related_posts_show_image = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-image'] );
        $supermag_related_posts_first_featured = esc_attr( $supermag_customizer_all_values['supermag-related-posts-first-featured'] );
        $supermag_related_posts_show_date = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-date'] );
        $supermag_related_posts_show_author = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-author'] );
        $supermag_related_posts_show_comments = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-comments'] );
        $supermag_related_posts_show_categories = esc_attr( $supermag_customizer_all_values['supermag-related-posts-show-categories'] );
        $supermag_related_posts_check_save_options = array(
            'supermag-related-posts-show-image' => $supermag_related_posts_show_image,
            'supermag-related-posts-first-featured' => $supermag_related_posts_first_featured,
            'supermag-related-posts-show-date' => $supermag_related_posts_show_date,
            'supermag-related-posts-show-author' => $supermag_related_posts_show_author,
            'supermag-related-posts-show-comments' => $supermag_related_posts_show_comments,
            'supermag-related-posts-show-categories' => $supermag_related_posts_show_categories,
        );
        $supermag_related_posts_number = absint( $supermag_customizer_all_values['supermag-related-posts-number'] );
        $supermag_related_posts_column_number = absint( $supermag_customizer_all_values['supermag-related-posts-column-number'] );
        $supermag_related_posts_content_words = absint( $supermag_customizer_all_values['supermag-related-posts-content-words'] );
        ?>
        <table class="form-table page-meta-box">
            <tr class="supermag_related_posts_options_show">
                <td>
                    <div>
                        <input class="supermag-related-posts-display" id="default-related-posts" type="radio" name="supermag-related-posts-display" value="default-related-posts" <?php checked( 'default-related-posts', $supermag_related_posts_display ); ?> />
                        <label class="description" for="default-related-posts">
                            <?php _e('Default As Global Option','supermag')?>
                        </label>
                    </div>
                    <?php
                    $supermag_related_posts_display_options = supermag_related_posts_display_options();
                    foreach ($supermag_related_posts_display_options as $key=>$field) {
                        ?>
                        <div>
                            <input class="supermag-related-posts-display" id="<?php echo esc_attr($key); ?>" type="radio" name="supermag-related-posts-display" value="<?php echo esc_attr($key); ?>" <?php checked( $key, $supermag_related_posts_display ); ?> />
                            <label class="description" for="<?php echo esc_attr($key); ?>">
                                <?php echo esc_attr( $field); ?>
                            </label>
                        </div>
                        <?php
                    } // end foreach
                    ?>
                    <div class="clear"></div>
                    <div>
                        <label class="description" for="supermag-related-title">
                            <?php _e( 'Related posts title', 'supermag' ); ?>:
                        </label>
                        <input id="supermag-related-title" type="text" name="supermag-related-title" class="widefat" value="<?php echo esc_attr( $supermag_related_title ); ?>" />
                    </div>
                </td>
            </tr>
            <?php if( 'below-related-posts' == $supermag_related_posts_display ) {
                $class = 'supermag_related_posts_options_show';
            }
            else{
                $class = 'supermag_related_posts_options_hide';
            }?>
            <style>
                .supermag_related_posts_options_show{
                    display: block;
                }
                .supermag_related_posts_options_hide{
                    display: none;
                }
            </style>
            <script type="text/javascript">
                jQuery(document).ready(function($){
                    $('.supermag-related-posts-display').click(function() {
                        if($('#below-related-posts').is(':checked')) {
                            $('#supermag_related_posts_options_tr').removeClass('supermag_related_posts_options_hide');
                            $('#supermag_related_posts_options_tr').addClass('supermag_related_posts_options_show');
                        }
                        else{
                            $('#supermag_related_posts_options_tr').removeClass('supermag_related_posts_options_show');
                            $('#supermag_related_posts_options_tr').addClass('supermag_related_posts_options_hide');
                        }
                    });
                });
            </script>
            <tr id="supermag_related_posts_options_tr" class="<?php echo esc_attr( $class ); ?>">
                <td>
                    <em class="f13"><?php  _e( "Only apply when you choose Below Content in above options", 'supermag' )?></em>
                    <?php
                    foreach ($supermag_related_posts_check_options as $key => $supermag_related_posts_option) {
                        if( 1 == $supermag_related_posts_check_save_options[$key] ){
                            $checked = checked( 1, 1, 0 );
                        }
                        else{
                            $checked = checked( 1, 0, 0 );
                        }
                        ?>
                        <div style="margin-right:30px;width: 100%">
                            <input id="<?php echo $supermag_related_posts_option['value']; ?>" type="checkbox" name="<?php echo esc_attr( $key );?>" <?php echo $checked?> />
                            <label class="description" for="<?php echo $supermag_related_posts_option['value']; ?>">
                                <?php echo esc_attr( $supermag_related_posts_option['title'] ); ?>
                            </label>
                        </div>
                        <?php
                    } /*end foreach*/
                    ?>
                    <div style="margin-right:30px;width: 100%">
                        <label class="description" for="supermag-related-posts-number">
                            <?php _e( 'Number of posts to show', 'supermag' ); ?>
                        </label>
                        <input id="supermag-related-posts-number" class="widefat" type="number" name="supermag-related-posts-number" value="<?php echo $supermag_related_posts_number; ?>" />
                    </div>
                    <div style="margin-right:30px;width: 100%">
                        <label class="description" for="supermag-related-posts-content-words">
                            <?php _e( 'Number of words in contents', 'supermag' ); ?>
                        </label>
                        <input id="supermag-related-posts-content-words" class="widefat" type="number" name="supermag-related-posts-content-words" value="<?php echo $supermag_related_posts_content_words; ?>" />
                    </div>
                    <?php
                    $supermag_column_arrays = array( 1,2,3,4 );
                    ?>
                    <div style="margin-right:30px;width: 100%">
                        <label class="description" for="supermag-related-posts-column-number">
                            <?php _e( 'Select number of columns', 'supermag' ); ?>
                        </label>
                        <select class="widefat" id="supermag-related-posts-column-number" name="supermag-related-posts-column-number">
                            <?php
                            foreach( $supermag_column_arrays as $supermag_column_array ){
                                echo ' <option value="'.$supermag_column_array.'"'.selected( $supermag_related_posts_column_number, $supermag_column_array, 0).'>'.$supermag_column_array.'</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="clear"></div>
                </td>
            </tr>
        </table>

    <?php }
endif;

/**
 * Save the custom metabox data for related posts
 * @hooked to save_post hook
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
function supermag_save_related_posts_layout( $post_id ) {
    global $post;
    $supermag_related_posts_check_options = supermag_related_posts_check_options();

    // Verify the nonce before proceeding.
    if ( !isset( $_POST[ 'supermag_related_posts_display_nonce' ] ) || !wp_verify_nonce( $_POST[ 'supermag_related_posts_display_nonce' ], basename( __FILE__ ) ) )
        return;

    // Stop WP from clearing custom fields on autosave
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE)
        return;

    if ('page' == $_POST['post_type']) {
        if (!current_user_can( 'edit_page', $post_id ) )
            return $post_id;
    } elseif (!current_user_can( 'edit_post', $post_id ) ) {
        return $post_id;
    }

    $new = sanitize_text_field($_POST['supermag-related-posts-display']);
    $old = get_post_meta( $post_id, 'supermag-related-posts-display', true);

    //Execute this saving function
    if ($new && $new != $old) {
        update_post_meta($post_id, 'supermag-related-posts-display', $new);
    } elseif ('' == $new && $old) {
        delete_post_meta($post_id,'supermag-related-posts-display', $old);
    }

    foreach ($supermag_related_posts_check_options as $key => $field) {
        $old = get_post_meta( $post_id, $key, true);
        $new = 0;
        if( isset( $_POST[$key] )){
            $new = 1;
        }
        update_post_meta($post_id, $key, $new);
        //echo $supermag_related_posts_meta_first_featured = get_post_meta( $post_id, 'supermag-related-posts-first-featured', true );

    }

    if( isset( $_POST['supermag-related-posts-number'] )){
        $old = get_post_meta( $post_id, 'supermag-related-posts-number', true);
        $new = absint($_POST['supermag-related-posts-number']);
        if ($new && $new != $old) {
            update_post_meta($post_id, 'supermag-related-posts-number', $new);
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id,'supermag-related-posts-number', $old);
        }
    }

    if( isset( $_POST['supermag-related-posts-content-words'] )){
        $old = get_post_meta( $post_id, 'supermag-related-posts-content-words', true);
        $new = absint($_POST['supermag-related-posts-content-words']);
        if ($new && $new != $old) {
            update_post_meta( $post_id, 'supermag-related-posts-content-words', $new );
        } elseif ('' == $new && $old) {
            delete_post_meta( $post_id,'supermag-related-posts-content-words', $old );
        }
    }

    if( isset( $_POST['supermag-related-title'] )){
        $old = get_post_meta( $post_id, 'supermag-related-title', true);
        $new = sanitize_text_field( $_POST['supermag-related-title'] );
        if ($new && $new != $old) {
            update_post_meta( $post_id, 'supermag-related-title', $new );
        } elseif ('' == $new && $old) {
            delete_post_meta( $post_id,'supermag-related-title', $old );
        }
    }

    if( isset( $_POST['supermag-related-posts-column-number'] )){
        $old = get_post_meta( $post_id, 'supermag-related-posts-column-number', true);
        $new = absint($_POST['supermag-related-posts-column-number']);
        if ($new && $new != $old) {
            update_post_meta( $post_id, 'supermag-related-posts-column-number', $new );
        } elseif ('' == $new && $old) {
            delete_post_meta( $post_id,'supermag-related-posts-column-number', $old );
        }
    }
}
add_action('save_post', 'supermag_save_related_posts_layout');

/**
 * Video meta box
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if( !function_exists( 'supermag_add_video_metabox' )):
    function supermag_add_video_metabox() {
        add_meta_box(
            'supermag_video_meta', // $id
            __( 'Featured Video', 'supermag' ), // $title
            'supermag_featured_video_callback', // $callback
            'post', // $page
            'side', // $context
            'low'
        ); // $priority
    }
endif;
add_action('add_meta_boxes', 'supermag_add_video_metabox');

/**
 * Callback function for metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_featured_video_callback') ) :
    function supermag_featured_video_callback(){
        global $post;
        $supermag_video_url = get_post_meta( $post->ID, 'supermag_video_url', true );
        $supermag_replace_featured_image = get_post_meta( $post->ID, 'supermag_replace_featured_image', true );
        $supermag_video_autoplay = get_post_meta( $post->ID, 'supermag_video_autoplay', true );
        wp_nonce_field( basename( __FILE__ ), 'supermag_video_url_nonce' );
        ?>
        <table class="form-table page-meta-box">
            <tr>
                <td>
                    <label class="description" for="supermag_video_url">
                        <?php _e( 'Enter Video URL', 'supermag' ); ?>
                    </label>
                    <input id="supermag_video_url" type="text" class="widefat" name="supermag_video_url" value="<?php echo esc_url( $supermag_video_url );?>" />
                    <br />
                    <small>
                        <?php
                        printf(__('Please enter youtube or vimeo video url with video ID. Youtube Example %1$s or Vimeo Example %2$s', 'supermag'),
                            "https://www.youtube.com/embed/[video-id] eg: <br /><code>https://www.youtube.com/embed/tyFzhpyHnUI</code><br />",
                            "https://player.vimeo.com/video/[video-id] eg: <br /><code>https://player.vimeo.com/video/152773407</code>")
                        ?>
                    </small>
                </td>
            </tr>
            <tr>
                <td>
                    <input id="supermag_replace_featured_image" type="checkbox" name="supermag_replace_featured_image" <?php checked( 1, $supermag_replace_featured_image ); ?> />
                    <label class="description" for="supermag_replace_featured_image">
                        <?php _e( 'Replace Featured Image In Single Post', 'supermag' ); ?>
                    </label>
                </td>
            </tr>
            <tr>
                <td>
                    <input id="supermag_video_autoplay" type="checkbox" name="supermag_video_autoplay" <?php checked( 1, $supermag_video_autoplay ); ?> />
                    <label class="description" for="supermag_video_autoplay">
                        <?php _e( 'Autoplay Video', 'supermag' ); ?>
                    </label>
                </td>
            </tr>
        </table>
    <?php
    }
endif;

/**
 * save the custom metabox data
 * @hooked to save_post hook
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_save_video_url') ) :
    function supermag_save_video_url( $post_id ) {

        // Verify the nonce before proceeding.
        if ( !isset( $_POST[ 'supermag_video_url_nonce' ] ) || !wp_verify_nonce( $_POST[ 'supermag_video_url_nonce' ], basename( __FILE__ ) ) )
            return;

        // Stop WP from clearing custom fields on autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE)
            return;

        if ('page' == $_POST['post_type']) {
            if (!current_user_can( 'edit_page', $post_id ) )
                return $post_id;
        } elseif (!current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }

        //Execute this saving function
        if(isset($_POST['supermag_video_url'])){
            $old = get_post_meta( $post_id, 'supermag_video_url', true);
            $new = esc_url_raw( $_POST['supermag_video_url'] );
            if ($new && $new != $old) {
                update_post_meta($post_id, 'supermag_video_url', $new);
            } elseif ('' == $new && $old) {
                delete_post_meta($post_id,'supermag_video_url', $old);
            }
        }
        if( isset( $_POST['supermag_replace_featured_image'] ) && !empty( $_POST['supermag_replace_featured_image'] )){
            update_post_meta($post_id, 'supermag_replace_featured_image', 1);
        }
        else{
            update_post_meta($post_id, 'supermag_replace_featured_image', '');
        }
        if( isset( $_POST['supermag_video_autoplay'] ) && !empty( $_POST['supermag_video_autoplay'] )){
            update_post_meta($post_id, 'supermag_video_autoplay', 1);
        }
        else{
            update_post_meta($post_id, 'supermag_video_autoplay', '');
        }
    }
endif;
add_action('save_post', 'supermag_save_video_url');


/**
 * Supermag Other options
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return array
 *
 */
if ( !function_exists('supermag_featured_image_display_options') ) :
    function supermag_featured_image_display_options() {
        $supermag_featured_image_display_options = array(
            'default-featured-image' => array(
                'value'     => 'default-featured-image',
                'title' => __( 'Default As Global Option', 'supermag' )
            ),
            'left-image' => array(
                'value'     => 'left-image',
                'title' => __( 'Left Image', 'supermag' )
            ),
            'large-image' => array(
                'value'     => 'large-image',
                'title' => __( 'Large Image', 'supermag' )
            ),
            'no-image' => array(
                'value'     => 'no-image',
                'title' => __( 'No Image', 'supermag' )
            )
        );
        return apply_filters( 'supermag_featured_image_display_options', $supermag_featured_image_display_options );
    }
endif;

/**
 * Custom Metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if( !function_exists( 'supermag_others_metabox' )):
    function supermag_others_metabox() {
        add_meta_box(
            'supermag_others_metabox', // $id
            __( ' Other Options', 'supermag' ), // $title
            'supermag_others_metabox_callback', // $callback
            'post', // $page
            'normal', // $context
            'high'
        ); // $priority

        add_meta_box(
            'supermag_others_metabox', // $id
            __( ' Other Options ', 'supermag' ), // $title
            'supermag_others_metabox_callback', // $callback
            'page', // $page
            'normal', // $context
            'high'
        ); // $priority
    }
endif;
add_action('add_meta_boxes', 'supermag_others_metabox');

/**
 * Callback function for metabox
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_others_metabox_callback') ) :
    function supermag_others_metabox_callback(){
        global $post;
        $supermag_featured_image_display_options = supermag_featured_image_display_options();
        $supermag_featured_image_display_option = 'default-featured-image';
        $supermag_featured_image_display_option_meta = get_post_meta( $post->ID, 'supermag_featured_image_display_option', true );
        if( !supermag_is_null_or_empty($supermag_featured_image_display_option_meta) ){
            $supermag_featured_image_display_option = $supermag_featured_image_display_option_meta;
        }
        wp_nonce_field( basename( __FILE__ ), 'supermag_others_meta_nonce' );
        ?>
        <table class="form-table page-meta-box">
            <tr>
                <td colspan="4"><h4><?php _e( ' Feature Image Option', 'supermag' ); ?></h4></td>
            </tr>
            <tr>
                <td>
                    <?php
                    foreach ($supermag_featured_image_display_options as $key=>$field) {
                        ?>
                        <div>
                            <input class="supermag_featured_image_display_option" id="<?php echo esc_attr($key); ?>" type="radio" name="supermag_featured_image_display_option" value="<?php echo esc_attr($key); ?>" <?php checked( $key, $supermag_featured_image_display_option ); ?> />
                            <label class="description" for="<?php echo esc_attr($key); ?>">
                                <?php echo esc_attr( $field['title']); ?>
                            </label>
                        </div>
                    <?php } // end foreach
                    ?>
                    <div class="clear"></div>
                </td>
            </tr>
        </table>
    <?php
}
endif;

/**
 * save the custom metabox data
 * @hooked to save_post hook
 *
 * @since SuperMag 1.0.0
 *
 * @param null
 * @return void
 *
 */
if ( !function_exists('supermag_save_others_meta') ) :
    function supermag_save_others_meta( $post_id ) {

        // Verify the nonce before proceeding.
        if ( !isset( $_POST[ 'supermag_others_meta_nonce' ] ) || !wp_verify_nonce( $_POST[ 'supermag_others_meta_nonce' ], basename( __FILE__ ) ) )
            return;

        // Stop WP from clearing custom fields on autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE)
            return;

        if ('page' == $_POST['post_type']) {
            if (!current_user_can( 'edit_page', $post_id ) )
                return $post_id;
        } elseif (!current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }

        //Execute this saving function
        if( isset( $_POST['supermag_featured_image_display_option'] )){
            $old = get_post_meta( $post_id, 'supermag_featured_image_display_option', true );
            $new = esc_attr( $_POST['supermag_featured_image_display_option'] );
            if ($new && $new != $old) {
                update_post_meta( $post_id, 'supermag_featured_image_display_option', $new );
            } elseif ('' == $new && $old) {
                delete_post_meta( $post_id,'supermag_featured_image_display_option', $old );
            }
        }
    }
endif;
add_action('save_post', 'supermag_save_others_meta');