<?php
/**
 * Custom author
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
if ( ! class_exists( 'supermag_author_widget' ) ) :
    /**
     * Class for adding author widget
     * A new way to add author
     * @package Acme Themes
     * @subpackage SuperMag
     * @since 1.1.0
     */
    class supermag_author_widget extends WP_Widget {
        /*defaults values for fields*/
        private $defaults = array(
            'supermag_author_title' => '',
            'supermag_author_image' => '',
            'supermag_author_link'  => '',
            'supermag_author_new_window' => 1,
            'supermag_author_short_disc'  => '',
        );
        function __construct() {
            parent::__construct(
            /*Base ID of your widget*/
                'supermag_author',
                /*Widget name will appear in UI*/
                __('AT Author', 'supermag'),
                /*Widget description*/
                array( 'description' => __( 'Add author with different options.', 'supermag' ), )
            );
        }

        /*Widget Backend*/
        public function form( $instance ) {
            /*merging arrays*/
            $instance = wp_parse_args( (array) $instance, $this->defaults);
            $supermag_author_title  = esc_attr( $instance['supermag_author_title'] );
            $supermag_author_image  = esc_url( $instance['supermag_author_image'] );
            $supermag_author_link   = esc_url( $instance['supermag_author_link'] );
            $supermag_author_new_window = esc_attr( $instance['supermag_author_new_window'] );
            $supermag_author_short_disc = esc_attr( $instance['supermag_author_short_disc'] );
            ?>
            <p class="description">
                <?php
                _e('Note: Use square image. Recommended image size : 250 x 250', 'supermag' );
                ?>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_author_title' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_author_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_author_title' ); ?>" type="text" value="<?php echo esc_attr( $supermag_author_title ); ?>" />
            </p>
            <h4><?php _e( 'Author Image', 'supermag' ); ?></h4>
            <p>
                <label for="<?php echo $this->get_field_id('supermag_author_image'); ?>">
                    <?php _e( 'Select Author Image', 'supermag' ); ?>
                </label>
                <?php
                $supermag_display_none = '';
                if ( empty( $supermag_author_image ) ){
                    $supermag_display_none = ' style="display:none;" ';
                }
                ?>
                <span class="img-preview-wrap" <?php echo esc_attr( $supermag_display_none ); ?>>
                    <img class="widefat" src="<?php echo esc_url( $supermag_author_image ); ?>" alt="<?php _e( 'Image preview', 'supermag' ); ?>"  />
                </span><!-- .ad-preview-wrap -->
                <input type="text" class="widefat" name="<?php echo $this->get_field_name('supermag_author_image'); ?>" id="<?php echo $this->get_field_id('supermag_author_image'); ?>" value="<?php echo esc_url( $supermag_author_image ); ?>" />
                <input type="button" value="<?php _e( 'Upload Image', 'supermag' ); ?>" class="button media-image-upload" data-title="<?php _e( 'Select Author Image','supermag'); ?>" data-button="<?php _e( 'Select Author Image','supermag'); ?>"/>
                <input type="button" value="<?php _e( 'Remove Image', 'supermag' ); ?>" class="button media-image-remove" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_author_short_disc' ); ?>"><?php _e( 'Author Short Disc:', 'supermag' ); ?></label>
                <textarea class="widefat" id="<?php echo $this->get_field_id( 'supermag_author_short_disc' ); ?>" name="<?php echo $this->get_field_name( 'supermag_author_short_disc' ); ?>"><?php echo esc_attr( $supermag_author_short_disc ); ?></textarea>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_author_link' ); ?>"><?php _e( 'Link URL:', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_author_link' ); ?>" name="<?php echo $this->get_field_name( 'supermag_author_link' ); ?>" type="text" value="<?php echo esc_attr( $supermag_author_link ); ?>" />
            </p>
            <p>
                <input id="<?php echo $this->get_field_id( 'supermag_author_new_window' ); ?>" name="<?php echo $this->get_field_name( 'supermag_author_new_window' ); ?>" type="checkbox" <?php checked( 1 == $supermag_author_new_window ? $instance['supermag_author_new_window'] : 0); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_author_new_window' ); ?>"><?php _e( 'Open in new window', 'supermag' ); ?></label>
            </p>
            <hr />
            <?php
        }

        /**
         * Function to Updating widget replacing old instances with new
         *
         * @access public
         * @since 1.0
         *
         * @param array $new_instance new arrays value
         * @param array $old_instance old arrays value
         * @return array
         *
         */
        function update( $new_instance, $old_instance ) {
            $instance = $old_instance;
            $instance['supermag_author_title'] = ( isset( $new_instance['supermag_author_title'] ) ) ?  sanitize_text_field( $new_instance['supermag_author_title'] ): '';
            $instance['supermag_author_image'] = ( isset( $new_instance['supermag_author_image'] ) ) ?  esc_url( $new_instance['supermag_author_image'] ): '';
            $instance['supermag_author_link'] = ( isset( $new_instance['supermag_author_link'] ) ) ?  esc_url( $new_instance['supermag_author_link'] ): '';
            $instance['supermag_author_short_disc'] = ( isset( $new_instance['supermag_author_short_disc'] ) ) ?  wp_kses_post( $new_instance['supermag_author_short_disc'] ): '';
            $instance['supermag_author_new_window'] = isset($new_instance['supermag_author_new_window'])? 1 : 0;

            return $instance;
        }

        /**
         * Function to Creating widget front-end. This is where the action happens
         *
         * @access public
         * @since 1.0
         *
         * @param array $args widget setting
         * @param array $instance saved values
         * @return void
         *
         */
        function widget( $args, $instance ) {
            $instance = wp_parse_args( (array) $instance, $this->defaults);
            $supermag_author_title      = apply_filters( 'widget_title', $instance['supermag_author_title'], $instance, $this->id_base );
            $supermag_author_image      = esc_url( $instance['supermag_author_image'] );
            $supermag_author_link       = esc_url( $instance['supermag_author_link'] );
            $supermag_author_new_window = esc_attr( $instance['supermag_author_new_window'] );
            $supermag_author_short_disc = wp_kses_post( $instance['supermag_author_short_disc'] );

            echo $args['before_widget'];

            if ( !empty($supermag_author_title) ) {
                echo $args['before_title'] . $supermag_author_title . $args['after_title'];
            }
            $ad_content_image = '';
            if ( ! empty( $supermag_author_image ) ) {
                /*creating add*/
                $img_html = '<img src="' . $supermag_author_image . '" alt="author" />';
                $link_open = '';
                $link_close = '';
                if ( ! empty( $supermag_author_link ) ) {
                    $target_text = ( 1 == $supermag_author_new_window ) ? ' target="_blank" ' : '';
                    $link_open = '<a href="' .  $supermag_author_link . '" ' . $target_text . '>';
                    $link_close = '</a>';
                }
                $ad_content_image = $link_open . $img_html .  $link_close.$supermag_author_short_disc;
            }
            if ( !empty( $ad_content_image ) ) {
                echo '<div class="supermag-author-widget">';
                echo $ad_content_image;
                echo '</div>';
            }
            echo $args['after_widget'];
        }
    }
endif;

if ( ! function_exists( 'supermag_author_widget' ) ) :
    /**
     * Function to Register and load the widget
     *
     * @since 1.0
     *
     * @param null
     * @return void
     *
     */
    function supermag_author_widget() {
        register_widget( 'supermag_author_widget' );
    }
endif;
add_action( 'widgets_init', 'supermag_author_widget' );