<?php
/**
 * Class for adding category column
 *
 * @package Acme Themes
 * @subpackage SuperMag
 * @since 1.0.0
 */
if ( ! class_exists( 'supermag_cat_col' ) ) {

    class supermag_cat_col extends WP_Widget {
        /*defaults values for fields*/
        private $defaults = array(
            'supermag_cat_title_one'    => '',
            'supermag_cat_one'          => -1,
            'supermag_cat_title_two'    => '',
            'supermag_cat_two'          => -1,
            'supermag_cat_title_three'  => '',
            'supermag_cat_three'        => -1,
            'supermag_cat_title_four'   => '',
            'supermag_cat_four'         => -1,
            'supermag_number'           => 5,
            'supermag_column_number'    => 3,
            'supermag_enable_title_link'=> 1,
            'supermag_show_image'       => 1,
            'supermag_show_cat'         => 1,
            'supermag_show_date'        => 1,
            'supermag_show_author'      => 1,
            'supermag_show_comment'     => 1,
            'supermag_content_words'    => 8,
            'supermag_post_col_normal_image_layout' => 'large'
        );

        function __construct() {
            parent::__construct(
            /*Base ID of your widget*/
                'supermag_cat_col',
                /*Widget name will appear in UI*/
                __('AT Categories Column', 'supermag'),
                /*Widget description*/
                array( 'description' => __( 'Show two or more categories in columns.', 'supermag' ), )
            );
        }

        /*Widget Backend*/
        public function form( $instance ) {
            $instance = wp_parse_args( (array) $instance, $this->defaults);
            /*category 1 */
            $supermag_cat_title_one = esc_attr( $instance['supermag_cat_title_one'] );
            $supermag_selected_cat_one = esc_attr( $instance['supermag_cat_one'] );

            /*category 2 */
            $supermag_cat_title_two = esc_attr( $instance['supermag_cat_title_two'] );
            $supermag_selected_cat_two = esc_attr( $instance['supermag_cat_two'] );

            /*category 3 */
            $supermag_cat_title_three = esc_attr( $instance['supermag_cat_title_three'] );
            $supermag_selected_cat_three = esc_attr( $instance['supermag_cat_three'] );

            /*category 4 */
            $supermag_cat_title_four =  esc_attr( $instance['supermag_cat_title_four'] );
            $supermag_selected_cat_four = esc_attr( $instance['supermag_cat_four'] );

            /*post number */
            $supermag_number = absint( $instance['supermag_number'] );

            /*comumn number*/
            $supermag_column_arrays = array( 1,2,3,4 );
            $supermag_column_number = absint( $instance['supermag_column_number'] );

            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link'] );

            /*Show image*/
            $supermag_show_image = esc_attr( $instance['supermag_show_image'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );

            $supermag_content_words    =absint( $instance['supermag_content_words'] );

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = $instance['supermag_post_col_normal_image_layout'];
            $choices = supermag_get_image_sizes_options();

            ?>
            <p class="description">
                <?php
                _e('You can select one or more categories to display them in column.', 'supermag' );
                ?>
            </p>
            <div class="custom-theme-accordion">
                <h4 class="accordion-toggle opened"><?php _e( 'Category one', 'supermag' ); ?></h4>
                <div class="accordion-content active">
                    <!--cat 1 start-->
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_cat_title_one' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title_one' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title_one' ); ?>" type="text" value="<?php echo $supermag_cat_title_one; ?>" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id('supermag_cat_one'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                        <?php
                        $supermag_dropown_cat = array(
                            'show_option_none'   => __('Select','supermag'),
                            'orderby'            => 'name',
                            'order'              => 'asc',
                            'show_count'         => 1,
                            'hide_empty'         => 1,
                            'echo'               => 1,
                            'selected'           => $supermag_selected_cat_one,
                            'hierarchical'       => 1,
                            'name'               => $this->get_field_name('supermag_cat_one'),
                            'id'                 => $this->get_field_name('supermag_cat_one'),
                            'class'              => 'widefat',
                            'taxonomy'           => 'category',
                            'hide_if_empty'      => false,
                        );
                        wp_dropdown_categories($supermag_dropown_cat);
                        ?>
                    </p>
                    <!--cat 1 end-->
                </div>
            </div>
            <h4 class="accordion-toggle"><?php _e( 'Category two', 'supermag' ); ?></h4>
            <div class="accordion-content">
                <!--cat 2 start-->
                <p>
                    <label for="<?php echo $this->get_field_id( 'supermag_cat_title_two' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title_two' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title_two' ); ?>" type="text" value="<?php echo $supermag_cat_title_two; ?>" />
                </p>
                <p>
                    <label for="<?php echo $this->get_field_id('supermag_cat_two'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                    <?php
                    $supermag_dropown_cat = array(
                        'show_option_none'   => __('Select','supermag'),
                        'orderby'            => 'name',
                        'order'              => 'asc',
                        'show_count'         => 1,
                        'hide_empty'         => 1,
                        'echo'               => 1,
                        'selected'           => $supermag_selected_cat_two,
                        'hierarchical'       => 1,
                        'name'               => $this->get_field_name('supermag_cat_two'),
                        'id'                 => $this->get_field_name('supermag_cat_two'),
                        'class'              => 'widefat',
                        'taxonomy'           => 'category',
                        'hide_if_empty'      => false,
                    );
                    wp_dropdown_categories($supermag_dropown_cat);
                    ?>
                </p>
                <!--cat 2 end-->
            </div>
            <h4 class="accordion-toggle"><?php _e( 'Category three', 'supermag' ); ?></h4>
            <div class="accordion-content">
                <!--cat 3 start-->
                <p>
                    <label for="<?php echo $this->get_field_id( 'supermag_cat_title_three' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title_three' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title_three' ); ?>" type="text" value="<?php echo $supermag_cat_title_three; ?>" />
                </p>
                <p>
                    <label for="<?php echo $this->get_field_id('supermag_cat_three'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                    <?php
                    $supermag_dropown_cat = array(
                        'show_option_none'   => __('Select','supermag'),
                        'orderby'            => 'name',
                        'order'              => 'asc',
                        'show_count'         => 1,
                        'hide_empty'         => 1,
                        'echo'               => 1,
                        'selected'           => $supermag_selected_cat_three,
                        'hierarchical'       => 1,
                        'name'               => $this->get_field_name('supermag_cat_three'),
                        'id'                 => $this->get_field_name('supermag_cat_three'),
                        'class'              => 'widefat',
                        'taxonomy'           => 'category',
                        'hide_if_empty'      => false,
                    );
                    wp_dropdown_categories($supermag_dropown_cat);
                    ?>
                </p>
                <!--cat 3 end-->
            </div>
            <h4 class="accordion-toggle"><?php _e( 'Category four', 'supermag' ); ?></h4>
            <div class="accordion-content">
                <!--cat 4 start-->
                <p>
                    <label for="<?php echo $this->get_field_id( 'supermag_cat_title_four' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title_four' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title_four' ); ?>" type="text" value="<?php echo $supermag_cat_title_four; ?>" />
                </p>
                <p>
                    <label for="<?php echo $this->get_field_id('supermag_cat_four'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                    <?php
                    $supermag_dropown_cat = array(
                        'show_option_none'   => __('Select','supermag'),
                        'orderby'            => 'name',
                        'order'              => 'asc',
                        'show_count'         => 1,
                        'hide_empty'         => 1,
                        'echo'               => 1,
                        'selected'           => $supermag_selected_cat_four,
                        'hierarchical'       => 1,
                        'name'               => $this->get_field_name('supermag_cat_four'),
                        'id'                 => $this->get_field_name('supermag_cat_four'),
                        'class'              => 'widefat',
                        'taxonomy'           => 'category',
                        'hide_if_empty'      => false,
                    );
                    wp_dropdown_categories($supermag_dropown_cat);
                    ?>
                </p>
                <!--cat 4 end-->
            </div>

            <hr />
            <h3><?php _e( 'Display options', 'supermag' ); ?></h3>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_number' ); ?>"><?php _e( 'Number of posts to show:', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_number' ); ?>" type="number" value="<?php echo $supermag_number; ?>" size="3" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_column_number' ); ?>"><?php _e( 'Select number of columns', 'supermag' ); ?></label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_column_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_column_number' ); ?>">
                    <?php
                    foreach( $supermag_column_arrays as $supermag_column_array ){
                        echo ' <option value="'.$supermag_column_array.'" '.selected( $supermag_column_number, $supermag_column_array, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>" name="<?php echo $this->get_field_name( 'supermag_enable_title_link' ); ?>" type="checkbox" <?php checked( 1, esc_attr( $supermag_enable_title_link ), 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>"><?php _e( 'Enable link in main title' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_image' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_image' ); ?>" type="checkbox" <?php checked( 1,  $supermag_show_image , 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_image' ); ?>"><?php _e( 'Show image' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_cat' ); ?>" type="checkbox" <?php checked( 1,  $supermag_show_cat, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>"><?php _e( 'Show categories' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_date' ); ?>" type="checkbox" <?php checked( 1, $supermag_show_date, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_author' ); ?>" type="checkbox" <?php checked( 1, $supermag_show_author, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>"><?php _e( 'Show author' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_comment' ); ?>" type="checkbox" <?php checked( 1, $supermag_show_comment, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>"><?php _e( 'Show number of comments' ,'supermag'); ?></label>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_content_words' ); ?>"><?php _e( 'Number of words in contents', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_content_words' ); ?>" name="<?php echo $this->get_field_name( 'supermag_content_words' ); ?>" type="number" value="<?php echo $supermag_content_words; ?>" />
                <br />
                <small><?php _e('Enter 0 for not showing content','supermag')?></small>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php _e( 'Normal Featured Post Image', 'supermag' ); ?>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>" name="<?php echo $this->get_field_name( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_post_col_normal_image_layout, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
        <?php
        }

        /**
         * Function to Updating widget replacing old instances with new
         *
         * @access public
         * @since 1.0
         *
         * @param array $new_instance new arrays value
         * @param array $old_instance old arrays value
         * @return array
         *
         */
        public function update( $new_instance, $old_instance ) {
            $instance = array();

            /*cat 1 start*/
            $instance['supermag_cat_title_one'] = ( isset( $new_instance['supermag_cat_title_one'] ) ) ?  sanitize_text_field( $new_instance['supermag_cat_title_one'] ): '';
            $instance['supermag_cat_one'] = ( isset( $new_instance['supermag_cat_one'] ) ) ?  esc_attr( $new_instance['supermag_cat_one'] ): '';
            /*cat 1 end*/

            /*cat 2 start*/
            $instance['supermag_cat_title_two'] = ( isset( $new_instance['supermag_cat_title_two'] ) ) ?  sanitize_text_field($new_instance['supermag_cat_title_two']): '';
            $instance['supermag_cat_two'] = ( isset( $new_instance['supermag_cat_two'] ) ) ?  esc_attr($new_instance['supermag_cat_two']): '';
            /*cat 2 end*/

            /*cat 3 start*/
            $instance['supermag_cat_title_three'] = ( isset( $new_instance['supermag_cat_title_three'] ) ) ?  sanitize_text_field( $new_instance['supermag_cat_title_three'] ): '';
            $instance['supermag_cat_three'] = ( isset( $new_instance['supermag_cat_three'] ) ) ?  esc_attr( $new_instance['supermag_cat_three'] ): '';
            /*cat 3 end*/

            /*cat 4 start*/
            $instance['supermag_cat_title_four'] = ( isset( $new_instance['supermag_cat_title_four'] ) ) ?  sanitize_text_field( $new_instance['supermag_cat_title_four'] ): '';
            $instance['supermag_cat_four'] = ( isset( $new_instance['supermag_cat_four'] ) ) ?  esc_attr( $new_instance['supermag_cat_four'] ): '';
            /*cat 4 end*/

            $instance['supermag_enable_title_link'] = isset($new_instance['supermag_enable_title_link'])? 1 : 0;
            $instance['supermag_number'] = isset($new_instance['supermag_number'])? absint( $new_instance['supermag_number'] ) : 5;
            $instance['supermag_column_number'] = isset($new_instance['supermag_column_number'])? absint( $new_instance['supermag_column_number'] ) : 3;
            $instance['supermag_show_image'] = isset($new_instance['supermag_show_image'])? 1 : 0;
            $instance['supermag_show_cat'] = isset($new_instance['supermag_show_cat'])? 1 : 0;
            $instance['supermag_show_date'] = isset($new_instance['supermag_show_date'])? 1 : 0;
            $instance['supermag_show_author'] = isset($new_instance['supermag_show_author'])? 1 : 0;
            $instance['supermag_show_comment'] = isset($new_instance['supermag_show_comment'])? 1 : 0;
            $instance['supermag_content_words'] = isset($new_instance['supermag_content_words'])? absint( $new_instance['supermag_content_words'] ) : 8;
            $instance['supermag_post_col_normal_image_layout'] = isset($new_instance['supermag_post_col_normal_image_layout'])? esc_attr( $new_instance['supermag_post_col_normal_image_layout'] ) : 'large';

            return $instance;
        }

        /**
         * Function to Creating widget front-end. This is where the action happens
         *
         * @access public
         * @since 1.0
         *
         * @param array $args widget setting
         * @param array $instance saved values
         * @return void
         *
         */
        public function widget($args, $instance) {
            $instance = wp_parse_args( (array) $instance, $this->defaults);
            /*default widgets*/
            if( isset( $args['id'] ) ){
                $supermag_sidebar_id = $args['id'];
            }
            else{
                $supermag_sidebar_id = 'supermag-home';
            }
            $supermag_cat_arrays = array();
            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link'] );

            /*category 1 */
            $supermag_selected_cat_one = esc_attr( $instance['supermag_cat_one'] );
            $supermag_cat_title_one = !empty( $instance['supermag_cat_title_one'] ) ? esc_attr( $instance['supermag_cat_title_one'] ) : get_cat_name($supermag_selected_cat_one);

            $supermag_cat_title_one = apply_filters( 'widget_title', $supermag_cat_title_one, $instance, $this->id_base );
            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat_one  ){
		            $supermag_cat_title_one = "<a href='".esc_url( get_category_link( $supermag_selected_cat_one ) )."'>".$supermag_cat_title_one."</a>";
	            }
	            else{
		            $supermag_cat_title_one = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_cat_title_one."</a>";
	            }
            }

            if( -1 != $supermag_selected_cat_one ){
                $supermag_cat_arrays[] = array(
                    'id' => $supermag_selected_cat_one,
                    'title' => $supermag_cat_title_one,
                );
            }

            /*category 2 */
            $supermag_selected_cat_two = esc_attr( $instance['supermag_cat_two'] );
            $supermag_cat_title_two = !empty( $instance['supermag_cat_title_two'] ) ? esc_attr( $instance['supermag_cat_title_two'] ) : get_cat_name($supermag_selected_cat_two);
            $supermag_cat_title_two = apply_filters( 'widget_title', $supermag_cat_title_two, $instance, $this->id_base );

            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat_two  ){
		            $supermag_cat_title_two = "<a href='".esc_url( get_category_link( $supermag_selected_cat_two ) )."'>".$supermag_cat_title_two."</a>";
	            }
	            else{
		            $supermag_cat_title_two = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_cat_title_two."</a>";
	            }
            }

            if( -1 != $supermag_selected_cat_two ){
                $supermag_cat_arrays[] = array(
                    'id' => $supermag_selected_cat_two,
                    'title' => $supermag_cat_title_two
                );
            }

            /*category 3 */
            $supermag_selected_cat_three = esc_attr( $instance['supermag_cat_three'] );
            $supermag_cat_title_three = !empty( $instance['supermag_cat_title_three'] ) ? esc_attr( $instance['supermag_cat_title_three'] ) : get_cat_name($supermag_selected_cat_three);
            $supermag_cat_title_three = apply_filters( 'widget_title', $supermag_cat_title_three, $instance, $this->id_base );

            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat_three  ){
		            $supermag_cat_title_three = "<a href='".esc_url( get_category_link( $supermag_selected_cat_three ) )."'>".$supermag_cat_title_three."</a>";
	            }
	            else{
		            $supermag_cat_title_three = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_cat_title_three."</a>";
	            }
            }

            if( -1 != $supermag_selected_cat_three){
                $supermag_cat_arrays[] = array(
                    'id' => $supermag_selected_cat_three,
                    'title' => $supermag_cat_title_three
                );
            }

            /*category 4 */
            $supermag_selected_cat_four = esc_attr( $instance['supermag_cat_four'] );
            $supermag_cat_title_four = !empty( $instance['supermag_cat_title_four'] ) ? esc_attr( $instance['supermag_cat_title_four'] ) : get_cat_name( $supermag_selected_cat_four );
            $supermag_cat_title_four = apply_filters( 'widget_title', $supermag_cat_title_four, $instance, $this->id_base );

            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat_four  ){
		            $supermag_cat_title_four = "<a href='".esc_url( get_category_link( $supermag_selected_cat_four ) )."'>".$supermag_cat_title_four."</a>";
	            }
	            else{
		            $supermag_cat_title_four = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_cat_title_four."</a>";
	            }
            }

            if( -1 != $supermag_selected_cat_four ){
                $supermag_cat_arrays[] = array(
                    'id' => $supermag_selected_cat_four,
                    'title' => $supermag_cat_title_four
                );
            }

            /*post number */
            $supermag_number = absint( $instance['supermag_number'] );

            /*comumn number*/
            $supermag_column_number = absint( $instance['supermag_column_number'] );

            /*Show image*/
            $supermag_show_image = esc_attr( $instance['supermag_show_image'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );

            $supermag_content_words    = absint( $instance['supermag_content_words'] );

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = esc_attr( $instance['supermag_post_col_normal_image_layout'] );

            /**
             * Filter the arguments for the Recent Posts widget.
             *
             * @since 1.0.0
             *
             * @see WP_Query
             *
             */
            if ( !empty ( $supermag_cat_arrays ) ) :
                $supermag_featured_index = 1;

                if( 1 == $supermag_column_number ){
                    $supermag_column = 'acme-col-1';
                }
                elseif( 2 == $supermag_column_number ){
                    $supermag_column = 'acme-col-2';
                }
                elseif( 3 == $supermag_column_number ){
                    $supermag_column = 'acme-col-3';
                }
                elseif( 4 == $supermag_column_number ){
                    $supermag_column = 'acme-col-4';
                }
                else{
                    $supermag_column = 'acme-col-3';
                }

                if( 'supermag-home' != $supermag_sidebar_id ){
                    $supermag_other_class = 'supermag-except-home';
                }
                else{
                    $supermag_other_class = '';
                }

                echo $args['before_widget'];
                foreach($supermag_cat_arrays as $supermag_cat_array):
                    $supermag_cat_post_args = array(
                        'cat'                 => $supermag_cat_array['id'],
                        'posts_per_page'      => $supermag_number,
                        'no_found_rows'       => true,
                        'post_status'         => 'publish',
                        'ignore_sticky_posts' => true
                    );
                    $supermag_featured_query = new WP_Query( $supermag_cat_post_args );

                    if ($supermag_featured_query->have_posts()) :
                        ?>
                        <div class="<?php echo esc_attr($supermag_column); ?> <?php echo esc_attr( $supermag_sidebar_id ); ?>">
                        <?php
                        if ( $supermag_cat_array['title'] ) {
	                        if( -1 != $supermag_cat_array['id'] ){
		                        echo "<div class='at-cat-color-wrap-".$supermag_cat_array['id']."'>";
	                        }
	                        echo $args['before_title'] . $supermag_cat_array['title'] . $args['after_title'];

	                        if( -1 != $supermag_cat_array['id'] ){
		                        echo "</div>";
	                        }
                        }
                        ?>
                        <div class="featured-entries-col featured-entries featured-cat-col <?php echo esc_attr( $supermag_other_class );?>">
                            <?php
                            $supermag_featured_index_inner = 1;
                            while ( $supermag_featured_query->have_posts() ) :$supermag_featured_query->the_post();
                                $fix_class = '';
                                if( 1!= $supermag_column_number ){
                                    $fix_class = 'featured-post-main';
                                }
                                $supermag_list_classes = 'acme-col-1 '.$fix_class;
                                ?>
                                <div class="<?php echo esc_attr( $supermag_list_classes ); ?>">
                                    <?php if ( 1 == $supermag_show_image ) {
                                        ?>
                                        <figure class="widget-image">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                if( has_post_thumbnail() ):
                                                    the_post_thumbnail( $supermag_post_col_normal_image_layout );
                                                else:
                                                    ?>
                                                    <div class="no-image-widgets">
                                                        <?php
                                                        the_title( sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        if( !get_the_title() ){
                                                            the_date( '', sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php
                                                endif;
                                                ?>
                                            </a>
                                        </figure>
                                    <?php
                                    }
                                    ?>
                                    <div class="featured-desc">
                                        <?php
                                        if( 1 == $supermag_show_date || 1 == $supermag_show_author || 1 == $supermag_show_comment ) { ?>
                                            <div class="above-entry-meta">
                                                <?php
                                                if ( 1 == $supermag_show_date ){
                                                    $archive_year  = get_the_date('Y');
                                                    $archive_month = get_the_date('m');
                                                    $archive_day   = get_the_date('d');
                                                    ?>
                                                    <span>
                                                        <i class="fa fa-calendar"></i>
                                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                            <?php echo get_the_date(); ?>
                                                        </a>
                                                    </span>
                                                <?php
                                                }
                                                if( 1 == $supermag_show_author ) { ?>
                                                    <span><i class="fa fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
                                                <?php
                                                }
                                                if( 1 == $supermag_show_comment ){ ?>
                                                    <span><i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?></span>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        <?php
                                        }
                                        ?>
                                        <a href="<?php the_permalink()?>">
                                            <h4 class="title">
                                                <?php the_title(); ?>
                                            </h4>
                                        </a>
                                        <?php
                                        if( 0 != $supermag_content_words){
                                            $content = supermag_words_count( get_the_excerpt(), $supermag_content_words );
                                            echo '<div class="details">'.$content.'</div>';
                                        }
                                        
                                        if( 1 == $supermag_show_cat ){?>
                                            <div class="below-entry-meta">
                                                <?php supermag_list_category(); ?>
                                            </div>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                                $supermag_featured_index_inner++;
                            endwhile; ?>
                        </div>
                        </div>
                        <?php
                        // Reset the global $the_post as this query will have stomped on it
                        wp_reset_postdata();
                    endif;
                    echo supermag_col_clearfix( $supermag_column_number, $supermag_featured_index );
                    $supermag_featured_index++;
                endforeach;
                echo "<div class='clearfix'></div>";
                echo $args['after_widget'];
            endif;
        }
    } // Class supermag_cat_col ends here
}

/**
 * Function to Register and load the widget
 *
 * @since 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_cat_col' ) ) :

    function supermag_cat_col() {
        register_widget( 'supermag_cat_col' );
    }
endif;
add_action( 'widgets_init', 'supermag_cat_col' );
