<?php
/**
 * Class for adding Gallery Slider
 *
 * @package Acme Themes
 * @subpackage SuperMag
 * @since 1.0.0
 */
if ( ! class_exists( 'supermag_gallery_slider' ) ) {
    class supermag_gallery_slider extends WP_Widget {
        /*defaults values for fields*/
        private $defaults = array(
            'supermag_cat_title'        => 'Recent Posts',
            'supermag_cat'              => -1,
            'supermag_enable_title_link'=> 1,
            'supermag_auto_slide'       => 0,
            'supermag_show_cat'         => 0,
            'supermag_show_date'        => 1,
            'supermag_show_author'      => 1,
            'supermag_show_comment'     => 1,
            'supermag_content_words'    => 0,
            'supermag_column_number'    => 5,
            'supermag_slide_mode'       => 'horizontal',
            'supermag_slider_speed'     => 1200,
            'supermag_gallery_slide_image' => 'large',
            'supermag_gallery_thumb_image' => 'thumbnail'
        );

        function __construct() {
            parent::__construct(
            /*Base ID of your widget*/
                'supermag_gallery_slider',
                /*Widget name will appear in UI*/
                __('AT Gallery Slider', 'supermag'),
                /*Widget description*/
                array( 'description' => __( 'Unique Gallery Slider for Posts', 'supermag' ), )
            );
        }

        /*Widget Backend*/
        public function form( $instance ) {
            /*defaults values*/
            $instance = wp_parse_args( (array) $instance, $this->defaults );

            /*Main title*/
            $supermag_gallery_title = esc_attr( $instance['supermag_cat_title'] );

            /*selected cat*/
            $supermag_selected_cat = esc_attr( $instance['supermag_cat'] );

            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link'] );

            /*Auto*/
            $supermag_auto_slide = esc_attr( $instance['supermag_auto_slide'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );
            
            /*number of words in content*/
            $supermag_content_words    = absint( $instance['supermag_content_words'] );

            /*comumn number*/
            $supermag_column_arrays = array( 1,2,3,4,5,6 );
            $supermag_column_number = absint( $instance['supermag_column_number'] );

            /*Slider Mode*/
            $supermag_slide_mode_arrays = array(
                'horizontal'=>__('Horizontal','supermag'),
                'vertical'=>__('Vertical','supermag')
            );
            $supermag_slide_mode = sanitize_text_field( $instance['supermag_slide_mode'] );

            /* Slider Speed*/
            $supermag_slider_speed    = absint( $instance['supermag_slider_speed'] );

            /*gallery slide image*/
            $supermag_gallery_slide_image = $instance['supermag_gallery_slide_image'];

            /*gallery thumb image*/
            $supermag_gallery_thumb_image = $instance['supermag_gallery_thumb_image'];

            $choices = supermag_get_image_sizes_options();
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_cat_title' ); ?>"><?php _e( 'Title:', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title' ); ?>" type="text" value="<?php echo $supermag_gallery_title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('supermag_cat'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                <?php
                $supermag_dropown_cat = array(
                    'show_option_none'   => __('All ( Recent posts )','supermag'),
                    'orderby'            => 'name',
                    'order'              => 'asc',
                    'show_count'         => 1,
                    'hide_empty'         => 1,
                    'echo'               => 1,
                    'selected'           => $supermag_selected_cat,
                    'hierarchical'       => 1,
                    'name'               => $this->get_field_name('supermag_cat'),
                    'id'                 => $this->get_field_name('supermag_cat'),
                    'class'              => 'widefat',
                    'taxonomy'           => 'category',
                    'hide_if_empty'      => false,
                );
                wp_dropdown_categories($supermag_dropown_cat);
                ?>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_column_number' ); ?>"><?php _e( 'Select number of columns/rows', 'supermag' ); ?></label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_column_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_column_number' ); ?>">
                    <?php
                    foreach( $supermag_column_arrays as $supermag_column_array ){
                      echo ' <option value="'.$supermag_column_array.'" '.selected( $supermag_column_number, $supermag_column_array, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_slide_mode' ); ?>"><?php _e( 'Select slide mode', 'supermag' ); ?></label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_slide_mode' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slide_mode' ); ?>">
                    <?php
                    foreach( $supermag_slide_mode_arrays as $supermag_slide_mode_value => $supermag_slide_mode_label ){
                        echo ' <option value="'.$supermag_slide_mode_value.'" '.selected( $supermag_slide_mode, $supermag_slide_mode_value, 0). '>'.$supermag_slide_mode_label.'</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>" name="<?php echo $this->get_field_name( 'supermag_enable_title_link' ); ?>" type="checkbox" <?php checked( 1, $supermag_enable_title_link, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>"><?php _e( 'Enable link in main title' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_auto_slide' ); ?>" name="<?php echo $this->get_field_name( 'supermag_auto_slide' ); ?>" type="checkbox" value="<?php echo $supermag_auto_slide; ?>" <?php checked( 1, $supermag_auto_slide, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_auto_slide' ); ?>"><?php _e( 'Enable auto slide' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_cat' ); ?>" type="checkbox" value="<?php echo $supermag_show_cat; ?>" <?php checked( 1, $supermag_show_cat, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>"><?php _e( 'Show categories' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_date' ); ?>" type="checkbox" value="<?php echo $supermag_show_date; ?>" <?php checked( 1, $supermag_show_date, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_author' ); ?>" type="checkbox" value="<?php echo $supermag_show_author; ?>" <?php checked( 1, $supermag_show_author, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>"><?php _e( 'Show author' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_comment' ); ?>" type="checkbox" value="<?php echo $supermag_show_comment; ?>" <?php checked( 1, $supermag_show_comment, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>"><?php _e( 'Show number of comments' ,'supermag'); ?></label>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_content_words' ); ?>"><?php _e( 'Number of words in contents', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_content_words' ); ?>" name="<?php echo $this->get_field_name( 'supermag_content_words' ); ?>" type="number" value="<?php echo $supermag_content_words; ?>" />
                <br />
                <small><?php _e('Enter 0 for not showing content','supermag')?></small>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_slider_speed' ); ?>"><?php _e( 'Speed in milliseconds', 'supermag' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_slider_speed' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slider_speed' ); ?>" type="number" value="<?php echo $supermag_slider_speed; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_gallery_slide_image' ); ?>">
                    <?php _e( 'Gallery Slide Image', 'supermag' ); ?>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_gallery_slide_image' ); ?>" name="<?php echo $this->get_field_name( 'supermag_gallery_slide_image' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_gallery_slide_image, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_gallery_thumb_image' ); ?>">
                    <?php _e( 'Gallery Thumb Image', 'supermag' ); ?>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_gallery_thumb_image' ); ?>" name="<?php echo $this->get_field_name( 'supermag_gallery_thumb_image' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_gallery_thumb_image, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
        <?php
        }

        /**
         * Function to Updating widget replacing old instances with new
         *
         * @access public
         * @since 1.0
         *
         * @param array $new_instance new arrays value
         * @param array $old_instance old arrays value
         * @return array
         *
         */
        public function update( $new_instance, $old_instance ) {
            $instance = array();
            $instance['supermag_cat_title'] = ( isset( $new_instance['supermag_cat_title'] ) ) ? sanitize_text_field( $new_instance['supermag_cat_title'] ) : '';
            $instance['supermag_cat'] = ( isset( $new_instance['supermag_cat'] ) ) ? esc_attr( $new_instance['supermag_cat'] ) : -1;
            $instance['supermag_enable_title_link'] = isset($new_instance['supermag_enable_title_link'])? 1 : 0;
            $instance['supermag_column_number'] = isset($new_instance['supermag_column_number'])? absint( $new_instance['supermag_column_number'] ) : 5;
            $instance['supermag_slide_mode'] = isset($new_instance['supermag_slide_mode'])? sanitize_text_field( $new_instance['supermag_slide_mode'] ) : 'horizontal';
            $instance['supermag_auto_slide'] = isset($new_instance['supermag_auto_slide'])? 1 : 0;
            $instance['supermag_show_cat'] = isset($new_instance['supermag_show_cat'])? 1 : 0;
            $instance['supermag_show_date'] = isset($new_instance['supermag_show_date'])? 1 : 0;
            $instance['supermag_show_author'] = isset($new_instance['supermag_show_author'])? 1 : 0;
            $instance['supermag_show_comment'] = isset($new_instance['supermag_show_comment'])? 1 : 0;
            $instance['supermag_content_words'] = isset($new_instance['supermag_content_words'])? absint( $new_instance['supermag_content_words'] ): 0;
            $instance['supermag_slider_speed'] = isset($new_instance['supermag_slider_speed'])? absint( $new_instance['supermag_slider_speed'] ): 1200;
            $instance['supermag_gallery_slide_image'] = isset($new_instance['supermag_gallery_slide_image'])? esc_attr( $new_instance['supermag_gallery_slide_image'] ) : 'large';
            $instance['supermag_gallery_thumb_image'] = isset($new_instance['supermag_gallery_thumb_image'])? esc_attr( $new_instance['supermag_gallery_thumb_image'] ) : 'large';

            return $instance;
        }

        /**
         * Function to Creating widget front-end. This is where the action happens
         *
         * @access public
         * @since 1.0
         *
         * @param array $args widget setting
         * @param array $instance saved values
         * @return void
         *
         */
        public function widget($args, $instance) {
            /*defaults values*/
            $instance = wp_parse_args( (array) $instance, $this->defaults);

            /*selected cat*/
            $supermag_selected_cat = esc_attr( $instance['supermag_cat'] );

            /*Main title*/
            $supermag_gallery_title = isset( $instance['supermag_cat_title'] ) ? esc_attr( $instance['supermag_cat_title'] ) : get_cat_name($supermag_selected_cat);
            $supermag_gallery_title = apply_filters( 'widget_title', $supermag_gallery_title, $instance, $this->id_base );

            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link'] );
            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat  ){
		            $supermag_gallery_title = "<a href='".esc_url( get_category_link( $supermag_selected_cat ) )."'>".$supermag_gallery_title."</a>";
	            }
	            else{
		            $supermag_gallery_title = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_gallery_title."</a>";
	            }
            }

            /*Auto*/
            $supermag_auto_slide = esc_attr( $instance['supermag_auto_slide'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );

            /*number of words in content*/
            $supermag_content_words    = absint( $instance['supermag_content_words'] );

            /*comumn number*/
            $supermag_column_number = absint( $instance['supermag_column_number'] );

            /*Slider Mode*/

            $supermag_slide_mode = sanitize_text_field( $instance['supermag_slide_mode'] );

            /* Slider Speed*/
            $supermag_slider_speed    = absint( $instance['supermag_slider_speed'] );

            /*first featured post layout*/
            $supermag_gallery_slide_image = esc_attr( $instance['supermag_gallery_slide_image'] );

            /*gallery thumb  image*/
            $supermag_gallery_thumb_image = esc_attr( $instance['supermag_gallery_thumb_image'] );

            /* getting values*/
            if( isset( $args['id'] ) ){
                $supermag_sidebar_id = $args['id'];
            }
            else{
                $supermag_sidebar_id = 'supermag-home';
            }
            if( isset( $args['widget_id'] ) ){
                $supermag_widget_id = $args['widget_id'];
            }
            else{
                $supermag_widget_id = 'at-'.microtime();
            }

            /**
             * Filter the arguments for the Recent Posts widget.
             *
             * @since 1.0.0
             *
             * @see WP_Query
             *
             */
            $supermag_selected_cat_post_args = array(
                'posts_per_page'      => $supermag_column_number,
                'no_found_rows'       => true,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => true
            );
            if( -1 != $supermag_selected_cat ){
                $supermag_selected_cat_post_args['cat'] = $supermag_selected_cat;
            }
            $supermag_featured_query = new WP_Query($supermag_selected_cat_post_args);

            if ($supermag_featured_query->have_posts()):
                if( 1 == $supermag_column_number ){
                    $supermag_column = 'acme-col-1';
                }
                elseif( 2 == $supermag_column_number ){
                    $supermag_column = 'acme-col-2';
                }
                elseif( 3 == $supermag_column_number ){
                    $supermag_column = 'acme-col-3';
                }
                elseif( 4 == $supermag_column_number ){
                    $supermag_column = 'acme-col-4';
                }
                elseif( 5 == $supermag_column_number ){
                    $supermag_column = 'acme-col-5';
                }
                elseif( 6 == $supermag_column_number ){
                    $supermag_column = 'acme-col-6';
                }
                else{
                    $supermag_column = 'acme-col-3';
                }
                $supermag_post_count = 0;

	            $supermag_customizer_all_values = supermag_get_theme_options();
                $supermag_no_image_thumbnail = $supermag_customizer_all_values['supermag-no-image-thumbnail'];
                $supermag_no_image_large = $supermag_customizer_all_values['supermag-no-image-large'];
	            if( -1 != $supermag_selected_cat ){
		            echo "<div class='at-cat-color-wrap-".$supermag_selected_cat."'>";
	            }
	            echo $args['before_title'] . $supermag_gallery_title . $args['after_title'];

	            if( -1 != $supermag_selected_cat ){
		            echo "</div>";
	            }
                ?>
                <div class="featured-entries-col featured-entries featured-gallery <?php echo esc_attr( $supermag_sidebar_id ); ?>">
                    <div class="gallery-slider gallery-bx-slider">
                        <ul class="slides gallery-bx-slides" data-pager="<?php echo esc_attr( $supermag_widget_id );?>" data-speed="<?php echo $supermag_slider_speed;?>" data-mode="<?php echo $supermag_slide_mode;?>" data-auto="<?php echo $supermag_auto_slide?>">
                            <?php
                            while ($supermag_featured_query->have_posts()):
                                $supermag_featured_query->the_post();
                                if (has_post_thumbnail()):
                                    $post_large_thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), $supermag_gallery_slide_image);
                                else:
                                    $post_large_thumb[0] = $supermag_no_image_large;
                                endif;
                                ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                        <img class="previewHolder" src="<?php echo $post_large_thumb[0]; ?>" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>"/>
                                    </a>
                                    <div class="title-caption featured-desc">
                                        <?php
                                        if( 1 == $supermag_show_date || 1 == $supermag_show_author || 1 == $supermag_show_comment ) { ?>
                                            <div class="above-entry-meta">
                                                <?php
                                                if ( 1 == $supermag_show_date ){
                                                    $archive_year  = get_the_date('Y');
                                                    $archive_month = get_the_date('m');
                                                    $archive_day   = get_the_date('d');
                                                    ?>
                                                    <span>
                                                        <i class="fa fa-calendar"></i>
                                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                            <?php echo get_the_date(); ?>
                                                        </a>
                                                    </span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_show_author ) { ?>
                                                    <span><i class="fa fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_show_comment ){ ?>
                                                    <span><i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?></span>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <h3 class="title"><?php the_title(); ?></h3>
                                        <?php if (  0 != $supermag_content_words ) {
                                            ?>
                                            <div class="caption"><?php echo supermag_words_count( get_the_excerpt(),$supermag_content_words ); ?></div>
                                            <?php
                                        }
                                        ?>
                                        <?php
                                        if( 1 == $supermag_show_cat ){?>
                                            <div class="below-entry-meta">
                                                <?php supermag_list_category(); ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </li>
                                <?php
                                $supermag_post_count++;
                            endwhile;
                            ?>
                        </ul>
                    </div>
                    <div class="featured-entries-col">
                        <div id="<?php echo esc_attr( $supermag_widget_id );?>">
                            <?php
                            $supermag_post_count = 0;
                            while ($supermag_featured_query->have_posts()):
                                $supermag_featured_query->the_post();
                                if (has_post_thumbnail()):
                                    $post_thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), $supermag_gallery_thumb_image );
                                else:
                                    $post_thumb[0] = $supermag_no_image_thumbnail;
                                endif;
                                ?>
                                <a class="<?php echo esc_attr( $supermag_column );?> no-media-query" data-slide-index="<?php echo $supermag_post_count;?>" href=""><img src="<?php echo esc_url( $post_thumb[0] ); ?>" alt="<?php esc_attr( get_the_title()) ?>" /></a>
                                <?php
                                $supermag_post_count++;
                            endwhile;
                            ?>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <?php
                wp_reset_postdata();
            endif;
        }
    } // Class supermag_gallery_slider ends here
}

/**
 * Function to Register and load the widget
 *
 * @since 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_gallery_slider' ) ) :

    function supermag_gallery_slider() {
        register_widget( 'supermag_gallery_slider' );
    }
endif;
add_action( 'widgets_init', 'supermag_gallery_slider' );
