<?php
/**
 * Class for adding Slider
 *
 * @package Acme Themes
 * @subpackage SuperMag
 * @since 1.0.0
 */
if ( ! class_exists( 'supermag_slider' ) ) {

    class supermag_slider extends WP_Widget {
        /*defaults values for fields*/
        private $defaults = array(
            'supermag_cat_title'        => 'Recent Posts',
            'supermag_cat'              => -1,
            'supermag_number'           => 14,
            'supermag_slider_speed'     => 2000,
            'supermag_slider_pause'     => 4000,
            'supermag_enable_title_link'=> 1,
            'supermag_show_title'       => 1,
            'supermag_show_desc'        => 0,
            'supermag_show_cat'         => 0,
            'supermag_show_date'        => 1,
            'supermag_show_author'      => 1,
            'supermag_show_comment'     => 1,
            'supermag_slider_auto'      => 1,
            'supermag_slider_controls'  => 1,
            'supermag_post_col_normal_image_layout' => 'large'
        );

        function __construct() {
            parent::__construct(
            /*Base ID of your widget*/
                'supermag_slider',
                /*Widget name will appear in UI*/
                __('AT Slider', 'supermag'),
                /*Widget description*/
                array( 'description' => __( 'Slider for Posts', 'supermag' ) )
            );
        }

        /*Widget Backend*/
        public function form( $instance ) {
            /*defaults values*/
            $instance = wp_parse_args( (array) $instance, $this->defaults);

            /*Main title*/
            $supermag_slider_title = esc_attr( $instance['supermag_cat_title'] );

            /*selected cat*/
            $supermag_selected_cat = esc_attr( $instance['supermag_cat'] );

            /*show number*/
            $supermag_number = absint( $instance['supermag_number'] );

            /*slider speed*/
            $supermag_slider_speed = absint( $instance['supermag_slider_speed'] );

            /*slider pause*/
            $supermag_slider_pause = absint( $instance['supermag_slider_pause'] );

            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link']);

            /*Show title*/
            $supermag_show_title = esc_attr( $instance['supermag_show_title'] );

            /*Show desc*/
            $supermag_show_desc = esc_attr( $instance['supermag_show_desc'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );

            /*Auto Slide*/
            $supermag_slider_auto = esc_attr( $instance['supermag_slider_auto'] );

            /*Slider controls*/
            $supermag_slider_controls = esc_attr( $instance['supermag_slider_controls'] );

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = $instance['supermag_post_col_normal_image_layout'];
            $choices = supermag_get_image_sizes_options();

            /*Widget admin form*/
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_cat_title' ); ?>"><?php _e( 'Enter title:' ,'supermag'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_cat_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_cat_title' ); ?>" type="text" value="<?php echo esc_attr( $supermag_slider_title ); ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('supermag_cat'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                <?php
                $supermag_dropown_cat = array(
                    'show_option_none'   => __('All ( Recent posts )','supermag'),
                    'orderby'            => 'name',
                    'order'              => 'asc',
                    'show_count'         => 1,
                    'hide_empty'         => 1,
                    'echo'               => 1,
                    'selected'           => $supermag_selected_cat,
                    'hierarchical'       => 1,
                    'name'               => $this->get_field_name('supermag_cat'),
                    'id'                 => $this->get_field_name('supermag_cat'),
                    'class'              => 'widefat',
                    'taxonomy'    => 'category',
                    'hide_if_empty'      => false,
                );
                wp_dropdown_categories($supermag_dropown_cat);
                ?>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_number' ); ?>"><?php _e( 'Enter number of posts to show' ,'supermag'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_number' ); ?>" type="number" value="<?php echo $supermag_number; ?>" placeholder="<?php _e( '1,25,9' ,'supermag'); ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_slider_speed' ); ?>"><?php _e( 'Slider Speed' ,'supermag'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_slider_speed' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slider_speed' ); ?>" type="number" value="<?php echo $supermag_slider_speed; ?>" />
                <br />
                <small><?php _e( 'Slide transition duration (in ms)' ,'supermag'); ?></small>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_slider_pause' ); ?>"><?php _e( 'Slider Pause' ,'supermag'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_slider_pause' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slider_pause' ); ?>" type="number" value="<?php echo $supermag_slider_pause; ?>" />
                <br />
                <small><?php _e( 'The amount of time (in ms) between each auto transition' ,'supermag'); ?></small>
            </p>

            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>" name="<?php echo $this->get_field_name( 'supermag_enable_title_link' ); ?>" type="checkbox" <?php checked( 1, $supermag_enable_title_link, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_enable_title_link' ); ?>"><?php _e( 'Enable link in main title' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_title' ); ?>" type="checkbox" value="<?php echo $supermag_show_title; ?>" <?php checked( 1, $supermag_show_title , 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_title' ); ?>"><?php _e( 'Show title' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_desc' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_desc' ); ?>" type="checkbox" value="<?php echo $supermag_show_desc; ?>" <?php checked( 1, $supermag_show_desc, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_desc' ); ?>"><?php _e( 'Show description' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_cat' ); ?>" type="checkbox" value="<?php echo $supermag_show_cat; ?>" <?php checked( 1, $supermag_show_cat, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_cat' ); ?>"><?php _e( 'Show categories' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_date' ); ?>" type="checkbox" value="<?php echo $supermag_show_date; ?>" <?php checked( 1, $supermag_show_date, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_author' ); ?>" type="checkbox" value="<?php echo $supermag_show_author; ?>" <?php checked( 1, $supermag_show_author, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_author' ); ?>"><?php _e( 'Show author' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>" name="<?php echo $this->get_field_name( 'supermag_show_comment' ); ?>" type="checkbox" value="<?php echo $supermag_show_comment; ?>" <?php checked( 1, $supermag_show_comment, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_show_comment' ); ?>"><?php _e( 'Show number of comments' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_slider_auto' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slider_auto' ); ?>" type="checkbox" value="<?php echo $supermag_slider_auto; ?>" <?php checked( 1, $supermag_slider_auto, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_slider_auto' ); ?>"><?php _e( 'Auto Slide' ,'supermag'); ?></label>
            </p>
            <p>
                <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_slider_controls' ); ?>" name="<?php echo $this->get_field_name( 'supermag_slider_controls' ); ?>" type="checkbox" value="<?php echo $supermag_slider_controls; ?>" <?php checked( 1, $supermag_slider_controls, 1 ); ?> />
                <label for="<?php echo $this->get_field_id( 'supermag_slider_controls' ); ?>"><?php _e( 'Enable Controls ' ,'supermag'); ?></label>
                <br />
                <small><?php _e( 'The "Next" / "Prev" controls will be added' ,'supermag'); ?></small>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php _e( 'Normal Featured Post Image', 'supermag' ); ?>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>" name="<?php echo $this->get_field_name( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_post_col_normal_image_layout, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <?php
        }

        /**
         * Function to Updating widget replacing old instances with new
         *
         * @access public
         * @since 1.0
         *
         * @param array $new_instance new arrays value
         * @param array $old_instance old arrays value
         * @return array
         *
         */
        public function update( $new_instance, $old_instance ) {
            $instance = array();
            $instance['supermag_cat_title'] = ( ! empty( $new_instance['supermag_cat_title'] ) ) ? sanitize_text_field( $new_instance['supermag_cat_title'] ) : '';
            $instance['supermag_cat'] = ( ! empty( $new_instance['supermag_cat'] ) ) ? esc_attr( $new_instance['supermag_cat'] ) : -1;
            $instance['supermag_number'] = ( ! empty( $new_instance['supermag_number'] ) ) ? absint( $new_instance['supermag_number'] ) : 12;
            $instance['supermag_slider_speed'] = ( ! empty( $new_instance['supermag_slider_speed'] ) ) ? absint( $new_instance['supermag_slider_speed'] ) : 2000;
            $instance['supermag_slider_pause'] = ( ! empty( $new_instance['supermag_slider_pause'] ) ) ? absint( $new_instance['supermag_slider_pause'] ) : 4000;
            $instance['supermag_enable_title_link'] = isset($new_instance['supermag_enable_title_link'])? 1 : 0;
            $instance['supermag_show_title'] = isset($new_instance['supermag_show_title'])? 1 : 0;
            $instance['supermag_show_desc'] = isset($new_instance['supermag_show_desc'])? 1 : 0;
            $instance['supermag_show_cat'] = isset($new_instance['supermag_show_cat'])? 1 : 0;
            $instance['supermag_show_date'] = isset($new_instance['supermag_show_date'])? 1 : 0;
            $instance['supermag_show_author'] = isset($new_instance['supermag_show_author'])? 1 : 0;
            $instance['supermag_show_comment'] = isset($new_instance['supermag_show_comment'])? 1 : 0;
            $instance['supermag_slider_auto'] = isset($new_instance['supermag_slider_auto'])? 1 : 0;
            $instance['supermag_slider_controls'] = isset($new_instance['supermag_slider_controls'])? 1 : 0;
            $instance['supermag_post_col_normal_image_layout'] = isset($new_instance['supermag_post_col_normal_image_layout'])? esc_attr( $new_instance['supermag_post_col_normal_image_layout'] ) : 'large';

            return $instance;
        }

        /**
         * Function to Creating widget front-end. This is where the action happens
         *
         * @access public
         * @since 1.0
         *
         * @param array $args widget setting
         * @param array $instance saved values
         * @return void
         *
         */
        public function widget( $args, $instance ) {
            /*defaults values*/
            $instance = wp_parse_args( (array) $instance, $this->defaults);

            /*selected cat*/
            $supermag_selected_cat = esc_attr( $instance['supermag_cat'] );

            /*Main title*/
            $supermag_slider_title = !empty( $instance['supermag_cat_title'] ) ? esc_attr( $instance['supermag_cat_title'] ) : get_cat_name($supermag_selected_cat);
            $supermag_slider_title = apply_filters( 'widget_title', $supermag_slider_title );

            /*show number*/
            $supermag_number = absint( $instance['supermag_number'] );

            /*slider speed*/
            $supermag_slider_speed = absint( $instance['supermag_slider_speed'] );

            /*slider pause*/
            $supermag_slider_pause = absint( $instance['supermag_slider_pause'] );

            /*Enable title link*/
            $supermag_enable_title_link = esc_attr( $instance['supermag_enable_title_link']);
            if( 1 == $supermag_enable_title_link ) {
	            if( -1 != $supermag_selected_cat  ){
		            $supermag_slider_title = "<a href='".esc_url( get_category_link( $supermag_selected_cat ) )."'>".$supermag_slider_title."</a>";
	            }
	            else{
		            $supermag_slider_title = "<a href='".esc_url(  get_permalink( get_option( 'page_for_posts' ) )  )."'>".$supermag_slider_title."</a>";
	            }
            }
            /*Show title*/
            $supermag_show_title = esc_attr( $instance['supermag_show_title'] );

            /*Show desc*/
            $supermag_show_desc = esc_attr( $instance['supermag_show_desc'] );

            /*Show cat*/
            $supermag_show_cat = esc_attr( $instance['supermag_show_cat'] );

            /*Show date*/
            $supermag_show_date = esc_attr( $instance['supermag_show_date'] );

            /*Show author*/
            $supermag_show_author = esc_attr( $instance['supermag_show_author'] );

            /*Show comment*/
            $supermag_show_comment = esc_attr( $instance['supermag_show_comment'] );

            /*Auto Slide*/
            $supermag_slider_auto = esc_attr( $instance['supermag_slider_auto'] );

            /*Slider Controls*/
            $supermag_slider_controls = esc_attr( $instance['supermag_slider_controls'] );

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = esc_attr( $instance['supermag_post_col_normal_image_layout'] );

            if( isset( $args['id'] ) ){
                $supermag_sidebar_id = $args['id'];
            }
            else{
                $supermag_sidebar_id = 'supermag-home';
            }
            if( 'supermag-home' == $supermag_sidebar_id ) {
                $supermag_sidebar_id = 'supermag-home';
            }
            else{
                $supermag_sidebar_id = 'supermag-sidebar';
            }

            // before and after widget arguments are defined by themes
            echo $args['before_widget'];
            $supermag_selected_cat_post_args = array(
                'posts_per_page'      => $supermag_number,
                'no_found_rows'       => true,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => true
            );
            if( -1 != $supermag_selected_cat ){
                $supermag_selected_cat_post_args['cat'] = $supermag_selected_cat;
            }
            $supermag_slider_post_query = new WP_Query($supermag_selected_cat_post_args);
            /*slider*/
            if ( $supermag_slider_post_query->have_posts() ) :
	            if( -1 != $supermag_selected_cat ){
		            echo "<div class='at-cat-color-wrap-".$supermag_selected_cat."'>";
	            }
	            echo $args['before_title'] . $supermag_slider_title . $args['after_title'];

	            if( -1 != $supermag_selected_cat ){
		            echo "</div>";
	            }
	            ?>
                <div class="slider-feature-wrap clearfix">
                <div class="slider-section widget-slider">
                    <ul class="home-bxslider" data-speed="<?php echo $supermag_slider_speed;?>" data-pause="<?php echo $supermag_slider_pause;?>" data-auto="<?php echo $supermag_slider_auto;?>" data-controls="<?php echo $supermag_slider_controls;?>">
                            <?php
                            $supermag_customizer_all_values = supermag_get_theme_options();
                            $supermag_no_image_medium = $supermag_customizer_all_values['supermag-no-image-medium'];
                            $supermag_no_image_large = $supermag_customizer_all_values['supermag-no-image-large'];
                            $i = 0;
                            while ( $supermag_slider_post_query->have_posts() ) : $supermag_slider_post_query->the_post();
                                if (has_post_thumbnail()) {
                                    $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(), $supermag_post_col_normal_image_layout);
                                } else {
                                    if( 'supermag-home' == $supermag_sidebar_id ) {
                                        $image_url[0] = $supermag_no_image_large;
                                    }
                                    else{
                                        $image_url[0] = $supermag_no_image_medium;
                                    }
                                }
                                ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?php echo esc_url( $image_url[0] ); ?>" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" />
                                    </a>
                                    <div class="slider-desc">
                                        <?php if( 1 == $supermag_show_date || 1 == $supermag_show_author || 1== $supermag_show_comment ){
                                            ?>
                                            <div class="above-slider-details">
                                                <?php
                                                $archive_year  = get_the_date('Y');
                                                $archive_month = get_the_date('m');
                                                $archive_day   = get_the_date('d');
                                                if ( 1 == $supermag_show_date ){
                                                    ?>
                                                    <i class="fa fa-calendar"></i>
                                                    <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                        <?php echo get_the_date(); ?>
                                                    </a>
                                                    <?php
                                                }
                                                if ( 1 == $supermag_show_author ){
                                                    ?>
                                                    <i class="fa fa-user"></i>
                                                    <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo esc_attr( get_the_author() ); ?>">
                                                        <?php echo esc_html( get_the_author() ); ?>
                                                    </a>
                                                    <?php
                                                }
                                                if ( 1 == $supermag_show_comment ){
                                                    ?>
                                                    <i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <div class="slider-details">
                                            <?php
                                            if( 1 == $supermag_show_title ){
                                                ?>
                                                <a href="<?php the_permalink()?>">
                                                    <div class="slide-title">
                                                        <?php the_title(); ?>
                                                    </div>
                                                </a>
                                                <?php
                                            }
                                            if( 1 == $supermag_show_desc){
                                                $content = supermag_words_count( get_the_excerpt(), 30);
                                                echo '<div class="slide-caption">'.esc_html( $content ).'</div>';
                                            }
                                            ?>
                                        </div>
                                        <div>
                                            <?php
                                            if( 1 == $supermag_show_cat ){
                                                supermag_list_category();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </li>
                                <?php
                                $i++;
                            endwhile;
                            wp_reset_postdata();
                        ?>
                    </ul>
                </div>
                </div>
                <?php
            endif;
            /*slider*/
            wp_reset_postdata();
            ?>
            <div class="clearfix"></div>
            <?php
            echo $args['after_widget'];
        }
    } // Class supermag_slider ends here
}

/**
 * Function to Register and load the widget
 *
 * @since 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_slider' ) ) :

    function supermag_slider() {
        register_widget( 'supermag_slider' );
    }
endif;
add_action( 'widgets_init', 'supermag_slider' );