<?php
/**
 * Class for adding Tabbed widget
 *
 * @package Acme Themes
 * @subpackage SuperMag
 * @since 1.0.0
 */
if ( ! class_exists( 'supermag_tabbed_widget' ) ) :

    class supermag_tabbed_widget extends WP_Widget {

        private $defaults = array(
            'supermag_p_title'                  => 'Popular',
            'supermag_p_cat'                    => '',
            'supermag_p_enable_first_featured'  => '',
            'supermag_p_show_image'             => true,
            'supermag_p_show_cat'               => false,
            'supermag_p_show_date'              => true,
            'supermag_p_show_author'            => true,
            'supermag_p_show_comment'           => false,
            'supermag_p_content_words'          => 0,
            'supermag_p_number'                 => 5,
            'supermag_p_column_number'          => 3,
            'supermag_popular_show'             => 1,

            'supermag_r_title'                  => 'Recent',
            'supermag_r_cat'                    => '',
            'supermag_r_enable_first_featured'  => '',
            'supermag_r_show_image'             => 1,
            'supermag_r_show_cat'               => 0,
            'supermag_r_show_date'              => 1,
            'supermag_r_show_author'            => 1,
            'supermag_r_show_comment'           => 0,
            'supermag_r_content_words'          => 0,
            'supermag_r_number'                 => 5,
            'supermag_r_column_number'          => 3,
            'supermag_recent_show'              => 1,

            'supermag_c_title'                  => 'Comment',
            'supermag_c_show_post_title'        => 1,
            'supermag_c_show_date'              => 1,
            'supermag_c_show_avatar'            => 1,
            'supermag_c_content_words'          => 10,
            'supermag_c_column_number'          => 3,
            'supermag_c_number'                 => 5,
            'supermag_comment_show'             => 1,

            'supermag_post_col_first_featured_image_layout' => 'large',
            'supermag_post_col_normal_image_layout' => 'large'
        );

        function __construct() {
            parent::__construct(
            /*Base ID of your widget*/
                'supermag_tabbed',
                /*Widget name will appear in UI*/
                __('AT Tabbed', 'supermag'),
                /*Widget description*/
                array( 'description' => __( 'Show popular,recent posts and comments in tab', 'supermag' ), )
            );
        }

        function form( $instance ) {

            //Defaults
            $instance = wp_parse_args( (array) $instance, $this->defaults );
            $supermag_p_title =  esc_attr( $instance['supermag_p_title'] );
            $supermag_p_selected_cat = esc_attr( $instance['supermag_p_cat'] );
            $supermag_p_enable_first_featured = esc_attr( $instance['supermag_p_enable_first_featured'] );
            $supermag_p_show_image = esc_attr( $instance['supermag_p_show_image'] );
            $supermag_p_show_cat = esc_attr( $instance['supermag_p_show_cat'] );
            $supermag_p_show_date = esc_attr( $instance['supermag_p_show_date'] );
            $supermag_p_show_author = esc_attr( $instance['supermag_p_show_author'] );
            $supermag_p_show_comment = esc_attr( $instance['supermag_p_show_comment'] );
            $supermag_p_content_words = esc_attr( $instance['supermag_p_content_words'] );
            $supermag_p_number = esc_attr( $instance['supermag_p_number'] );
            $supermag_p_column_number = esc_attr( $instance['supermag_p_column_number'] );
            $supermag_popular_show = esc_attr( $instance['supermag_popular_show'] );

            $supermag_r_title =  esc_attr( $instance['supermag_r_title'] );
            $supermag_r_selected_cat = esc_attr( $instance['supermag_r_cat'] );
            $supermag_r_enable_first_featured = esc_attr( $instance['supermag_r_enable_first_featured'] );
            $supermag_r_show_image = esc_attr( $instance['supermag_r_show_image'] );
            $supermag_r_show_cat = esc_attr( $instance['supermag_r_show_cat'] );
            $supermag_r_show_date = esc_attr( $instance['supermag_r_show_date'] );
            $supermag_r_show_author = esc_attr( $instance['supermag_r_show_author'] );
            $supermag_r_show_comment = esc_attr( $instance['supermag_r_show_comment'] );
            $supermag_r_content_words = esc_attr( $instance['supermag_r_content_words'] );
            $supermag_r_number = esc_attr( $instance['supermag_r_number'] );
            $supermag_r_column_number = esc_attr( $instance['supermag_r_column_number'] );
            $supermag_recent_show = esc_attr( $instance['supermag_recent_show'] );

            $supermag_c_title = esc_attr( $instance['supermag_c_title'] );
            $supermag_c_show_post_title = esc_attr( $instance['supermag_c_show_post_title'] );
            $supermag_c_show_date = esc_attr( $instance['supermag_c_show_date'] );
            $supermag_c_show_avatar = esc_attr( $instance['supermag_c_show_avatar'] );
            $supermag_c_content_words = esc_attr( $instance['supermag_c_content_words'] );
            $supermag_c_number = esc_attr( $instance['supermag_c_number'] );
            $supermag_c_column_number = esc_attr( $instance['supermag_c_column_number'] );
            $supermag_comment_show = esc_attr( $instance['supermag_comment_show'] );

            /*first featured image*/
            $supermag_post_col_first_featured_image_layout = $instance['supermag_post_col_first_featured_image_layout'];

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = $instance['supermag_post_col_normal_image_layout'];

            $choices = supermag_get_image_sizes_options();

            $supermag_column_arrays = array( 1,2,3,4 );
            ?>
            <div class="custom-theme-accordion">
                <h4 class="accordion-toggle opened"><?php _e( 'Popular Posts', 'supermag' ); ?></h4>
                <div class="accordion-content active">
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_title' ); ?>"><?php _e( 'Popular tab title:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_title' ); ?>" type="text" value="<?php echo $supermag_p_title; ?>" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id('supermag_cat'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                        <?php
                        $supermag_dropown_cat = array(
                            'show_option_none'   => __('All ( Popular posts )','supermag'),
                            'orderby'            => 'name',
                            'order'              => 'asc',
                            'show_count'         => 1,
                            'hide_empty'         => 1,
                            'echo'               => 1,
                            'selected'           => $supermag_p_selected_cat,
                            'hierarchical'       => 1,
                            'name'               => $this->get_field_name('supermag_cat'),
                            'id'                 => $this->get_field_name('supermag_cat'),
                            'class'              => 'widefat',
                            'taxonomy'           => 'category',
                            'hide_if_empty'      => false,
                        );
                        wp_dropdown_categories($supermag_dropown_cat);
                        ?>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_number' ); ?>"><?php _e( 'Number of posts to show:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_number' ); ?>" type="number" value="<?php echo $supermag_p_number; ?>" size="3" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_column_number' ); ?>"><?php _e( 'Select number of columns', 'supermag' ); ?></label>
                        <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_column_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_column_number' ); ?>">
                            <?php
                            foreach( $supermag_column_arrays as $supermag_column_array ){
                                echo ' <option value="'.$supermag_column_array.'" '.selected( $supermag_p_column_number, $supermag_column_array, 0). '>'.$supermag_column_array.'</option>';
                            }
                            ?>
                        </select>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_enable_first_featured' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_enable_first_featured' ); ?>" type="checkbox" <?php checked( 1, esc_attr( $supermag_p_enable_first_featured ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_enable_first_featured' ); ?>"><?php _e( 'Enable first post featured' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_show_image' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_show_image' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_p_show_image ); ?>" <?php checked( 1, esc_attr( $supermag_p_show_image ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_show_image' ); ?>"><?php _e( 'Show image' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_show_cat' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_show_cat' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_p_show_cat ); ?>" <?php checked( 1, esc_attr( $supermag_p_show_cat ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_show_cat' ); ?>"><?php _e( 'Show categories' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_show_date' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_p_show_date ); ?>" <?php checked( 1, esc_attr( $supermag_p_show_date ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_show_author' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_show_author' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_p_show_author ); ?>" <?php checked( 1, esc_attr( $supermag_p_show_author ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_show_author' ); ?>"><?php _e( 'Show author' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_show_comment' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_show_comment' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_p_show_comment ); ?>" <?php checked( 1, esc_attr( $supermag_p_show_comment ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_show_comment' ); ?>"><?php _e( 'Show number of comments' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_p_content_words' ); ?>"><?php _e( 'Number of words in contents', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_p_content_words' ); ?>" name="<?php echo $this->get_field_name( 'supermag_p_content_words' ); ?>" type="number" value="<?php echo $supermag_p_content_words; ?>" />
                        <br />
                        <small><?php _e('Enter 0 for not showing content','supermag')?></small>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_popular_show' ); ?>" name="<?php echo $this->get_field_name( 'supermag_popular_show' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_popular_show ); ?>" <?php checked( 1, esc_attr( $supermag_popular_show ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_popular_show' ); ?>"><?php _e( 'Show popular tab' ,'supermag'); ?></label>
                    </p>
                </div>
                <h4 class="accordion-toggle"><?php _e( 'Recent Posts', 'supermag' ); ?></h4>
                <div class="accordion-content">
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_title' ); ?>"><?php _e( 'Recent tab title:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_title' ); ?>" type="text" value="<?php echo $supermag_r_title; ?>" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id('supermag_cat'); ?>"><?php _e('Select category', 'supermag'); ?></label>
                        <?php
                        $supermag_dropown_cat = array(
                            'show_option_none'   => __('All ( Recent posts )','supermag'),
                            'orderby'            => 'name',
                            'order'              => 'asc',
                            'show_count'         => 1,
                            'hide_empty'         => 1,
                            'echo'               => 1,
                            'selected'           => $supermag_r_selected_cat,
                            'hierarchical'       => 1,
                            'name'               => $this->get_field_name('supermag_cat'),
                            'id'                 => $this->get_field_name('supermag_cat'),
                            'class'              => 'widefat',
                            'taxonomy'           => 'category',
                            'hide_if_empty'      => false,
                        );
                        wp_dropdown_categories($supermag_dropown_cat);
                        ?>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_number' ); ?>"><?php _e( 'Number of posts to show:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_number' ); ?>" type="number" value="<?php echo $supermag_r_number; ?>" size="3" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_column_number' ); ?>"><?php _e( 'Select number of columns', 'supermag' ); ?></label>
                        <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_column_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_column_number' ); ?>">
                            <?php
                            foreach( $supermag_column_arrays as $supermag_column_array ){
                                echo ' <option value="'.$supermag_column_array.'" '.selected( $supermag_r_column_number, $supermag_column_array, 0). '>'.$supermag_column_array.'</option>';
                            }
                            ?>
                        </select>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_enable_first_featured' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_enable_first_featured' ); ?>" type="checkbox" <?php checked( 1, esc_attr( $supermag_r_enable_first_featured ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_enable_first_featured' ); ?>"><?php _e( 'Enable first post featured' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_show_image' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_show_image' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_r_show_image ); ?>" <?php checked( 1, esc_attr( $supermag_r_show_image ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_show_image' ); ?>"><?php _e( 'Show image' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_show_cat' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_show_cat' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_r_show_cat ); ?>" <?php checked( 1, esc_attr( $supermag_r_show_cat ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_show_cat' ); ?>"><?php _e( 'Show categories' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_show_date' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_r_show_date ); ?>" <?php checked( 1, esc_attr( $supermag_r_show_date ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_show_author' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_show_author' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_r_show_author ); ?>" <?php checked( 1, esc_attr( $supermag_r_show_author ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_show_author' ); ?>"><?php _e( 'Show author' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_show_comment' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_show_comment' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_r_show_comment ); ?>" <?php checked( 1, esc_attr( $supermag_r_show_comment ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_show_comment' ); ?>"><?php _e( 'Show number of comments' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_r_content_words' ); ?>"><?php _e( 'Number of words in contents', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_r_content_words' ); ?>" name="<?php echo $this->get_field_name( 'supermag_r_content_words' ); ?>" type="number" value="<?php echo $supermag_r_content_words; ?>" />
                        <br />
                        <small><?php _e('Enter 0 for not showing content','supermag')?></small>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_recent_show' ); ?>" name="<?php echo $this->get_field_name( 'supermag_recent_show' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_recent_show ); ?>" <?php checked( 1, esc_attr( $supermag_recent_show ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_recent_show' ); ?>"><?php _e( 'Show recent tab' ,'supermag'); ?></label>
                    </p>
                </div>
                <h4 class="accordion-toggle"><?php _e( 'Comments', 'supermag' ); ?></h4>
                <div class="accordion-content">
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_title' ); ?>"><?php _e( 'Comment tab title:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_title' ); ?>" type="text" value="<?php echo $supermag_c_title; ?>" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_number' ); ?>"><?php _e( 'Number of posts to show:', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_number' ); ?>" type="number" value="<?php echo $supermag_c_number; ?>" size="3" />
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_column_number' ); ?>"><?php _e( 'Select number of columns', 'supermag' ); ?></label>
                        <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_column_number' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_column_number' ); ?>">
                            <?php
                            foreach( $supermag_column_arrays as $supermag_column_array ){
                                echo ' <option value="'.$supermag_column_array.'" '.selected( $supermag_c_column_number, $supermag_column_array, 0). '>'.$supermag_column_array.'</option>';
                            }
                            ?>
                        </select>
                    </p>
                    <p>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_content_words' ); ?>"><?php _e( 'Number of words in contents', 'supermag' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_content_words' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_content_words' ); ?>" type="number" value="<?php echo $supermag_c_content_words; ?>" />
                        <br />
                        <small><?php _e('Enter 0 for not showing content','supermag')?></small>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_show_avatar' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_show_avatar' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_c_show_avatar ); ?>" <?php checked( 1, esc_attr( $supermag_c_show_avatar ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_show_avatar' ); ?>"><?php _e( 'Show avatar' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_show_post_title' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_show_post_title' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_c_show_post_title ); ?>" <?php checked( 1, esc_attr( $supermag_c_show_post_title ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_show_post_title' ); ?>"><?php _e( 'Show commented post title' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_c_show_date' ); ?>" name="<?php echo $this->get_field_name( 'supermag_c_show_date' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_c_show_date ); ?>" <?php checked( 1, esc_attr( $supermag_c_show_date ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_c_show_date' ); ?>"><?php _e( 'Show date' ,'supermag'); ?></label>
                    </p>
                    <p>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'supermag_comment_show' ); ?>" name="<?php echo $this->get_field_name( 'supermag_comment_show' ); ?>" type="checkbox" value="<?php echo esc_attr( $supermag_comment_show ); ?>" <?php checked( 1, esc_attr( $supermag_comment_show ), 1 ); ?>/>
                        <label for="<?php echo $this->get_field_id( 'supermag_comment_show' ); ?>"><?php _e( 'Show comment tab' ,'supermag'); ?></label>
                    </p>
                </div>
            </div>

            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_post_col_first_featured_image_layout' ); ?>">
                    <?php _e( 'First Featured Post Image', 'supermag' ); ?>
                    <br />
                    <small><?php _e( 'Enable First Post Featured to work this layout', 'supermag' ); ?></small>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_post_col_first_featured_image_layout' ); ?>" name="<?php echo $this->get_field_name( 'supermag_post_col_first_featured_image_layout' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_post_col_first_featured_image_layout, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php _e( 'Normal Featured Post Image', 'supermag' ); ?>
                </label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'supermag_post_col_normal_image_layout' ); ?>" name="<?php echo $this->get_field_name( 'supermag_post_col_normal_image_layout' ); ?>">
                    <?php
                    foreach( $choices as $key => $supermag_column_array ){
                        echo ' <option value="'.$key.'" '.selected( $supermag_post_col_normal_image_layout, $key, 0). '>'.$supermag_column_array.'</option>';
                    }
                    ?>
                </select>
            </p>
            <?php
        }

        function update( $new_instance, $old_instance ) {
            $instance = $old_instance;

            $instance['supermag_p_title'] = ( isset( $new_instance['supermag_p_title'] ) ) ? sanitize_text_field( $new_instance['supermag_p_title'] ) : '';
            $instance['supermag_p_cat'] = ( isset( $new_instance['supermag_p_cat'] ) ) ? esc_attr( $new_instance['supermag_p_cat'] ) : -1;
            $instance['supermag_p_enable_first_featured'] = isset($new_instance['supermag_p_enable_first_featured'])? 1 : 0;
            $instance['supermag_p_number'] = isset($new_instance['supermag_p_number'])? absint( $new_instance['supermag_p_number'] ) : 6;
            $instance['supermag_p_column_number'] = isset($new_instance['supermag_p_column_number'])? absint( $new_instance['supermag_p_column_number'] ) : 3;
            $instance['supermag_p_show_image'] = isset($new_instance['supermag_p_show_image'])? 1 : 0;
            $instance['supermag_p_show_cat'] = isset($new_instance['supermag_p_show_cat'])? 1 : 0;
            $instance['supermag_p_show_date'] = isset($new_instance['supermag_p_show_date'])? 1 : 0;
            $instance['supermag_p_show_author'] = isset($new_instance['supermag_p_show_author'])? 1 : 0;
            $instance['supermag_p_show_comment'] = isset($new_instance['supermag_p_show_comment'])? 1 : 0;
            $instance['supermag_p_content_words'] = isset($new_instance['supermag_p_content_words'])? absint( $new_instance['supermag_p_content_words'] ): 0;
            $instance['supermag_popular_show'] = isset($new_instance['supermag_popular_show'])? 1 : 0;

            $instance['supermag_r_title'] = ( isset( $new_instance['supermag_r_title'] ) ) ? sanitize_text_field( $new_instance['supermag_r_title'] ) : '';
            $instance['supermag_r_cat'] = ( isset( $new_instance['supermag_r_cat'] ) ) ? esc_attr( $new_instance['supermag_r_cat'] ) : -1;
            $instance['supermag_r_enable_first_featured'] = isset($new_instance['supermag_r_enable_first_featured'])? 1 : 0;
            $instance['supermag_r_number'] = isset($new_instance['supermag_r_number'])? absint( $new_instance['supermag_r_number'] ) : 6;
            $instance['supermag_r_column_number'] = isset($new_instance['supermag_r_column_number'])? absint( $new_instance['supermag_r_column_number'] ) : 3;
            $instance['supermag_r_show_image'] = isset($new_instance['supermag_r_show_image'])? 1 : 0;
            $instance['supermag_r_show_cat'] = isset($new_instance['supermag_r_show_cat'])? 1 : 0;
            $instance['supermag_r_show_date'] = isset($new_instance['supermag_r_show_date'])? 1 : 0;
            $instance['supermag_r_show_author'] = isset($new_instance['supermag_r_show_author'])? 1 : 0;
            $instance['supermag_r_show_comment'] = isset($new_instance['supermag_r_show_comment'])? 1 : 0;
            $instance['supermag_r_content_words'] = isset($new_instance['supermag_r_content_words'])? absint( $new_instance['supermag_r_content_words'] ): 0;
            $instance['supermag_recent_show'] = isset($new_instance['supermag_recent_show'])? 1 : 0;

            $instance['supermag_c_title'] = ( isset( $new_instance['supermag_c_title'] ) ) ? sanitize_text_field( $new_instance['supermag_c_title'] ) : '';
            $instance['supermag_c_number'] = isset($new_instance['supermag_c_number'])? absint( $new_instance['supermag_c_number'] ) : 6;
            $instance['supermag_c_column_number'] = isset($new_instance['supermag_c_column_number'])? absint( $new_instance['supermag_c_column_number'] ) : 3;
            $instance['supermag_c_show_avatar'] = isset($new_instance['supermag_c_show_avatar'])? 1 : 0;
            $instance['supermag_c_show_post_title'] = isset($new_instance['supermag_c_show_post_title'])? 1 : 0;
            $instance['supermag_c_show_date'] = isset($new_instance['supermag_c_show_date'])? 1 : 0;
            $instance['supermag_c_content_words'] = isset($new_instance['supermag_c_content_words'])? absint( $new_instance['supermag_c_content_words'] ): 0;
            $instance['supermag_comment_show'] = isset($new_instance['supermag_comment_show'])? 1 : 0;

            $instance['supermag_post_col_first_featured_image_layout'] = isset($new_instance['supermag_post_col_first_featured_image_layout'])? esc_attr( $new_instance['supermag_post_col_first_featured_image_layout'] ) : 'large';
            $instance['supermag_post_col_normal_image_layout'] = isset($new_instance['supermag_post_col_normal_image_layout'])? esc_attr( $new_instance['supermag_post_col_normal_image_layout'] ) : 'large';

            return $instance;
        }

        function widget( $args, $instance ) {
            if( isset( $args['widget_id'] ) ){
                $supermag_widget_id = $args['widget_id'];
            }
            else{
                $supermag_widget_id = 'at-'.microtime();
            }

            if( isset( $args['id'] ) ){
                $supermag_sidebar_id = $args['id'];
            }
            else{
                $supermag_sidebar_id = 'supermag-home';
            }

            //Defaults
            $instance = wp_parse_args( (array) $instance, $this->defaults );

            $supermag_p_title = esc_attr( $instance['supermag_p_title'] );
            $supermag_p_selected_cat = esc_attr( $instance['supermag_p_cat'] );
            $supermag_p_enable_first_featured = esc_attr( $instance['supermag_p_enable_first_featured'] );
            $supermag_p_show_image = esc_attr( $instance['supermag_p_show_image'] );
            $supermag_p_show_cat = esc_attr( $instance['supermag_p_show_cat'] );
            $supermag_p_show_date = esc_attr( $instance['supermag_p_show_date'] );
            $supermag_p_show_author = esc_attr( $instance['supermag_p_show_author'] );
            $supermag_p_show_comment = esc_attr( $instance['supermag_p_show_comment'] );
            $supermag_p_content_words = esc_attr( $instance['supermag_p_content_words'] );
            $supermag_p_number = esc_attr( $instance['supermag_p_number'] );
            $supermag_p_column_number = esc_attr( $instance['supermag_p_column_number'] );
            $supermag_popular_show = esc_attr( $instance['supermag_popular_show'] );

            $supermag_r_title =  esc_attr( $instance['supermag_r_title'] );
            $supermag_r_selected_cat = esc_attr( $instance['supermag_r_cat'] );
            $supermag_r_enable_first_featured = esc_attr( $instance['supermag_r_enable_first_featured'] );
            $supermag_r_show_image = esc_attr( $instance['supermag_r_show_image'] );
            $supermag_r_show_cat = esc_attr( $instance['supermag_r_show_cat'] );
            $supermag_r_show_date = esc_attr( $instance['supermag_r_show_date'] );
            $supermag_r_show_author = esc_attr( $instance['supermag_r_show_author'] );
            $supermag_r_show_comment = esc_attr( $instance['supermag_r_show_comment'] );
            $supermag_r_content_words = esc_attr( $instance['supermag_r_content_words'] );
            $supermag_r_number = esc_attr( $instance['supermag_r_number'] );
            $supermag_r_column_number = esc_attr( $instance['supermag_r_column_number'] );
            $supermag_recent_show = esc_attr( $instance['supermag_recent_show'] );

            $supermag_c_title = esc_attr( $instance['supermag_c_title'] );
            $supermag_c_show_avatar = esc_attr( $instance['supermag_c_show_avatar'] );
            $supermag_c_show_post_title = esc_attr( $instance['supermag_c_show_post_title'] );
            $supermag_c_show_date = esc_attr( $instance['supermag_c_show_date'] );
            $supermag_c_content_words = esc_attr( $instance['supermag_c_content_words'] );
            $supermag_c_number = esc_attr( $instance['supermag_c_number'] );
            $supermag_c_column_number = esc_attr( $instance['supermag_c_column_number'] );
            $supermag_comment_show = esc_attr( $instance['supermag_comment_show'] );

            /*first featured post layout*/
            $supermag_post_col_first_featured_image_layout = esc_attr( $instance['supermag_post_col_first_featured_image_layout'] );

            /*normal featured image*/
            $supermag_post_col_normal_image_layout = esc_attr( $instance['supermag_post_col_normal_image_layout'] );
            echo $args['before_widget'];
            if ( !empty( $supermag_p_title ) || !empty( $supermag_r_title ) || !empty( $supermag_c_title ) ) {
                $supermag_tabs = array();

                if( 1 == $supermag_popular_show ){
                    $supermag_tabs['supermag_p_title_content'] = $supermag_p_title;
                }
                if( 1 == $supermag_recent_show ){
                    $supermag_tabs['supermag_r_title_content'] = $supermag_r_title;
                }
                if( 1 == $supermag_comment_show ){
                    $supermag_tabs['supermag_c_title_content'] = $supermag_c_title;
                }
                ?>
                <div class='sm-tabs-title' id="title-<?php echo esc_attr( $supermag_widget_id );?>">
                    <?php

                    echo $args['before_title'];
                    $i = 0;
                    if( !empty ( $supermag_tabs ) ){
                        foreach ($supermag_tabs as $key => $supermag_tab): ?>
                            <?php
                            if( $i == 0 ){
                                $supermag_tab_class = 'opened sm-tab-' . $key;
                            }
                            else{
                                $supermag_tab_class = 'sm-tab-' . $key;
                            }
                            ?>
                            <span class='<?php echo esc_attr( $supermag_tab_class); ?> single-tab-title' data-active="<?php echo esc_attr( $supermag_widget_id . '-' . $key ); ?>">
                                <?php echo esc_html( $supermag_tab ); ?>
                            </span>
                            <?php
                            $i++;
                        endforeach;
                    }
                    echo $args['after_title'];
                    ?>
                </div>
                <?php
            }
            ?>
            <div class="sm-tabs-content">
                <!--popular posts start-->
                <?php
                if( 'supermag-home' != $supermag_sidebar_id ){
                    $supermag_other_class = 'supermag-except-home';
                }
                else{
                    $supermag_other_class = '';
                }
                if( 1 == $supermag_popular_show ){

                    /**
                     * Filter the arguments for the Popular Posts widget.
                     *
                     * @since 1.0.0
                     *
                     * @see WP_Query
                     *
                     */
                    $supermag_p_query_args = array(
                        'post_type' => 'post',
                        'meta_key' => 'supermag_post_views_count',
                        'orderby' => 'meta_value_num',
                        'order' => 'DESC',
                        'posts_per_page' => $supermag_p_number,
                        'post_status' => 'publish',
                        'ignore_sticky_posts' => true
                    );
                    if( -1 != $supermag_p_selected_cat ){
                        $supermag_p_query_args['cat'] = $supermag_p_selected_cat;
                    }
                    $supermag_featured_query = new WP_Query($supermag_p_query_args);
                    if ( !$supermag_featured_query->have_posts()) :
                        $supermag_p_query_args = array(
                            'post_type' => 'post',
                            'posts_per_page' => $supermag_p_number,
                            'post_status' => 'publish',
                            'ignore_sticky_posts' => true
                        );
                        $supermag_featured_query = new WP_Query($supermag_p_query_args);
                    endif;
                    if ($supermag_featured_query->have_posts()) :
                        ?>
                        <div id="<?php echo esc_attr( $supermag_widget_id . '-' . 'supermag_p_title_content' ); ?>" class="<?php echo esc_attr( $supermag_other_class );?> opened featured-entries-col featured-entries featured-acme-col-posts popular-tab <?php echo esc_attr( $supermag_sidebar_id ); ?>">
                            <?php
                            $supermag_featured_index = 1;
                            if( 1 == $supermag_p_column_number ){
                                $supermag_column = 'acme-col-1';
                            }
                            elseif( 2 == $supermag_p_column_number ){
                                $supermag_column = 'acme-col-2';
                            }
                            elseif( 3 == $supermag_p_column_number ){
                                $supermag_column = 'acme-col-3';
                            }
                            elseif( 4 == $supermag_p_column_number ){
                                $supermag_column = 'acme-col-4';
                            }
                            else{
                                $supermag_column = 'acme-col-3';
                            }

                            while ( $supermag_featured_query->have_posts() ) :$supermag_featured_query->the_post();
                                if( 1 == $supermag_featured_index && 1 == $supermag_p_enable_first_featured ){
                                    $supermag_list_classes = $supermag_column.' featured-post-main';
                                    $thumb = $supermag_post_col_first_featured_image_layout;
                                }
                                else{
                                    $supermag_list_classes = $supermag_column;
                                    $thumb = $supermag_post_col_normal_image_layout;
                                }
                                ?>
                                <div class="<?php echo esc_attr( $supermag_list_classes ); ?>">
                                    <?php if ( 1 == $supermag_p_show_image ) {
                                        ?>
                                        <figure class="widget-image">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                if( has_post_thumbnail() ):
                                                    the_post_thumbnail( $thumb );
                                                else:
                                                    ?>
                                                    <div class="no-image-widgets">
                                                        <?php
                                                        the_title( sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        if( !get_the_title() ){
                                                            the_date( '', sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php
                                                endif;
                                                ?>
                                            </a>
                                        </figure>
                                        <?php
                                    }
                                    ?>
                                    <div class="featured-desc">
                                        <?php
                                        if( 1 == $supermag_p_show_date || 1 == $supermag_p_show_author || 1 == $supermag_p_show_comment ) { ?>
                                            <div class="above-entry-meta">
                                                <?php
                                                if ( 1 == $supermag_p_show_date ){
                                                    $archive_year  = get_the_date('Y');
                                                    $archive_month = get_the_date('m');
                                                    $archive_day   = get_the_date('d');
                                                    ?>
                                                    <span>
                                                        <i class="fa fa-calendar"></i>
                                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                            <?php echo get_the_date(); ?>
                                                        </a>
                                                    </span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_p_show_author ) { ?>
                                                    <span><i class="fa fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_p_show_comment ){ ?>
                                                    <span><i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?></span>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <a href="<?php the_permalink()?>">
                                            <h4 class="title">
                                                <?php the_title(); ?>
                                            </h4>
                                        </a>
                                        <?php
                                        if( 0 != $supermag_p_content_words){
                                            $content = supermag_words_count( get_the_excerpt(), $supermag_p_content_words);
                                            echo '<div class="details">'.$content.'</div>';
                                        }
                                        if( 1 == $supermag_p_show_cat ){?>
                                            <div class="below-entry-meta">
                                                <?php supermag_list_category(); ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                                if( 1 == $supermag_p_enable_first_featured ){
                                    $supermag_remainder_clear = 1;

                                }
                                else{
                                    $supermag_remainder_clear = 0;
                                }
                                if( 1 == $supermag_p_column_number && $supermag_featured_index % 1 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 2 == $supermag_p_column_number && $supermag_featured_index % 2 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 3 == $supermag_p_column_number && $supermag_featured_index % 3 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 4 == $supermag_p_column_number && $supermag_featured_index % 4 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                else{
                                    /*do nothing*/
                                }
                                $supermag_featured_index++;
                            endwhile; ?>
                        </div>
                        <?php
                        // Reset the global $the_post as this query will have stomped on it
                        wp_reset_postdata();
                        echo "<div class='clearfix'></div>";
                    endif;
                }

                /*
                 * <!--popular posts end-->
                <!--recent posts start-->
                */
                if( 1 == $supermag_recent_show ){
                    /**
                     * Filter the arguments for the Recent Posts.
                     *
                     * @since 1.0.0
                     *
                     * @see WP_Query
                     *
                     */
                    $supermag_r_query_args = array(
                        'post_type' => 'post',
                        'posts_per_page' => $supermag_r_number,
                        'post_status' => 'publish',
                        'ignore_sticky_posts' => true
                    );
                    if( -1 != $supermag_r_selected_cat ){
                        $supermag_r_query_args['cat'] = $supermag_r_selected_cat;
                    }
                    $supermag_featured_query = new WP_Query($supermag_r_query_args);

                    if ($supermag_featured_query->have_posts()) :
                        $opened = '';
                        if( 1 != $supermag_popular_show ){
                            $opened = 'opened';
                        }
                        ?>
                        <div id="<?php echo esc_attr( $supermag_widget_id . '-' . 'supermag_r_title_content' ); ?>" class="<?php echo esc_attr( $supermag_other_class );?> featured-entries-col featured-entries <?php echo esc_attr( $opened );?> featured-acme-col-posts <?php echo esc_attr( $supermag_sidebar_id ); ?>">
                            <?php
                            $supermag_featured_index = 1;
                            if( 1 == $supermag_r_column_number ){
                                $supermag_column = 'acme-col-1';
                            }
                            elseif( 2 == $supermag_r_column_number ){
                                $supermag_column = 'acme-col-2';
                            }
                            elseif( 3 == $supermag_r_column_number ){
                                $supermag_column = 'acme-col-3';
                            }
                            elseif( 4 == $supermag_r_column_number ){
                                $supermag_column = 'acme-col-4';
                            }
                            else{
                                $supermag_column = 'acme-col-3';
                            }
                            while ( $supermag_featured_query->have_posts() ) :$supermag_featured_query->the_post();
                                if( 1 == $supermag_featured_index && 1 == $supermag_r_enable_first_featured ){
                                    $supermag_list_classes = $supermag_column.' featured-post-main';
                                    $thumb = $supermag_post_col_first_featured_image_layout;
                                }
                                else{
                                    $supermag_list_classes = $supermag_column;
                                    $thumb = $supermag_post_col_normal_image_layout;
                                }
                                ?>
                                <div class="<?php echo esc_attr( $supermag_list_classes ); ?>">
                                    <?php if ( 1 == $supermag_r_show_image ) {
                                        ?>
                                        <figure class="widget-image">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                if( has_post_thumbnail() ):
                                                    the_post_thumbnail( $thumb );
                                                else:
                                                    ?>
                                                    <div class="no-image-widgets">
                                                        <?php
                                                        the_title( sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        if( !get_the_title() ){
                                                            the_date( '', sprintf( '<h2 class="caption-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php
                                                endif;
                                                ?>
                                            </a>
                                        </figure>
                                        <?php
                                    }
                                    ?>
                                    <div class="featured-desc">
                                        <?php
                                        if( 1 == $supermag_r_show_date || 1 == $supermag_r_show_author || 1 == $supermag_r_show_comment ) { ?>
                                            <div class="above-entry-meta">
                                                <?php
                                                if ( 1 == $supermag_r_show_date ){
                                                    $archive_year  = get_the_date('Y');
                                                    $archive_month = get_the_date('m');
                                                    $archive_day   = get_the_date('d');
                                                    ?>
                                                    <span>
                                                        <i class="fa fa-calendar"></i>
                                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                            <?php echo get_the_date(); ?>
                                                        </a>
                                                    </span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_r_show_author ) { ?>
                                                    <span><i class="fa fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
                                                    <?php
                                                }
                                                if( 1 == $supermag_r_show_comment ){ ?>
                                                    <span><i class="fa fa-comment"></i><?php comments_popup_link( '0', '1', '%' );?></span>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <a href="<?php the_permalink()?>">
                                            <h4 class="title">
                                                <?php the_title(); ?>
                                            </h4>
                                        </a>
                                        <?php
                                        if( 0 != $supermag_r_content_words){
                                            $content = supermag_words_count( get_the_excerpt(), $supermag_r_content_words);
                                            echo '<div class="details">'.$content.'</div>';
                                        }
                                        if( 1 == $supermag_r_show_cat ){?>
                                            <div class="below-entry-meta">
                                                <?php supermag_list_category(); ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                                if( 1 == $supermag_r_enable_first_featured ){
                                    $supermag_remainder_clear = 1;

                                }
                                else{
                                    $supermag_remainder_clear = 0;
                                }
                                if( 1 == $supermag_r_column_number && $supermag_featured_index % 1 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 2 == $supermag_r_column_number && $supermag_featured_index % 2 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 3 == $supermag_r_column_number && $supermag_featured_index % 3 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 4 == $supermag_r_column_number && $supermag_featured_index % 4 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                else{
                                    /*do nothing*/
                                }
                                $supermag_featured_index++;
                            endwhile; ?>
                        </div>
                        <?php
                        // Reset the global $the_post as this query will have stomped on it
                        wp_reset_postdata();
                    endif;
                }
               /*
                * <!--recent posts end-->
                <!--comment tab stat-->
               */
                if( 1 == $supermag_comment_show ){
                    /**
                     * Filter the arguments for the comments
                     *
                     * @since 1.0.0
                     *
                     * @see get_comments
                     *
                     */
                    $comment_args = array(
                        'number'      => $supermag_c_number,
                        'status'      => 'approve',
                        'post_status' => 'publish',
                    );

                    $comments = get_comments( $comment_args );
                    if ( ! empty( $comments ) ) {
                        $opened = '';
                        if( 1 != $supermag_popular_show && 1!= $supermag_recent_show ){
                            $opened = 'opened';
                        }
                        ?>
                        <div id="<?php echo esc_attr( $supermag_widget_id . '-' . 'supermag_c_title_content' ); ?>" class="<?php echo esc_attr( $supermag_other_class );?> featured-entries-col featured-entries featured-acme-col-posts <?php echo esc_attr( $opened );?> comments-col <?php echo esc_attr( $supermag_sidebar_id ); ?>">
                            <?php
                            $supermag_featured_index = 1;
                            if( 1 == $supermag_c_column_number ){
                                $supermag_column = 'acme-col-1';
                            }
                            elseif( 2 == $supermag_c_column_number ){
                                $supermag_column = 'acme-col-2';
                            }
                            elseif( 3 == $supermag_c_column_number ){
                                $supermag_column = 'acme-col-3';
                            }
                            elseif( 4 == $supermag_c_column_number ){
                                $supermag_column = 'acme-col-4';
                            }
                            else{
                                $supermag_column = 'acme-col-3';
                            }
                            foreach ( $comments as $key => $comment ) {
                                ?>
                                <div class="<?php echo esc_attr( $supermag_column ); ?>">
                                    <div class="comment-author vcard">
                                        <?php if ( 1 == $supermag_c_show_avatar ) {
                                            echo get_avatar( $comment->comment_author_email, '64');
                                        }
                                        printf(__('<cite class="fn">%s</cite>','supermag'), get_comment_author_link( $comment->comment_ID ));
                                        ?>
                                    </div>
                                    <div class="featured-desc">
                                        <?php
                                        if ( 1 == $supermag_c_show_post_title ){
                                            ?>
                                            <h4 class="title">
                                                <?php
                                                _e( 'on','supermag' );
                                                ?>
                                                <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
                                                    <?php echo esc_html( get_the_title( $comment->comment_post_ID ) ); ?>
                                                </a>
                                            </h4>
                                            <?php
                                        }
                                        if( 0 != $supermag_c_content_words){
                                            $content = supermag_words_count( $comment->comment_content, $supermag_c_content_words);
                                            echo '<div class="details">'.$content.'</div>';
                                        }
                                        if( 1 == $supermag_c_show_date ) { ?>
                                            <div class="comment-meta commentmetadata">
                                                <a href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>">
                                                    <i class="fa fa-clock-o"></i>
                                                    <?php
                                                    $date_format = get_option('date_format');
                                                    $time_format = get_option('time_format');
                                                    $comment_date = strtotime( $comment->comment_date );
                                                    /* translators: 1: date, 2: time */
                                                    printf(__('%1$s at %2$s', 'supermag'),esc_html( date($date_format, $comment_date ) ), esc_html( date($time_format, $comment_date) ) );
                                                    ?>
                                                </a>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                                $supermag_remainder_clear = 0;
                                if( 1 == $supermag_c_column_number && $supermag_featured_index % 1 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 2 == $supermag_c_column_number && $supermag_featured_index % 2 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 3 == $supermag_c_column_number && $supermag_featured_index % 3 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                elseif( 4 == $supermag_c_column_number && $supermag_featured_index % 4 == $supermag_remainder_clear ){
                                    echo "<div class='clearfix'></div>";
                                }
                                else{
                                    /*do nothing*/
                                }
                                $supermag_featured_index++;
                            }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
                <!--comment tab end-->
            </div>
            <?php
            echo $args['after_widget'];
            echo "<div class='clearfix'></div>";
        }
    }
endif;

/**
 * Function to Register and load the widget
 *
 * @since 1.0.0
 *
 * @param null
 * @return null
 *
 */
if ( ! function_exists( 'supermag_tabbed_widget' ) ) :

    function supermag_tabbed_widget() {
        register_widget( 'supermag_tabbed_widget' );
    }
endif;
add_action( 'widgets_init', 'supermag_tabbed_widget' );