<?php
/**
 * Register widget area.
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 *
 * @since SuperMag 1.0
 *
 * @param null
 * @return null
 *
 */

if ( ! function_exists( 'supermag_widget_init' ) ) :
    function supermag_widget_init(){

        $supermag_customizer_all_values = supermag_get_theme_options();

        register_sidebar(array(
            'name' => __('Main ( Right ) Sidebar Area', 'supermag'),
            'id'   => 'supermag-sidebar',
            'description' => __('Displays items on sidebar.', 'supermag'),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title"><span>',
            'after_title' => '</span></h3>',
        ));

	    register_sidebar(array(
		    'name' => __('Home Main Content Area', 'supermag'),
		    'id'   => 'supermag-home',
		    'description' => __('Displays widgets on home page main content area.', 'supermag'),
		    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		    'after_widget' => '</aside>',
		    'before_title' => '<h2 class="widget-title"><span>',
		    'after_title' => '</span></h2>',
	    ));

	    if( is_customize_preview() ){
		    $description = sprintf( __( ' Displays items on header area. Fit For Advertisement. You can put Advertisement from %1$s here %2$s too', 'supermag' ), '<a href="#" class="at-customizer" data-section="supermag-header-ad-option">','</a>' );
	    }
	    else{
		    $description = __('Displays items on header area. Fit For Advertisement', 'supermag');
	    }
	    register_sidebar(array(
		    'name' => __('Header Area', 'supermag'),
		    'id'   => 'supermag-header',
		    'description' => $description,
		    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		    'after_widget' => '</aside>',
		    'before_title' => '<h3 class="widget-title"><span>',
		    'after_title' => '</span></h3>',
	    ));

        register_sidebar(array(
            'name' => __('Menu Before Area', 'supermag'),
            'id'   => 'supermag-menu-before',
            'description' => __('Displays widgets on before menu area.', 'supermag'),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h2 class="widget-title"><span>',
            'after_title' => '</span></h2>',
        ));

	    register_sidebar(array(
		    'name' => __('Single After Content', 'supermag'),
		    'id'   => 'single-after-content',
		    'description' => __('Displays items on single post after content', 'supermag'),
		    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		    'after_widget' => '</aside>',
		    'before_title' => '<h3 class="widget-title"><span>',
		    'after_title' => '</span></h3>',
	    ));

        register_sidebar(array(
            'name' => __('Left Sidebar Area', 'supermag'),
            'id'   => 'supermag-sidebar-left',
            'description' => __('Displays items on left sidebar.', 'supermag'),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title"><span>',
            'after_title' => '</span></h3>',
        ));

	    register_sidebar(array(
		    'name' => __('Full Width Footer Area', 'supermag'),
		    'id'   => 'full-width-footer',
		    'description' => __('Displays items on Footer area.', 'supermag'),
		    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		    'after_widget' => '</aside>',
		    'before_title' => '<h3 class="widget-title"><span>',
		    'after_title' => '</span></h3>',
	    ));

        /*footer widgets*/
        $supermag_footer_top_widgets_number = $supermag_customizer_all_values['supermag-footer-top-widgets-number'];

        if( $supermag_footer_top_widgets_number > 0 ){

            if( $supermag_footer_top_widgets_number > 0 ){
                register_sidebar(array(
                    'name' => __('Footer Top Column One', 'supermag'),
                    'id' => 'footer-top-col-one',
                    'description' => __('Displays items on top footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_top_widgets_number > 1 ){
                register_sidebar(array(
                    'name' => __('Footer Top Column Two', 'supermag'),
                    'id' => 'footer-top-col-two',
                    'description' => __('Displays items on top footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_top_widgets_number > 2 ){
                register_sidebar(array(
                    'name' => __('Footer Top Column Three', 'supermag'),
                    'id' => 'footer-top-col-three',
                    'description' => __('Displays items on top footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_top_widgets_number > 3 ){
                register_sidebar(array(
                    'name' => __('Footer Top Column Four', 'supermag'),
                    'id' => 'footer-top-col-four',
                    'description' => __('Displays items on top footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
        }

        $supermag_footer_bottom_widgets_number = $supermag_customizer_all_values['supermag-footer-bottom-widgets-number'];

        if( $supermag_footer_bottom_widgets_number > 0 ){

            if( $supermag_footer_bottom_widgets_number > 0 ){
                register_sidebar(array(
                    'name' => __('Footer Bottom Column One', 'supermag'),
                    'id' => 'footer-bottom-col-one',
                    'description' => __('Displays items on bottom footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_bottom_widgets_number > 1 ){
                register_sidebar(array(
                    'name' => __('Footer Bottom Column Two', 'supermag'),
                    'id' => 'footer-bottom-col-two',
                    'description' => __('Displays items on bottom footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_bottom_widgets_number > 2 ){
                register_sidebar(array(
                    'name' => __('Footer Bottom Column Three', 'supermag'),
                    'id' => 'footer-bottom-col-three',
                    'description' => __('Displays items on bottom footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
            if( $supermag_footer_bottom_widgets_number > 3 ){
                register_sidebar(array(
                    'name' => __('Footer Bottom Column Four', 'supermag'),
                    'id' => 'footer-bottom-col-four',
                    'description' => __('Displays items on bottom footer section.', 'supermag'),
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title"><span>',
                    'after_title' => '</span></h3>',
                ));
            }
        }
    }
endif;
add_action('widgets_init', 'supermag_widget_init');