<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://www.acmethemes.com', // Site where EDD is hosted
		'item_name' => 'SuperMagPro', // Name of theme
		'theme_slug' => 'supermagpro', // Theme slug
		'version' => '2.0.0', // The current version of this theme
		'author' => 'Acme Themes', // The author of this theme
		'download_id' => '', // Optional, used for generating a license renewal link
		'renew_url' => '' // Optional, allows for a custom license renewal link
	),

	// Strings
	$strings = array(
		'theme-license' => __( 'Theme License', 'supermag' ),
		'enter-key' => __( 'Enter your theme license key.', 'supermag' ),
		'license-key' => __( 'License Key', 'supermag' ),
		'license-action' => __( 'License Action', 'supermag' ),
		'deactivate-license' => __( 'Deactivate License', 'supermag' ),
		'activate-license' => __( 'Activate License', 'supermag' ),
		'status-unknown' => __( 'License status is unknown.', 'supermag' ),
		'renew' => __( 'Renew?', 'supermag' ),
		'unlimited' => __( 'unlimited', 'supermag' ),
		'license-key-is-active' => __( 'License key is active.', 'supermag' ),
		'expires%s' => __( 'Expires %s.', 'supermag' ),
		'%1$s/%2$-sites' => __( 'You have %1$s / %2$s sites activated.', 'supermag' ),
		'license-key-expired-%s' => __( 'License key expired %s.', 'supermag' ),
		'license-key-expired' => __( 'License key has expired.', 'supermag' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'supermag' ),
		'license-is-inactive' => __( 'License is inactive.', 'supermag' ),
		'license-key-is-disabled' => __( 'License key is disabled.', 'supermag' ),
		'site-is-inactive' => __( 'Site is inactive.', 'supermag' ),
		'license-status-unknown' => __( 'License status is unknown.', 'supermag' ),
		'update-notice' => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'supermag' ),
		'update-available' => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'supermag' )
	)
);