<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
get_header();
global $supermag_customizer_all_values;
$supermag_blog_col = $supermag_customizer_all_values['supermag-blog-col'];
$supermag_archive_col = $supermag_customizer_all_values['supermag-archive-col'];
?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main">

		<?php if ( have_posts() ) :
            if ( is_home() && ! is_front_page() ) : ?>
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
				</header>
			<?php endif;
			/* Start the Loop */
			$at_index = 0;

			while ( have_posts() ) : the_post();

				if( is_home() && !is_sticky( )){
					if( 2 == $supermag_blog_col ){
						echo "<div class='blog-col acme-col-2'>";
					}
                    elseif( 3 == $supermag_blog_col ){
						echo "<div class='blog-col acme-col-3'>";
					}
				}
                elseif( is_archive() && !is_sticky( )){
					if( 2 == $supermag_archive_col ){
						echo "<div class='blog-col acme-col-2'>";
					}
                    elseif( 3 == $supermag_archive_col ){
						echo "<div class='blog-col acme-col-3'>";
					}
				}
					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );

				if( is_home() && !is_sticky( )){
					if( 2 == $supermag_blog_col ){
						echo "</div>";
						$at_index++;
					}
                    elseif( 3 == $supermag_blog_col ){
						echo "</div>";
						$at_index++;
					}
					if( $at_index % $supermag_blog_col == 0 ){
						echo "<div class='clearfix'></div>";

					}
				}
                elseif( is_archive() && !is_sticky( )){
					if( 2 == $supermag_archive_col ){
						echo "</div>";
						$at_index++;
					}
                    elseif( 3 == $supermag_archive_col ){
						echo "</div>";
						$at_index++;
					}
					if( $at_index % $supermag_archive_col == 0 ){
						echo "<div class='clearfix'></div>";
					}
				}
            endwhile;
			echo "<div class='clearfix'></div>";

			/**
			 * supermag_action_navigation hook
			 * @since SuperMag 1.0.0
			 *
			 * @hooked: supermag_posts_navigation - 10
			 *
			 */
			do_action( 'supermag_action_navigation' );
			else :
                get_template_part( 'template-parts/content', 'none' );
			endif;
			?>
		</main><!-- #main -->
	</div><!-- #primary -->
<?php
get_sidebar( 'left' );
get_sidebar();
get_footer();