<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
$supermag_customizer_all_values = supermag_get_theme_options();

get_header(); ?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
            <?php
            while ( have_posts() ) : the_post();

                get_template_part( 'template-parts/content', 'single' );
				if( "disable" != $supermag_customizer_all_values['supermag-single-navigation-options'] ){
					if( 'title-image' == $supermag_customizer_all_values['supermag-single-navigation-options'] ){
						supermag_single_navigation( get_the_ID(), 'title-image');
					}
                    elseif( 'image-only' == $supermag_customizer_all_values['supermag-single-navigation-options'] ){
						supermag_single_navigation( get_the_ID(), 'image-only');
					}
					else{
						the_post_navigation();
					}
				}

                /*single after content*/
				if( is_active_sidebar( 'single-after-content' ) ) :
					dynamic_sidebar( 'single-after-content' );
				endif;

				$supermag_related_posts_data = supermag_related_posts_data( get_the_ID() );
				$supermag_related_posts_display = $supermag_related_posts_data['supermag-related-posts-display'];
				if( 'default-related-posts' == $supermag_related_posts_display ){
					$supermag_related_posts_display = esc_attr( $supermag_customizer_all_values['supermag-related-posts-display'] );
				}
				if( !empty( $supermag_related_posts_display ) && 'below-related-posts' == $supermag_related_posts_display ) {
					supermag_related_posts(get_the_ID());
				}

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
            endwhile; // End of the loop.
            ?>
		</main><!-- #main -->
	</div><!-- #primary -->
<?php
get_sidebar( 'left' );
get_sidebar();
get_footer();