<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
$supermag_customizer_all_values = supermag_get_theme_options();
$supermag_get_image_sizes_options = $supermag_customizer_all_values['supermag-blog-archive-image-size'];

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
			<div class="entry-meta">
				<?php supermag_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->
	<?php
	$blog_thumbnails = supermag_blog_image_size();
	if( 'no-image' != $blog_thumbnails['thumb_size'] ){
		?>
		<div class="post-thumb">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php
				the_post_thumbnail( $supermag_get_image_sizes_options );
				?>
			</a>
		</div>
		<?php
	}
	?>
	<div class="entry-content">
		<?php
		supermag_blog_content_layout();
		$supermag_blog_archive_read_more = supermag_blog_archive_more_text();
		if( !empty( $supermag_blog_archive_read_more )){
			?>
			<a class="read-more" href="<?php the_permalink(); ?> ">
				<?php echo $supermag_blog_archive_read_more; ?>
			</a>
		<?php
		}
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'supermag' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->
	<footer class="entry-footer">
		<?php supermag_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->