<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
$supermag_customizer_all_values = supermag_get_theme_options();
$supermag_single_image_layout = $supermag_customizer_all_values['supermag-single-image-layout'];
$supermag_single_category_display_options = $supermag_customizer_all_values['supermag-single-category-display-options'];

$supermag_single_show_cats = $supermag_customizer_all_values['supermag-single-show-cats'];
$supermag_single_show_tags = $supermag_customizer_all_values['supermag-single-show-tags'];
$supermag_single_show_date = $supermag_customizer_all_values['supermag-single-show-date'];
$supermag_single_show_author = $supermag_customizer_all_values['supermag-single-show-author'];
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		<div class="entry-meta">
			<?php
            supermag_posted_on($supermag_single_show_date, $supermag_single_show_author ); ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->
	<?php
	$supermag_single_post_layout = supermag_featured_image_display( get_the_ID() );

	$supermag_video_url = get_post_meta( get_the_ID(), 'supermag_video_url', true );
	$supermag_replace_featured_image = get_post_meta( get_the_ID(), 'supermag_replace_featured_image', true );
	$supermag_video_autoplay = get_post_meta( get_the_ID(), 'supermag_video_autoplay', true );

	if( ( has_post_thumbnail() && 'no-image' != $supermag_single_post_layout ) ||
		( !empty( $supermag_video_url ) && 1 == $supermag_replace_featured_image )
	){
		?>
		<div class="single-feat clearfix">
			<?php
			$supermag_related_posts_data = supermag_related_posts_data( get_the_ID() );
			$supermag_related_posts_display = $supermag_related_posts_data['supermag-related-posts-display'];
			if( 'default-related-posts' == $supermag_related_posts_display ){
				$supermag_related_posts_display = esc_attr( $supermag_customizer_all_values['supermag-related-posts-display'] );
			}

			if( 'left-related-posts' == $supermag_related_posts_display || 'right-related-posts' == $supermag_related_posts_display ){
				$single_thumb = 'left-right-related';
				if( 'left-related-posts' == $supermag_related_posts_display ){
					$left_related_posts = 'related-post-left';
					$video_width = 660;
					$video_height = 365;
				}
				else{
					$left_related_posts = '';
					$video_width = 840;
					$video_height = 480;
				}
				?>
				<div class="related-post <?php echo esc_attr( $left_related_posts ); ?>">
					<h2 class="widget-title">
						<?php echo esc_html($supermag_related_posts_data['supermag-related-title']); ?>
					</h2>
					<?php supermag_related_posts( get_the_ID() ); ?>
				</div>
				<?php
			}
			else{
				$video_width = 840;
				$video_height = 480;
				$single_thumb = 'single-thumb-full';
			}
			?>
			<figure class="single-thumb <?php echo esc_attr( $single_thumb )?>">
				<?php
				$supermag_video_url = get_post_meta( get_the_ID(), 'supermag_video_url', true );
				$supermag_replace_featured_image = get_post_meta( get_the_ID(), 'supermag_replace_featured_image', true );
				$supermag_video_autoplay = get_post_meta( get_the_ID(), 'supermag_video_autoplay', true );
				if( !empty( $supermag_video_url ) && 1 == $supermag_replace_featured_image ){
					$supermag_video_final_url = $supermag_video_url."?autoplay=".$supermag_video_autoplay;
					?>
					<iframe src="<?php echo esc_url( $supermag_video_final_url ); ?>" style="overflow:hidden;max-height:100%;max-width:100%" width="<?php echo esc_attr( $video_width );?>" height="<?php echo esc_attr( $video_height );?>" frameborder="0" allowfullscreen></iframe>
					<?php
				}
				else{
					the_post_thumbnail( $supermag_single_image_layout );
				}
				?>
			</figure>
		</div>
	<?php
	}
	?>
	<div class="entry-content">
		<?php
        the_content();
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'supermag' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->
    <footer class="entry-footer featured-desc">
		<?php
		if( 'cat-color' == $supermag_single_category_display_options && 1 == $supermag_single_show_cats){
			?>
            <div class="below-entry-meta">
				<?php supermag_list_category(); ?>
            </div>
			<?php
			$supermag_single_show_cats = 0;
		}
		supermag_entry_footer( $supermag_single_show_cats, $supermag_single_show_tags);
		?>
    </footer><!-- .entry-footer -->
	<?php
	/*author bio*/
	$supermag_show_author_info = $supermag_customizer_all_values['supermag-show-author-info'];
	if( 1 == $supermag_show_author_info ){
		get_template_part( 'template-parts/content', 'author' );
	}
	?>
</article><!-- #post-## -->