<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage SuperMag
 */
$supermag_customizer_all_values = supermag_get_theme_options();
$supermag_get_image_sizes_options = $supermag_customizer_all_values['supermag-blog-archive-image-size'];
$supermag_blog_archive_category_display_options = $supermag_customizer_all_values['supermag-blog-archive-category-display-options'];

$supermag_blog_archive_show_cats = $supermag_customizer_all_values['supermag-blog-archive-show-cats'];
$supermag_blog_archive_show_tags = $supermag_customizer_all_values['supermag-blog-archive-show-tags'];
$supermag_blog_archive_show_comments = $supermag_customizer_all_values['supermag-blog-archive-show-comments'];
$supermag_blog_archive_show_date = $supermag_customizer_all_values['supermag-blog-archive-show-date'];
$supermag_blog_archive_show_author = $supermag_customizer_all_values['supermag-blog-archive-show-author'];
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
        the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
		if ( 'post' == get_post_type() ) : ?>
			<div class="entry-meta">
				<?php supermag_posted_on($supermag_blog_archive_show_date, $supermag_blog_archive_show_author ); ?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->
	<?php
	$no_fs = '';
	$blog_thumbnails = supermag_blog_image_size();
	if( 'no-image' != $blog_thumbnails['thumb_size'] &&  has_post_thumbnail() ){
		?>
		<div class="post-thumb">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php
				the_post_thumbnail( $supermag_get_image_sizes_options );
				?>
			</a>
		</div>
		<?php
	}
	else{
		$no_fs = 'at-no-fs';
	}
	?>
	<div class="entry-content <?php echo $no_fs;?>">
		<?php
		supermag_blog_content_layout();
		$supermag_blog_archive_read_more = supermag_blog_archive_more_text();
		if( !empty( $supermag_blog_archive_read_more )){
			?>
			<a class="read-more" href="<?php the_permalink(); ?> ">
				<?php echo $supermag_blog_archive_read_more; ?>
			</a>
		<?php
		}
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'supermag' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->
	<?php
	$entry_footer = '';
	if( 'cat-color' == $supermag_blog_archive_category_display_options){
		$entry_footer = 'featured-desc';
	}
	?>
    <footer class="entry-footer <?php echo $entry_footer; ?>">
		<?php
		if( 'cat-color' == $supermag_blog_archive_category_display_options && 1 == $supermag_blog_archive_show_cats ){
			?>
            <div class="below-entry-meta">
				<?php supermag_list_category(); ?>
            </div>
			<?php
			$supermag_blog_archive_show_cats = 0;
		}
		supermag_entry_footer( $supermag_blog_archive_show_cats, $supermag_blog_archive_show_tags, $supermag_blog_archive_show_comments);
		?>
    </footer><!-- .entry-footer -->
</article><!-- #post-## -->